VC=NaN(12,8); % edge density
IM=NaN(12,8,157,242,3); % matrix cell for storage (RGB)
warning off all
X=imread('example_item.png');
figure
imshow(X);hold on

% horizontal lines - response alternatives
plot([458 715],[603 603],'g--')
plot([458 715],[827 827],'g--')
plot([716 972],[603 603],'g--')
plot([716 972],[827 827],'g--')

plot([973 1230],[603 603],'g--')
plot([973 1230],[827 827],'g--')

plot([1231 1488],[603 603],'g--')
plot([1231 1488],[827 827],'g--')

% horizontal lines - response alternatives
plot([458 715],[833 833],'g--')
plot([458 715],[1057 1057],'g--')

plot([716 972],[833 833],'g--')
plot([716 972],[1057 1057],'g--')

plot([973 1230],[833 833],'g--')
plot([973 1230],[1057 1057],'g--')

plot([1231 1488],[833 833],'g--')
plot([1231 1488],[1057 1057],'g--')


% vertical lines - response alternatives
plot([458 458],[603 827],'g--')
plot([715 715],[603 827],'g--')

plot([716 716],[603 827],'g--')
plot([972 972],[603 827],'g--')

plot([973 973],[603 827],'g--')
plot([1230 1230],[603 827],'g--')

plot([1231 1231],[603 827],'g--')
plot([1488 1488],[603 827],'g--')

% vertical lines - response alternatives
plot([458 458],[833 1057],'g--')
plot([715 715],[833 1057],'g--')

plot([716 716],[833 1057],'g--')
plot([972 972],[833 1057],'g--')

plot([973 973],[833 1057],'g--')
plot([1230 1230],[833 1057],'g--')

plot([1231 1231],[833 1057],'g--')
plot([1488 1488],[833 1057],'g--')


% horizontal lines - matrix
plot([599 846],[51 51],'g--')
plot([847 1094],[51 51],'g--')
plot([1095 1342],[51 51],'g--')

text(599+10,51,'W:3','color','c','horizontalalignment','left','verticalalignment','top','fontsize',12)
text(847+10,51,'W:5','color','c','horizontalalignment','left','verticalalignment','top','fontsize',12)
text(1095+10,51,'W:3','color','c','horizontalalignment','left','verticalalignment','top','fontsize',12)

plot([599 846],[213 213],'g--')
plot([847 1094],[213 213],'g--')
plot([1095 1342],[213 213],'g--')

plot([599 846],[214 214],'g--')
plot([847 1094],[214 214],'g--')
plot([1095 1342],[214 214],'g--')

text(599+10,214,'W:5','color','c','horizontalalignment','left','verticalalignment','top','fontsize',12)
text(847+10,214,'W:8','color','c','horizontalalignment','left','verticalalignment','top','fontsize',12)
text(1095+10,214,'W:5','color','c','horizontalalignment','left','verticalalignment','top','fontsize',12)

plot([599 846],[376 376],'g--')
plot([847 1094],[376 376],'g--')
plot([1095 1342],[376 376],'g--')

plot([599 846],[377 377],'g--')
plot([847 1094],[377 377],'g--')
plot([1095 1342],[377 377],'g--')

text(599+10,377,'W:3','color','c','horizontalalignment','left','verticalalignment','top','fontsize',12)
text(847+10,377,'W:5','color','c','horizontalalignment','left','verticalalignment','top','fontsize',12)
text(1095+10,377,'W:3','color','c','horizontalalignment','left','verticalalignment','top','fontsize',12)

plot([599 846],[539 539],'g--')
plot([847 1094],[539 539],'g--')
plot([1095 1342],[539 539],'g--')

% vertical lines - matrix
plot([599 599],[51 213],'g--')
plot([599 599],[214 376],'g--')
plot([599 599],[377 539],'g--')

plot([846 846],[51 213],'g--')
plot([846 846],[214 376],'g--')
plot([846 846],[377 539],'g--')

plot([846 846],[51 213],'g--')
plot([846 846],[214 376],'g--')
plot([846 846],[377 539],'g--')

plot([847 847],[51 213],'g--')
plot([847 847],[214 376],'g--')
plot([847 847],[377 539],'g--')

plot([1094 1094],[51 213],'g--')
plot([1094 1094],[214 376],'g--')
plot([1094 1094],[377 539],'g--')

plot([1095 1095],[51 213],'g--')
plot([1095 1095],[214 376],'g--')
plot([1095 1095],[377 539],'g--')

plot([1342 1342],[51 213],'g--')
plot([1342 1342],[214 376],'g--')
plot([1342 1342],[377 539],'g--')
%F = getframe(gca);imwrite(F.cdata, 'Figure1.png');

%% Compute edge density of all cells
compute_edge_density=0;
if compute_edge_density==1
    for i=1:12 % loop over 12 Raven items
        filename=['Item' num2str(i) '.png'];
        X=imread(filename);
        for i2=1:9 % loop over 9 cells of problem area
            switch i2
                case 1
                    xi=599:846;
                    yi=51:213;
                case 4
                    xi=599:846;
                    yi=214:376;
                case 7
                    xi=599:846;
                    yi=377:539;
                case 2
                    xi=847:1094;
                    yi=51:213;
                case 5
                    xi=847:1094;
                    yi=214:376;
                case 8
                    xi=847:1094;
                    yi=377:539;
                case 3
                    xi=1095:1342;
                    yi=51:213;
                case 6
                    xi=1095:1342;
                    yi=214:376;
                case 9
                    xi=1095:1342;
                    yi=377:539;
            end
            xi(1:2)=[];
            yi(1:2)=[];
            xi(end-1:end)=[];
            yi(end-1:end)=[];
            [size(xi) size(yi)];

            im=(X(yi(1):1:yi(end),xi(1):1:xi(end),:));
            im([1 end],:,:)=[];
            im(:,[1 end],:)=[];
            if i2<=8 % for the 8 cells with content
                VC(i,i2)=mean(mean(edge(im(:,:,1),'sobel')));
                IM(i,i2,:,:,:)=im;
            end
        end
    end
    save('edge_density_and_cell_content','VC','IM')
else
    load('edge_density_and_cell_content.mat')
end
