function [X,Y,UX,UY,x,y,L,a,epsilon,theta,b,boverLg,u_av,...
    y0_str,ux_av_str_HP,ux_av_HP,area_str_HP,phi_A_str_HP,phi_av_str_HP,phi_A_HP,cum_phi_A_str_HP, ...
    area_str,ux_av_str,phi_A_str,phi_shear_A_str,phi_deform_A_str,phi_av_str,...
    cum_phi_A_str,cum_phi_shear_A_str,cum_phi_deform_A_str,title_HP] ...
    = VDimportcomsol(filename,fig_on,option)
%% -- import data/velocity field from COMSOL
% [...,...,...] = VDimportcomsol(filename,fig_on)
% example filename = 'bm_9deg';
% if fig_on == 0 > do not display figures
% if fig_on ~= 0 > do display figures
%
% Normalisation options
% all options are computed, but for plotting one need to be selected
% 1. [HP1] H-P (Hagen-Poiseuille) flow with u_av = 1
% 2. [HP2] H-P flow with same u_av as bubble mattress (BM)
% 3. [HP3] H-P flow with same phi_A as bubble mattress
% 4. [HP4] One-sided H-P slip flow with same slip length and u_av as bubble mattress
% 5. [HP5] One-sided H-P slip flow with same slip length and phi_A as bubble mattress

% clear all variables, except input variables
% needs to be disables when calling this function in another function
% clearvars -except filename fig_on
% close all

% set(0,'DefaultFigureColormap',paruly);
%matfile = ['comsol' '/' filename];
matfile = [filename];
if exist([matfile '.mat'], 'file') ~= 2
    tStart = tic;
 
    % reading data requires that data, have a regular grid (!), is sorted on M(:,1), i.e. on first data
    % point in csv-file
    csvfile = [matfile '.csv'];
    M = csvread(csvfile,9,0); % start reading from cell (9,0), numbering is zero-based
    x_in = M(:,1);
    y_in = M(:,2);
    ux_in = M(:,3);
    uy_in = M(:,4);
    p_in = M(:,5);
    phi_in = M(:,6);
    phi_shear_in = M(:,7);
    theta = M(1,8); % alpha has same value for each cell
    epsilon = M(1,9); % epsilon has same value for each cell
    boverLg = M(1,10); % dim.less slip length 2b/Lg has same value for each cell
    
    m = length(x_in(find(x_in == min(x_in))));     % find size of data matrix in z-direction
    n = length(x_in) / m;
    
    Y = zeros(m,n);
    X = zeros(m,n);
    
    for j = 1:n
        X(:,j) = x_in((1+(j-1)*m):(j*m));
        Y(:,j) = y_in((1+(j-1)*m):(j*m));
        UX(:,j) = ux_in((1+(j-1)*m):(j*m));
        UY(:,j) = uy_in((1+(j-1)*m):(j*m));
        P(:,j) = p_in((1+(j-1)*m):(j*m));
        PHI(:,j) = phi_in((1+(j-1)*m):(j*m));
        PHI_shear(:,j) = phi_shear_in((1+(j-1)*m):(j*m));
    end
    
    display(['The bubble protrusion angle theta = ' num2str(theta/pi*180) ' deg'])
    
    % extract vector from which grid is originally contructed
    x = X(1,:);
    y = Y(:,1);
    
    % read streamline data exported by comsol
    csvfile = [matfile '_streamlines.csv'];
    N = csvread(csvfile,8,0);
    xstr_in = N(:,1);
    ystr_in = N(:,2);
    str_in = N(:,3);
    
    %% compute real slip length and average flow velocity
    % compute a = H/L, where H = 1 by definition
    L = max(x);
    a = 1/L;
    b = boverLg*epsilon/(2*a);
    u_av = simps(Y(:,1),UX(:,1)); % divided by H = 1 (by definition)
    
    %% compute streamline data
    nop = length(x); % number of points
    Xstr0 = linspace(0,max(x),nop);
    
    n_str = max(str_in) + 1; % number of streamlines (first line has index 0)
    for j = 1:n_str
        indices = find(str_in == j-1);
        xstr{j} = xstr_in(indices); % use of cells, as no. of point may differ per streamline
        ystr{j} = ystr_in(indices);
        Ystr(j,:) = interp1(xstr{j},ystr{j},Xstr0,'spline'); % make a matrix of the streamlines
    end
    Xstr = ones(n_str,1)*Xstr0; % or use the repmat function
    
    % compute location of lower bubble (b) wall and of top (t) wall
    Rb = (0.5*epsilon*L)/sin(theta);
    % Xb = linspace(L/2-Rb,L/2+Rb,2*Rb/(max(x)/(nop-1)));
    range = find(Xstr0 >= L/2-0.5*epsilon*L & Xstr0 <= L/2+0.5*epsilon*L);
    Xb = Xstr0(range);
    Yb = zeros(1,nop);
    for j = 1:length(Xb)
        s(j) = acos((Xb(j)-L/2)/Rb);
        Yb(range(j)) = -(0.5*epsilon*L)*cos(theta)/sin(theta) + Rb.*sin(s(j));
    end
    Yt = max(y)*ones(1,nop);
    
    % add bubble and top wall to streamlines
    Xstr = ones(n_str+2,1)*Xstr0;
    Ystr = cat(1,Yb,Ystr,Yt);
    
    %% data analysis -- stream tubes
    
    % compute midpoint of 2D stream tubes
    n_str = length(Ystr(:,1));
    y0_str = zeros(n_str-1,1); 
    for j=2:n_str
        y0_str(j-1) = 0.5*(Ystr(j,1) + Ystr(j-1,1));
    end
     
    % compute the integral of the area
    area_str = zeros(n_str-1,1); % area of 2D stream tube
    dYstr = 0.*Ystr;
    for j=2:n_str
        dYstr(j,:) = Ystr(j,:) - Ystr(j-1,:);
        area_str(j-1) = simps(Xstr(j,:),dYstr(j,:));
    end
    area = sum(area_str); % total area of domain
    area_b = simps(Xstr(1,:),Ystr(1,:)); % area of bubble
    display(['The area of the domain is A = ' num2str(area)])
    display(['The area of the bubble is A_b = ' num2str(area_b)])
    % plot(yarea,area_str,'ok')
    
    %% data analysis -- dissipation
    
    % compute average dissipation for package along streamline/in streamline tube
    phi_A_str = zeros(n_str-1,1); % A_str is 2D area of stream tube
    phi_shear_A_str = zeros(n_str-1,1); % A_str is 2D area of stream tube
    phi_hold = zeros(n_str-1,nop); % preallocate matrix
    phi_shear_hold = zeros(n_str-1,nop); % preallocate matrix
    PHI_interp = PHI;
    PHI_interp(isnan(PHI_interp)) = 0 ; % interpolation does not work with NaN in matrix
    PHI_shear_interp = PHI_shear;
    PHI_shear_interp(isnan(PHI_shear_interp)) = 0 ; % interpolation does not work with NaN in matrix
    
    noip = round((length(y)-1)/length(y0_str)*3); % number of interpolation points
    display(['The number of interpolation points is ' num2str(noip)])
    %tic
    for j=2:n_str
        for k=1:nop
            x_interp = ones(1,noip).*Xstr(j,k);
            y_interp = linspace(Ystr(j-1,k),Ystr(j,k),noip);
            phi_interp = interp2(X,Y,PHI_interp,x_interp,y_interp,'cubic',0);
            phi_shear_interp = interp2(X,Y,PHI_shear_interp,x_interp,y_interp,'cubic',0);
            phi_hold(j,k) = simps(y_interp,phi_interp);
            phi_shear_hold(j,k) = simps(y_interp,phi_shear_interp);
        end
        phi_A_str(j-1) = simps(Xstr(j,:),phi_hold(j,:)); % dissipation rate per 2D stream tube (integration over area)
        phi_shear_A_str(j-1) = simps(Xstr(j,:),phi_shear_hold(j,:)); % dissipation rate by shear per 2D stream tube (integration over area)
    end
    %toc
    phi_deform_A_str = phi_A_str - phi_shear_A_str; % dissipation rate by deformation per 2D stream tube (integration over area)
    phi_av_str = phi_A_str./area_str; % average dissipation rate per 0D stream line
    phi_A = sum(phi_A_str); % total dissipation in 2D domain with area A
    phi_av = phi_A/area; % average dissipation rate in domain
    display(['The average dissipation rate in the domain is phi_av = ' num2str(phi_av)])
    display(['The total dissipation in the domain is phi_A = int_A (phi) dA = ' num2str(phi_A)])
%     hold on
%     plot(y0_str,phi_A_str,'ok')
%     plot(y0_str,phi_shear_A_str,'sb')
%     plot(y0_str,phi_deform_A_str,'dr')
%     hold off
    
    % compute cumulative integral of dissipation per 2D stream tube
    cum_phi_A_str = zeros(n_str-1,1);
    cum_phi_shear_A_str = zeros(n_str-1,1);
    cum_phi_deform_A_str = zeros(n_str-1,1);
    for j=1:length(phi_A_str)
        cum_phi_A_str(j) = sum(phi_A_str(1:j,1));
        cum_phi_shear_A_str(j) = sum(phi_shear_A_str(1:j,1));
        cum_phi_deform_A_str(j) = sum(phi_deform_A_str(1:j,1));
    end
    % plot(y0_str,cum_phi_A_str,'ok')  

    %% normalisation of data -- dissipation
    
    % compute enhancement factors
    ef1 = 1; % [HP1]
    ef2 = u_av; % [HP2]
    ef3 = sqrt(phi_A/(12*L)); % [HP3]
    ef4 = 1; % [HP4]
    ef5 = (1/phi_A*L*6/(1+b)^3*(1-(1-2*(1+b))^3))^(-0.5); % [HP5]
        
    % compute parameters for HP (slip) flow for all five options
    dYstr_HP = zeros(n_str-1,1);
    area_str_HP = zeros(n_str-1,1); % area of 2D stream tube
    phi_A_str_HP1 = zeros(n_str-1,1);
    phi_A_str_HP2 = zeros(n_str-1,1);
    phi_A_str_HP3 = zeros(n_str-1,1);
    phi_A_str_HP4 = zeros(n_str-1,1);
    phi_A_str_HP5 = zeros(n_str-1,1);
    for j=2:n_str
        dYstr_HP(j) = Ystr(j,1) - Ystr(j-1,1); % same for all normalisation options
        area_str_HP(j-1) = dYstr_HP(j)*L; % same for all normalisation options
        % option 1 [HP1]
        phi_A_str_HP1(j-1) = ef1^2*36*L*(4/3*(Ystr(j,1)^3-Ystr(j-1,1)^3) ...
            -2*(Ystr(j,1)^2-Ystr(j-1,1)^2) + (Ystr(j,1)-Ystr(j-1,1)));
        % option 2 [HP2]
        phi_A_str_HP2(j-1) = ef2^2*36*L*(4/3*(Ystr(j,1)^3-Ystr(j-1,1)^3) ...
            -2*(Ystr(j,1)^2-Ystr(j-1,1)^2) + (Ystr(j,1)-Ystr(j-1,1)));
        % option 3 [HP3]
        phi_A_str_HP3(j-1) = ef3^2*36*L*(4/3*(Ystr(j,1)^3-Ystr(j-1,1)^3) ...
            -2*(Ystr(j,1)^2-Ystr(j-1,1)^2) + (Ystr(j,1)-Ystr(j-1,1)));
        % option 4 [HP4]
        phi_A_str_HP4(j-1) = L*(-6*ef4^2/(1+b)^3)*...
        (((1-2*(b+1)*Ystr(j,1))^3)-...
        ((1-2*(b+1)*Ystr(j-1,1))^3));
        % option 5 [HP5]
        phi_A_str_HP5(j-1) = L*(-6*ef5^2/(1+b)^3)*...
        (((1-2*(b+1)*Ystr(j,1))^3)-...
        ((1-2*(b+1)*Ystr(j-1,1))^3));
    end
    phi_A_str_HPall = cat(2,phi_A_str_HP1,phi_A_str_HP2,phi_A_str_HP3,...
        phi_A_str_HP4,phi_A_str_HP5);
    
    % compute average dissipation per stream tube (thus, Pa/s)
    phi_av_str_HP1 = phi_A_str_HP1./area_str_HP;
    phi_av_str_HP2 = phi_A_str_HP2./area_str_HP;
    phi_av_str_HP3 = phi_A_str_HP3./area_str_HP;
    phi_av_str_HP4 = phi_A_str_HP4./area_str_HP;
    phi_av_str_HP5 = phi_A_str_HP5./area_str_HP;
    phi_av_str_HPall = cat(2,phi_av_str_HP1,phi_av_str_HP2,phi_av_str_HP3,...
        phi_av_str_HP4,phi_av_str_HP5);
    % plot(y0_str,phi_av_str_HP);
    
    % compute cumulative dissipation per stream tube
    cum_phi_A_str_HP1 = zeros(n_str-1,1);
    cum_phi_A_str_HP2 = zeros(n_str-1,1);
    cum_phi_A_str_HP3 = zeros(n_str-1,1);
    cum_phi_A_str_HP4 = zeros(n_str-1,1);
    cum_phi_A_str_HP5 = zeros(n_str-1,1);
    for j=1:n_str-1
        cum_phi_A_str_HP1(j) = sum(phi_A_str_HP1(1:j,1));
        cum_phi_A_str_HP2(j) = sum(phi_A_str_HP2(1:j,1));
        cum_phi_A_str_HP3(j) = sum(phi_A_str_HP3(1:j,1));
        cum_phi_A_str_HP4(j) = sum(phi_A_str_HP4(1:j,1));
        cum_phi_A_str_HP5(j) = sum(phi_A_str_HP5(1:j,1));
    end
    cum_phi_A_str_HPall = cat(2,cum_phi_A_str_HP1,cum_phi_A_str_HP2,...
        cum_phi_A_str_HP3,cum_phi_A_str_HP4,cum_phi_A_str_HP5);
    
    % compute total dissipation for each option
    phi_A_HP1 = 12*ef1*L;
    phi_A_HP2 = 12*ef2^2*L;
    phi_A_HP3 = 12*ef3^2*L;
    phi_A_HP4 = L*ef4^2*6/(1+b)^3.*(1-(1-2*(1+b))^3);
    phi_A_HP5 = L*ef5^2*6/(1+b)^3.*(1-(1-2*(1+b))^3);
    phi_A_HPall = cat(2,phi_A_HP1,phi_A_HP2,phi_A_HP3,...
        phi_A_HP4,phi_A_HP5);
    
    % normalisation curve to output corresponds to option
    phi_A_str_HP = phi_A_str_HPall(:,option);
    phi_av_str_HP = phi_av_str_HPall(:,option);
    cum_phi_A_str_HP = cum_phi_A_str_HPall(:,option);
    phi_A_HP = phi_A_HPall(:,option);
    
    % title corresponding to output option
    titles = {'H-P flow with u_{av} = 1 [HP1]',...
          'H-P flow with same u_{av} as BM [HP2]',...
          'H-P flow with same \phi_A as BM [HP3]',...
          'H-P slip flow with same b and u_{av} as BM [HP4]',...
          'H-P slip flow with same b and \phi_A as BM [HP5]'};
    title_HP = titles{option};
    display(['The data is normalised using option ' num2str(option) ': ' title_HP])
    
    %% data analysis -- flow velocity
    
    % compute average x-directional velocity in stream tube
    ux_A_str = zeros(n_str-1,1); % A_str is 2D area of stream tube
    UX_hold = zeros(n_str-1,nop); % preallocate matrix
    UX_interp = UX;
    UX_interp(isnan(UX_interp)) = 0 ; % interpolation does not work with NaN in matrix
    tic
    for j=2:n_str
        for k=1:nop
            x_interp = ones(1,noip).*Xstr(j,k);
            y_interp = linspace(Ystr(j-1,k),Ystr(j,k),noip);
            ux_interp = interp2(X,Y,UX_interp,x_interp,y_interp,'cubic',0);
            ux_hold(j,k) = simps(y_interp,ux_interp);
        end
        ux_A_str(j-1) = simps(Xstr(j,:),ux_hold(j,:)); % x-directional velocity integrated over A
    end
    %ux_av_str = ux_A_str./area_str; % average liquid velocity in stream tube
    ux_av_str = ux_A_str./area_str_HP; % you need to divide by same area as HP flow
    % plot(y0_str,ux_av_str,'ok')
    
    %% normalisation of data -- flow velocity
    
    % compute parameters for HP (slip) flow for all five options
    ux_av_str_HP1 = zeros(n_str-1,1);
    ux_av_str_HP2 = zeros(n_str-1,1);
    ux_av_str_HP3 = zeros(n_str-1,1);
    ux_av_str_HP4 = zeros(n_str-1,1);
    ux_av_str_HP5 = zeros(n_str-1,1);
    for j=2:n_str
        % option 1 [HP1]
        ux_av_str_HP1(j-1) = ef1/(Ystr(j,1) - Ystr(j-1,1))*...
            (-2*(Ystr(j,1)^3-Ystr(j-1,1)^3) + 3*(Ystr(j,1)^2-Ystr(j-1,1)^2));
        % option 2 [HP2]
        ux_av_str_HP2(j-1) = ef2/(Ystr(j,1) - Ystr(j-1,1))*...
            (-2*(Ystr(j,1)^3-Ystr(j-1,1)^3) + 3*(Ystr(j,1)^2-Ystr(j-1,1)^2));
        % option 3 [HP3]
        ux_av_str_HP3(j-1) = ef3/(Ystr(j,1) - Ystr(j-1,1))*...
            (-2*(Ystr(j,1)^3-Ystr(j-1,1)^3) + 3*(Ystr(j,1)^2-Ystr(j-1,1)^2));
        % option 4 [HP4]
        ux_av_str_HP4(j-1) = ef4/(Ystr(j,1) - Ystr(j-1,1))*...
            (-2*(Ystr(j,1)^3-Ystr(j-1,1)^3) + 3*(Ystr(j,1)^2-Ystr(j-1,1)^2) + ...
            6*b/(1+b)*(Ystr(j,1) - Ystr(j-1,1)) - ...
            3*b/(1+b)*(Ystr(j,1)^2 - Ystr(j-1,1)^2));
        % option 5 [HP5]
        ux_av_str_HP5(j-1) = ef5/(Ystr(j,1) - Ystr(j-1,1))*...
            (-2*(Ystr(j,1)^3-Ystr(j-1,1)^3) + 3*(Ystr(j,1)^2-Ystr(j-1,1)^2) + ...
            6*b/(1+b)*(Ystr(j,1) - Ystr(j-1,1)) - ...
            3*b/(1+b)*(Ystr(j,1)^2 - Ystr(j-1,1)^2));
    end   
    ux_av_str_HPall = cat(2,ux_av_str_HP1,ux_av_str_HP2,ux_av_str_HP3,...
        ux_av_str_HP4,ux_av_str_HP5);
    
    ux_av_HP1 = simps(y0_str,ux_av_str_HP1);
    ux_av_HP2 = simps(y0_str,ux_av_str_HP2);
    ux_av_HP3 = simps(y0_str,ux_av_str_HP3);
    ux_av_HP4 = simps(y0_str,ux_av_str_HP4);
    ux_av_HP5 = simps(y0_str,ux_av_str_HP5);
    ux_av_HPall = cat(2,ux_av_HP1,ux_av_HP2,ux_av_HP3,ux_av_HP4,ux_av_HP5);
    
    ux_av_str_HP = ux_av_str_HPall(:,option);
    ux_av_HP = ux_av_HPall(:,option);
    
    %% save data to matfile
    tElapsed = toc(tStart);
    display(['Total analysis/processing time is ' num2str(tElapsed) ' s.'])
    % save all variables, except fig_on and option
    save(matfile, '-regexp', '^(?!(fig_on|option)$).')
    % save(matfile);
        
else
    % display calculated results in case matfile is loaded
    load([matfile '.mat'])
    
    % normalisation curve to output corresponds to option
    % in case data in saved matfile is computed with different option, the
    % loaded data will be overwritten with the data for the new option
    phi_A_str_HP = phi_A_str_HPall(:,option);
    phi_av_str_HP = phi_av_str_HPall(:,option);
    cum_phi_A_str_HP = cum_phi_A_str_HPall(:,option);
    phi_A_HP = phi_A_HPall(:,option);
    ux_av_str_HP = ux_av_str_HPall(:,option);
    ux_av_HP = ux_av_HPall(:,option);
    title_HP = titles{option};
    
    display('Loaded .mat file')
    display(['The bubble protrusion angle theta = ' num2str(theta/pi*180) ' deg'])
    display(['The area of the domain is A = ' num2str(area)])
    display(['The area of the bubble is A_b = ' num2str(area_b)])
    display(['The number of interpolation points is ' num2str(noip)])
    display(['The average dissipation rate in the domain is phi_av = ' num2str(phi_av)])
    display(['The total dissipation in the domain is phi_A = int_A (phi) dA = ' num2str(phi_A)])
    display(['The data is normalised using option ' num2str(option) ': ' title_HP])
end

%% figures
% plot imported figures

if fig_on == 0
else

mm = 0;

%% unnormalised data

% plot velocity fields
mm = mm + 1;
figure(mm)
subplot(1,3,1)
pcolor(X,Y,sqrt(UX.^2+UY.^2))
shading interp;
box on
xlabel('x');
ylabel('y');
title('(u_x.^2+u_y.^2)^{1/2}')

subplot(1,3,2)
pcolor(X,Y,UX)
shading interp;
box on
xlabel('x');
ylabel('y');
title('u_x')

subplot(1,3,3)
pcolor(X,Y,UY)
shading interp;
box on
xlabel('x');
ylabel('y');
title('u_y')

% plot average x-directional velocity in stream-tube
mm = mm + 1;
figure(mm)
hold on
plot(y0_str,ux_av_str,'ok')
plot(y0_str,ux_av_str_HP,'sb')
hold off
box on
ylabel('u_{x,av},u_{x,av,HP}')
xlabel('y_0')
legend('u_{x,av}','u_{x,av,HP}')
legend boxoff
title('Average x-directional velocity in stream tube')

% plot pressure and viscous dissipation rate field
mm = mm + 1;
figure(mm)
subplot(1,2,1)
pcolor(X,Y,P)
shading interp;
box on
xlabel('x');
ylabel('y');
title('p')

subplot(1,2,2)
pcolor(X,Y,PHI)
shading interp;
box on
xlabel('x');
ylabel('y');
title('2({du/dx}^2+{dv/dy}^2)+({dv/dx}+{du/dy})^2')

% plot streamlines on top of velocity magnitude field
mm = mm + 1;
figure(mm)
hold on
pcolor(X,Y,sqrt(UX.^2+UY.^2))
% colormap(paruly)
shading interp;
%quiver(X,Y,UX,UY)
for j = 1:n_str
    plot(Xstr(j,:),Ystr(j,:),'-w')
end
hold off
xlabel('x');
ylabel('y');

% plot dissipation per streamtube versus starting point of stream tube
mm = mm + 1;
figure(mm)
plot(y0_str,phi_A_str,'ok')
box on
ylabel('\phi_{A,str}')
xlabel('y_0')
title('Dissipation per 2D stream tube (i.e. Pa*m2/s)')

% plot av. dissipation per streamtube versus starting point of stream tube
mm = mm + 1;
figure(mm)
plot(y0_str,phi_av_str,'ok')
box on
ylabel('\phi_{av,str}')
xlabel('y_0')
title('Average dissipation per 2D stream tube (i.e. Pa/s)')

% plot cum. dissipation per streamtube versus starting point of stream tube
mm = mm + 1;
figure(mm)
plot(y0_str,cum_phi_A_str,'ok')
box on
ylabel('\Sigma \phi_{A,str}')
xlabel('y_0')
title(['Cumulative dissipation per 2D stream tube (i.e. Pa*m2/s), total is ' num2str(phi_A)])

% plot dissipation by shear and deformation per streamtube versus starting point of stream tube
mm = mm + 1;
figure(mm)
hold on
plot(y0_str,phi_A_str,'ok')
plot(y0_str,phi_shear_A_str,'sb')
plot(y0_str,phi_deform_A_str,'dr')
hold off
box on
ylabel('\phi_{A,str}, \phi_{A,str}^{shear}, \phi_{A,str}^{deformation}')
xlabel('y_0')
legend('\phi_{A,str}','\phi_{A,str}^{shear}','\phi_{A,str}^{deformation}')
legend boxoff
title('Dissipation per 2D stream tube (i.e. Pa*m2/s): total, by shear, by deformation')

%% normalised data
% normalisation options
% 1. [HP1] H-P (Hagen-Poiseuille) flow with u_av = 1
% 2. [HP2] H-P flow with same u_av as bubble mattress
% 3. [HP3] H-P flow with same phi_A as bubble mattress
% 4. [HP4] One-sided H-P slip flow with same slip length and u_av as bubble mattress
% 5. [HP5] One-sided H-P slip flow with same slip length and phi_A as bubble mattress

% plot rel. dissipation per streamtube versus starting point of stream tube
mm = mm + 1;
figure(mm)
plot(y0_str,phi_A_str./phi_A_str_HP,'ok')
box on
ylabel('\phi_{A,str}/\phi_{A,str,HP}')
xlabel('y_0')
title(['Dissipation per 2D stream tube (i.e. Pa*m2/s) relative to ' title_HP])

% plot av. dissipation per streamtube versus starting point of stream tube
mm = mm + 1;
figure(mm)
plot(y0_str,phi_av_str./phi_av_str_HP,'ok')
box on
ylabel('\phi_{av,str}/\phi_{av,str,HP}')
xlabel('y_0')
title(['Average dissipation per 2D stream tube (i.e. Pa/s) relative to ' title_HP])

% plot cum. dissipation per streamtube versus starting point of stream tube
mm = mm + 1;
figure(mm)
plot(y0_str,cum_phi_A_str./cum_phi_A_str_HP,'ok')
box on
ylabel('\Sigma \phi_{A,str}/\Sigma \phi_{A,str,HP}')
xlabel('y_0')
title(['Cumulative dissipation per 2D stream tube (i.e. Pa*m2/s) relative to ' title_HP])

% plot average x-directional velocity in stream-tube
mm = mm + 1;
figure(mm)
hold on
plot(y0_str,ux_av_str./ux_av_str_HP,'ok')
hold off
box on
ylabel('u_{x,av}/u_{x,av,HP}')
xlabel('y_0')
title(['Average x-directional velocity in stream tube relative to ' title_HP])

% OLD --- coming from another file --- may be removed without harm
% [X2,Y2] = meshgrid(x,y);

% mm = mm + 1;
% figure(mm)
% subplot(1,2,1)
% surf(X,Y,UX);
% title('(a)')
% xlabel('$x^*$ [-]','Interpreter','LaTex');
% ylabel('$y^*$ [-]','Interpreter','LaTex');
% zlabel('$u_x^*$ [-]','Interpreter','LaTex');
% axis([0 max(X(:)) 0 max(Y(:)) 0 max(UX(:))]);
% view(50, 25);
% 
% subplot(1,2,2)
% surf(X,Y,UY);
% title('(b)')
% xlabel('$x^*$ [-]','Interpreter','LaTex');
% ylabel('$y^*$ [-]','Interpreter','LaTex');
% zlabel('$u_y^*$ [-]','Interpreter','LaTex');
% axis([0 max(X(:)) 0 max(Y(:)) -max(abs(UY(:))) max(abs(UY(:)))]);
% view(50, 25);        

% % calculate gradients in velocity for UR
% [DURDR,DURDX] = gradient(UX,x,y);
% 
% mm = mm + 1;
% figure(mm)
% subplot(1,2,1)
% surf(X,Y,DURDR);
% title('(a)')
% xlabel('$r^*$ [-]','Interpreter','LaTex');
% ylabel('$x^*$ [-]','Interpreter','LaTex');
% zlabel('$\partial u_r^* / \partial r^*$ [-]','Interpreter','LaTex');
% view(50, 25);
% 
% subplot(1,2,2)
% surf(X,Y,DURDX);
% title('(b)')
% xlabel('$r^*$ [-]','Interpreter','LaTex');
% ylabel('$x^*$ [-]','Interpreter','LaTex');
% zlabel('$\partial u_r^* / \partial x^*$ [-]','Interpreter','LaTex');
% view(50, 25);

% % calculate gradients in velocity for UX
% [DUXDR,DUXDX] = gradient(UY,x,y);
% 
% mm = mm + 1;
% figure(mm)
% subplot(1,2,1)
% surf(X,Y,DUXDR);
% title('(a)')
% xlabel('$r^*$ [-]','Interpreter','LaTex');
% ylabel('$x^*$ [-]','Interpreter','LaTex');
% zlabel('$\partial u_x^* / \partial r^*$ [-]','Interpreter','LaTex');
% view(50, 25);
% 
% subplot(1,2,2)
% surf(X,Y,DUXDX);
% title('(b)')
% xlabel('$r^*$ [-]','Interpreter','LaTex');
% ylabel('$x^*$ [-]','Interpreter','LaTex');
% zlabel('$\partial u_x^* / \partial x^*$ [-]','Interpreter','LaTex');
% view(50, 25);

% --- plot velocity fiels with reduced mesh size for figures

% % maximum mesh size manageable in LuaTeX is approximately 41  41
% [Xfig,Yfig] = meshgrid(linspace(0,max(x),41),linspace(0,max(y),41));
% UXfig = interp2(X,Y,UX,Xfig,Yfig,'spline');
% UYfig = interp2(X,Y,UY,Xfig,Yfig,'spline');
% 
% mm = mm + 1;
% figure(mm)
% subplot(1,2,1)
% surf(Xfig,Yfig,UXfig);
% title('(a)')
% xlabel('$x^*$ [-]','Interpreter','LaTex');
% ylabel('$y^*$ [-]','Interpreter','LaTex');
% zlabel('$u_x^*$ [-]','Interpreter','LaTex');
% axis([0 max(x) 0 max(y)]);
% % set(gca,'ZTick',-0.2:0.1:0.2);
% % view(135, 25);
% set(gcf,'Color','w');
% set(gca,'LineWidth',0.75,'GridLineStyle','--');
% alpha 0.75;
% box off;
% grid on;
% %cleanfigure;
% %matlab2tikz('velocityfield_fig1.tikz', 'height', '\figureheight', 'width', '\figurewidth');
% %figure(3)
% subplot(1,2,2)
% surf(Xfig,Yfig,UYfig);
% title('(b)')
% xlabel('$x^*$ [-]','Interpreter','LaTex');
% ylabel('$y^*$ [-]','Interpreter','LaTex');
% zlabel('$u_y^*$ [-]','Interpreter','LaTex');
% axis([0 max(x) 0 max(y)]);
% % set(gca,'ZTick',0:0.5:2.0);
% % view(135, 25);
% set(gcf,'Color','w');
% set(gca,'LineWidth',0.75,'GridLineStyle','--');
% alpha 0.75;
% box off;
% grid on;
% cleanfigure;
% matlab2tikz(tikzfile, 'height', '\figureheight', 'width', '\figurewidth');

end
end