#Section 1: Create clean R workspace ----
rm(list=ls())
graphics.off()
gc(FALSE)
cat("\014")
Sys.setenv(LANG = "en")
options(max.print = 20000)

#Section 2: Open libraries and datasets ----
#Open packages:
Pkgs2Load <- c("readxl","tidyr", "ggplot2", "ggrepel", "ggh4x", "plyr", "labdsv", "glmmTMB", "DHARMa", "vegan", "pairwiseAdonis")

invisible(lapply(Pkgs2Load, library, character.only = TRUE))

#Set the working directory.
setwd("C:/Users/croij001/OneDrive - Wageningen University & Research/General/Projects/Collab Luuk Fogelina Carabid beetles/Data analyses/Luuk")

#Import data files
Lel <- read.csv("GB_4loc_Data_Lelystad_2019-2021.csv", row.names = 1)
Wag <- read.csv("GB_4loc_Data_Wageningen_2019-2022.csv", row.names = 1)
Alm21 <- read.csv("GB_4loc_Data_Almere_2021-2022.csv", row.names = 1)

#Section 3: Prepare the data ----
cols <- c("Year","Crop","Treatment","Location")
#Subsection 3.1: Lelystad ----
#Subsection 3.1.1: Change treatment names
Lel$Treatment <- factor(Lel$Treatment,
                           levels = c("REF_SPACE", "STRIP"),
                           labels = c("Monoculture", "Strip"))
Lel$Location <- "Lelystad"

#Subsection 3.1.2: Change data class
Lel[cols] <- lapply(Lel[cols],factor)


#Subsection 3.2: Wageningen ----
#Subsection 3.2.1: Change treatment names
Wag$Treatment <- factor(Wag$Treatment,
                           levels = c("REF_SPACE", "STRIP"),
                           labels = c("Monoculture", "Strip"))

Wag$Location <- "Wageningen"

#Subsection 3.2.2: Change data class
Wag[cols] <- lapply(Wag[cols],factor)


#Subsection 3.3: Almere ----
#Subsection 3.3.1: Change column names
colnames(Alm21)[4] <- "Treatment"
colnames(Alm21)[1] <- "ID"

#Subsection 3.3.2: Change treatment names
Alm21$Treatment <- factor(Alm21$Treatment,
                           levels = c("mono", "strip"),
                           labels = c("Monoculture", "Strip"))

Alm21$Location <- "Almere"

#Subsection 3.3.3: Change data class
Alm21[cols] <- lapply(Alm21[cols],factor)


#Subsection 3.4: Merge datasets ----
#Subsection 3.4.1: bind datasets
Total <- rbind.fill(Lel, Wag, Alm21)

#Subsection 3.4.2: Change NA's to 0
Total[is.na(Total)] <- 0

#Subsection 3.4.3: Remove unidentified genera
Total$AmarUI <- NULL
Total$BembUI <- NULL
Total$TrecUI <- NULL
Total$Unknown <- NULL

Alm21$AmarUI <- NULL
Alm21$BembUI <- NULL
Alm21$TrecUI <- NULL

#Subsection 3.4.4: Remove rare species
Total.drop <- dropspc(Total[,c(6:76)],minocc = 0.03*nrow(Total))
All <- cbind(Total[,c(1:5)], Total.drop)

Lel.drop <- dropspc(Lel[,c(6:50)],minocc = 2)
Lel <- cbind(Lel[,c(1:5)], Lel.drop)

Wag.drop <- dropspc(Wag[,c(6:66)], minocc = 0.03*nrow(Wag))
Wag <- cbind(Wag[,c(1:5)], Wag.drop)

Alm21.drop <- dropspc(Alm21[,c(6:45)], minocc = 0.03*nrow(Alm21))
Alm21 <- cbind(Alm21[,c(1:5)], Alm21.drop)

#Subsection 3.5: Make general ggplot theme
CustomPlot = list(
  theme(plot.title = element_text(face = "italic", hjust = 0.5),
        axis.text= element_text(size = 30, colour="black"),
        axis.title = element_text(size = 35, colour = "black"),
        axis.line = element_line(colour = "black"),
        panel.background = element_rect(fill = "white", colour = "black"),
        panel.grid.major = element_blank(),
        panel.grid.minor = element_blank(), 
        strip.background = element_rect(colour = "black", fill = NA),
        strip.text = element_text(colour = "black"),
        legend.text = element_text(size = 25),
        legend.title = element_text(size = 30),
        legend.key = element_rect(fill = NA, colour = NA)) 
)


Treatment.colors <- c("#895F39", "#7FA24D")


#Subsection 3.6: Set working directory for figures
setwd("C:/Users/croij001/OneDrive - Wageningen University & Research/General/Projects/Collab Luuk Fogelina Carabid beetles/Data analyses/Luuk/Raw figures")


#Section 4: RDA on full dataset ----
#Subsection 4.1: Transform data
hellspe <- decostand(All[,c(6:41)] + 1, method = "hellinger")


#Subsection 4.2: Run RDA analyses
ordistep(rda(hellspe ~ 1, data = All, scale = FALSE), 
         scope = formula(rda(hellspe ~ Treatment + Location/Year/Crop, data = All, scale = FALSE)), 
         direction = "forward", pstep = 1000)

all.rda <- rda(hellspe ~ Treatment, data = All) #on transformed data


#Subsection 4.3: Gather information from RDA
all.Sitescores <- data.frame(scores(all.rda,choices=1:5, display="sites", scaling = 1), "Treatment" = All$Treatment, "Year" = All$Year, "Crop" = All$Crop, "Location" = All$Location)
all.Specscores <- data.frame(scores(all.rda,choices=1:5, display="species", scaling = 2), "Species" = colnames(All[,c(6:41)]))
all.TRTscores <- data.frame(scores(all.rda, choices=1:5, display= "cn", scaling = 1)[1:2,], "Treatment" = levels(All$Treatment))
#all.Locscores <- data.frame(scores(all.rda, choices=1:5, display= "cn", scaling = 1)[3:5,], "Location" = levels(All$Location))
#all.Yearscores <- data.frame(scores(all.rda, choices=1:5, display= "cn", scaling = 1)[6:9,], "Year" = levels(All$Year))
#all.Cropscores <- data.frame(scores(all.rda, choices=1:5, display= "cn", scaling = 1)[10:21,], "Crop" = levels(All$Crop))

RDA.percentages <- round(as.vector(eigenvals(all.rda)) / sum(eigenvals(all.rda))*100,2)


#Subsection 4.4: Make figure
png(filename = "RDA - All data.png", width = 9000 , height = 10500, res = 500)
ggplot() +
  geom_point(data = all.Sitescores, aes(x = RDA1, y =  PC1, colour = Treatment, shape = Location), size = 8, stroke = 2, alpha = 0.75) +
    scale_color_manual(values = Treatment.colors) +
    scale_shape_manual(values = c(6,17,1)) +
    labs(shape = "Location", colour = "Crop configuration") +
  geom_point(data = all.TRTscores, 
            aes(x = RDA1, y =  PC1, colour = Treatment), size = 15, shape = 18) +
    geom_text(data = all.TRTscores, 
              aes(x = RDA1, y =  PC1, label = Treatment),nudge_x =c(0.05,-0.025), nudge_y = 0, cex = 12) +
  geom_segment(data = all.Specscores, 
            aes(x = 0, y = 0, xend = RDA1, yend = PC1), 
            arrow = arrow(length = unit(0.03, "npc")),
            colour = "red") +
    geom_text_repel(data = all.Specscores, max.overlaps = 18,
              aes(x = RDA1, y =  PC1, label = Species),nudge_x = 0, nudge_y = 0, cex = 8) +
  geom_hline(yintercept = 0, color = "black", linewidth = 0.3) +
  geom_vline(xintercept = 0, color = "black", linewidth = 0.3) +
  labs(x = paste("RDA1 ",RDA.percentages[1], "%"), y = paste("PC1 ",RDA.percentages[2], "%")) + 
  CustomPlot +
  coord_cartesian(xlim = c(-0.2,0.15), ylim = c(-0.25, 0.25)) 
dev.off()


#Section 5: RDA on Lelystad ----
#Subsection 5.1: Transform data
broek.hellspe <- decostand(Lel[,c(6:16)] + 1, method = "hellinger")


#Subsection 5.2: Run RDA analyses
ordistep(rda(broek.hellspe ~ 1, data = Lel, scale = FALSE), 
         scope = formula(rda(broek.hellspe ~ Treatment * (Year/Crop), data = Lel, scale = FALSE)), 
         direction = "forward", pstep = 1000)

broek.rda <- rda(broek.hellspe ~ Treatment, data = Lel) #on transformed data


#Subsection 5.3: Gather information from RDA
broek.Sitescores <- data.frame(scores(broek.rda,choices=1:3, display="sites", scaling = 1), "Treatment" = Lel$Treatment, "Year" = Lel$Year, "Crop" = Lel$Crop)
broek.Specscores <- data.frame(scores(broek.rda,choices=1:3, display="species", scaling = 2), "Species" = colnames(Lel[,c(6:16)]))
broek.TRTscores <- data.frame(scores(broek.rda, choices=1:3, display= "cn", scaling = 1), "Treatment" = levels(Lel$Treatment))

RDA.percentages.broek <- round(as.vector(eigenvals(broek.rda)) / sum(eigenvals(broek.rda))*100,2)


#Subsection 5.4: Make figure
png(filename = "RDA - Lelystad.png", width = 4800, height = 10500, res = 500)
ggplot() +
  geom_point(data = broek.Sitescores, aes(x = RDA1, y =  PC1, colour = Treatment, shape = Year), size = 10, stroke = 3, alpha = 0.75) +
  scale_color_manual(values = Treatment.colors) +
  scale_shape_manual(values = c(1,19,6)) +
  labs(shape = "Year", colour = "Crop configuration") +
  geom_point(data = broek.TRTscores, 
            aes(x = RDA1, y =  PC1, colour = Treatment), size = 15, shape = 18) +
    geom_text(data = broek.TRTscores, 
            aes(x = RDA1, y =  PC1, label = Treatment),nudge_x =c(0.075,-0.025), nudge_y = 0, cex = 10) +
  geom_segment(data = broek.Specscores, 
            aes(x = 0, y = 0, xend = RDA1, yend = PC1), 
            arrow = arrow(length = unit(0.03, "npc")),
            colour = "red") +
    geom_text_repel(data = broek.Specscores, max.overlaps = 18,
            aes(x = RDA1, y =  PC1, label = Species),nudge_x = 0, nudge_y = 0, cex = 8) +
  geom_hline(yintercept = 0, color = "black", linewidth = 0.3) +
  geom_vline(xintercept = 0, color = "black", linewidth = 0.3) +
  labs(x = paste("RDA1 ",RDA.percentages.broek[1], "%"), y = paste("PC1 ",RDA.percentages.broek[2], "%")) + 
  CustomPlot +
  coord_cartesian(xlim = c(-0.09,0.13), ylim = c(-0.25, 0.32))
dev.off()

#Section 6: RDA on Wageningen ----
#Subsection 6.1: Transform data
droef.hellspe <- decostand(Wag[,c(6:34)] + 1, method = "hellinger")


#Subsection 6.2: Run RDA analyses
ordistep(rda(droef.hellspe ~ 1, data = Wag, scale = FALSE), 
         scope = formula(rda(droef.hellspe ~ Treatment + (Year/Crop), data = Wag, scale = FALSE)), 
         direction = "forward", pstep = 1000)

droef.rda <- rda(droef.hellspe ~ Treatment, data = Wag) #on transformed data


#Subsection 6.3: Gather information from RDA
droef.Sitescores <- data.frame(scores(droef.rda,choices=1:3, display="sites", scaling = 1), "Treatment" = Wag$Treatment, "Year" = Wag$Year, "Crop" = Wag$Crop)
droef.Specscores <- data.frame(scores(droef.rda,choices=1:3, display="species", scaling = 2), "Species" = colnames(Wag[,c(6:34)]))
droef.TRTscores <- data.frame(scores(droef.rda, choices=1:3, display= "cn", scaling = 1), "Treatment" = levels(Wag$Treatment))

RDA.percentages.droef <- round(as.vector(eigenvals(droef.rda)) / sum(eigenvals(droef.rda))*100,2)


#Subsection 6.4: Make figure
png(filename = "RDA - Wageningen.png", width = 6550, height = 10500, res = 500)
ggplot() +
  geom_point(data = droef.Sitescores, 
             aes(x = RDA1, y =  PC1, colour = Treatment, shape = Year), size = 10, stroke = 3, alpha = 0.75) +
  scale_color_manual(values = Treatment.colors) +
  scale_shape_manual(values = c(1,19,6,17)) +
  labs(shape = "Year", colour = "Crop configuration") +
  geom_point(data = droef.TRTscores, 
            aes(x = RDA1, y =  PC1, colour = Treatment), size = 15, shape = 18) +
    geom_text(data = droef.TRTscores, 
            aes(x = RDA1, y =  PC1, label = Treatment),nudge_x =c(0.035,-0.02), nudge_y = 0, cex = 10) +
  geom_segment(data = droef.Specscores, 
            aes(x = 0, y = 0, xend = RDA1, yend = PC1), 
            arrow = arrow(length = unit(0.03, "npc")),
            colour = "red") +
    geom_text_repel(data = droef.Specscores, max.overlaps = 18,
            aes(x = RDA1, y =  PC1, label = Species),nudge_x = 0, nudge_y = 0, cex = 8) +
  geom_hline(yintercept = 0, color = "black", linewidth = 0.3) +
  geom_vline(xintercept = 0, color = "black", linewidth = 0.3) +
  labs(x = paste("RDA1 ",RDA.percentages.droef[1], "%"), y = paste("PC1 ",RDA.percentages.droef[2], "%")) + 
  CustomPlot  +
  coord_cartesian(xlim = c(-0.17,0.12), ylim = c(-0.25, 0.18))
dev.off()


#Section 7: RDA on Almere ----
#Subsection 7.1: Transform data
erf.hellspe <- decostand(Alm21[,c(6:29)] + 1, method = "hellinger")


#Subsection 7.2: Run RDA analyses
erf.rda <- rda(erf.hellspe ~ Treatment, data = Alm21) #on transformed data


#Subsection 7.3: Gather information from RDA
erf.Sitescores <- data.frame(scores(erf.rda,choices=1:3, display="sites", scaling = 1), "Treatment" = Alm21$Treatment, "Year" = Alm21$Year, "Crop" = Alm21$Crop)
erf.Specscores <- data.frame(scores(erf.rda,choices=1:3, display="species", scaling = 2), "Species" = colnames(Alm21[,c(6:29)]))
erf.TRTscores <- data.frame(scores(erf.rda, choices=1:3, display= "cn", scaling = 1), "Treatment" = levels(Alm21$Treatment))

RDA.percentages.erf <- round(as.vector(eigenvals(erf.rda)) / sum(eigenvals(erf.rda))*100,2)


#Subsection 7.4: Make figure
png(filename = "RDA - Almere.png", width = 7450, height = 10500, res = 500)
ggplot() +
  geom_point(data = erf.Sitescores, 
             aes(x = RDA1, y =  PC1, colour = Treatment, shape = Year), size = 10, stroke = 3, alpha = 0.75) +
  scale_color_manual(values = Treatment.colors) +
  scale_shape_manual(values = c(6,17)) +
  labs(shape = "Year", colour = "Crop configuration") +
  geom_point(data = erf.TRTscores, 
            aes(x = RDA1, y =  PC1, colour = Treatment), size = 15, shape = 18) +
    geom_text(data = erf.TRTscores, 
            aes(x = RDA1, y =  PC1, label = Treatment),nudge_x =c(-0.04,0.02), nudge_y = 0, cex = 10) +
  geom_segment(data = erf.Specscores, 
            aes(x = 0, y = 0, xend = RDA1, yend = PC1), 
            arrow = arrow(length = unit(0.03, "npc")),
            colour = "red") +
    geom_text_repel(data = erf.Specscores, max.overlaps = 18,
            aes(x = RDA1, y =  PC1, label = Species),nudge_x = 0, nudge_y = 0, cex = 8) +
  geom_hline(yintercept = 0, color = "black", linewidth = 0.3) +
  geom_vline(xintercept = 0, color = "black", linewidth = 0.3) +
  labs(x = paste("RDA1 ",RDA.percentages.erf[1], "%"), y = paste("PC1 ",RDA.percentages.erf[2], "%")) + 
  CustomPlot  +
  coord_cartesian(xlim = c(-0.17,0.12), ylim = c(-0.16, 0.21))
dev.off()
