# Import necessary libraries
import numpy as np  # For numerical computations
from scipy.optimize import curve_fit  # For non-linear curve fitting

# Define a function to fit data
def createFit2(X, Y):
    """
    CREATEFIT2(X, Y)
    Create a fit.

    Data for 'untitled fit 1' fit:
        X Input : X
        Y Output: Y
    Output:
        fitresult : a fit object representing the fit.
        gof : structure with goodness-of-fit info.

    See also curve_fit.
    """

    # Define the fitting function, where 'a' and 'b' are the parameters to be fitted
    def fit_function(x, a, b):
        return 1 / (1 + a * x ** b)
    
    # Set up fittype and options.
    # p0: Initial guess values, here set to [0.02, 0.7]
    popt, _ = curve_fit(fit_function, X, Y, p0=[0.02, 0.7])
    
    # Return the optimal parameter values (a and b)
    return popt
