# Import necessary libraries
import numpy as np  # For numerical computations
from scipy.optimize import curve_fit  # For non-linear curve fitting

# Define a function to fit data
def createFit1(X, Y):
    """
    CREATEFIT1(X, Y)
    Create a fit.

    Data for 'untitled fit 1' fit:
        X Input : X
        Y Output: Y
    Output:
        fitresult : a fit object representing the fit.
        gof : structure with goodness-of-fit info.

    See also curve_fit.
    """

    # Define the fitting function, where 'a' is the parameter to be fitted
    def fit_function(x, a):
        return 1 / (1 + a * x)
    
    # Set up fittype and options.
    # p0: Initial guess value, here set to [0.964888535199277]
    popt, pcov = curve_fit(fit_function, X, Y, p0=[0.964888535199277])
    
    # Extract the optimal value of the fitting parameter 'a' and the covariance matrix
    # np.sqrt(np.diag(pcov)) calculates the standard deviation (uncertainty) of the parameters
    gof = np.sqrt(np.diag(pcov))  # Standard deviation of the fitting parameters (goodness of fit)
    
    # Return the optimal parameter value (a) and its corresponding uncertainty
    return popt[0], gof

