clear
% this example is based on the data from paper:Zhou et al., 2022 Marine Geology  (https://doi.org/10.1016/j.margeo.2022.106946) 
load Hs
load WL
Depth=WL
load Tp

OBS_1=0   % need to input the distances between each observation stations 
OBS_2=140
OBS_3=OBS_2+130.1
OBS_4=OBS_3+45.8

X=[OBS_1 OBS_2 OBS_3 OBS_4]  % there are 5 stations in total, but the most seaward one is on bare flat, so only use the rest 4 stations.

%% select incident  0.1<Hs<0.2 to built the predictor
Hs_in=Hs(:,4);

ind=find(Hs_in<0.10 | Hs_in>0.20 ); % remove all the data out of this range [0.1<Hs<0.2]
  Tp(ind,:)=[];
  Depth(ind,:)=[];
  Hs(ind,:)=[];

  Tp= Tp(:,4)        % the Tp at the mangrove seaward edge is used to built the predictor
  Depth=Depth(:,4)   % the water depth at the mangrove seaward edge is used to built the predictor
  Hs=Hs(:,1:4)       % the significant wave height at the mangrove seaward edge is used to built the predictor
  
  L_num=floor(OBS_4/5)   % number of wavelength to be considered, assuming the smallest wavelenght is 5 meter
  
%% obtain the KLn, i.e., the relative wave height of each number of wave lenght based on each time step of measurement

for i=1:length(Tp)    % use each measuring time step to built the predictor
   
   Hs_temp=Hs(i,:)/Hs(i,4)  % obtain relative wave height in the forest
   Hs_temp=fliplr(Hs_temp)   % change the order of relative wave height, so that 'x' and 'Hs_temp' can be in line
   [fitresult, gof(i)] = createFit1(X, Hs_temp)  % obtain the beta value of equation S4 in the SI by data fitting, originally from Dalrymple, 1984
   beta(i)=coeffvalues(fitresult)                % obtain the beta value

   k(i)=disper(2*pi./Tp(i),Depth(i))             % obtain the wave number
   L(i)=2*pi./k(i)                               % obtain the wave length
   Ur(i)=Hs(i,1).*L(i).^2/(Depth(i).^3)          % obtain the Ur number
   
   for j=1:L_num
     KLn(j,i)=1/(1+beta(i)*L(i)*j)              % use beta vaule to obtain the relative wave height along the forest
   end

end

%% To use the obtained KLn in the prediction 

load Hs
load WL
Depth=WL
load Tp

Hs_in=Hs(:,4);
ind=find( Hs_in<=0.20 );  % remove all the data out of this range [Hs<0.2], only predict the high wave cases
  Tp(ind,:)=[];
  Depth(ind,:)=[];
  Hs(ind,:)=[];

  Tp= Tp(:,4) 
  Depth=Depth(:,4)
  Hs=Hs(:,1:4)

  for p=1:length(Tp)
      L=2*pi/disper(2*pi/Tp(p),Depth(p)) % obtain the wave length
      Ur_big(p)=Hs(p,4)*L^2/Depth(p)^3   % obtain the Ur number
      if  Ur_big(p)>max(Ur)
          MM(p,1:3)=NaN
      else
      [KLm]=HU_method_Hs(KLn,Ur,Hs(p,4),OBS_4, Tp(p), Depth(p))  % this function is the main function of calculation, obtain the relative wave height (KLm) at OBS_4
       MM(p,1)=KLm   
      
     [KLm]=HU_method_Hs(KLn,Ur,Hs(p,4),OBS_3, Tp(p), Depth(p))  % obtain the relative wave height (KLm) at OBS_3
       MM(p,2)=KLm 
      
      [KLm]=HU_method_Hs(KLn,Ur,Hs(p,4),OBS_2, Tp(p), Depth(p))  % obtain the relative wave height (KLm) at OBS_2
       MM(p,3)=KLm 
      end
      
      Ob(p,1:3)=Hs(p,1:3)/Hs(p,4)
 
  end
  
  MM_all=reshape(MM,[],1)
  Ob_all=reshape(Ob,[],1)
  
  plot(MM_all,Ob_all,'+');hold on
  plot([0 1],[0 1])

  R2 = 1-nansum((MM_all-Ob_all).^2)/nansum((mean(Ob_all)-Ob_all).^2)

  RMSE = (nanmean((MM_all-Ob_all).^2))^0.5


