function [KLm]=HU_method_Hs(KLn,Urn,Hs,X, T,d)


m=length(KLn(:,1))  % m is the number of wavelength

L=2*pi/disper(2*pi/T,d)  % obtain wavelength
Ur=Hs*L^2/d^3            % obtain Ur number

Range1=min([round(min(Urn)) round(Ur)])   % obtain Ur number range is determined by both small wave cases and also the current large wave cases
Range2=max([round(max(Urn)) round(Ur)])
Ur_range=[Range1:1:Range2]

for i=1:m
    
 [fitresult, gof] = createFit2(Urn, KLn(i,:))   % obtain the equation (1) in the MS, HLn=1/(1+a*Ur^b ) for each number of wave length, i.e., L=1,2..m
 Temp=coeffvalues(fitresult)
 a= Temp(1)
 b= Temp(2)
 KL(i,:)=1./(1+a.*Ur_range.^b) 

end

ind=find(Ur_range-round(Ur)==0)         % find the closest Ur number to the Ur at hand

  if X/L<1
     KLm=NaN
  else 
    KLm = interp1 (1:m,KL(:,ind),X/L)    % by interpolation determining relative wave height at the X in the forest
  end

end


