# Introduction
This repository houses the data files for the paper "Formation and Properties of the Bi 
($\sqrt{3}\times\sqrt{3}$)R30° wetting layer on Ge(111)" found 
[here](https://doi.org/10.1103/3ws2-w84r). The data in the paper is comprised of both experimental
and simulation data. As such, this repository is split into two separate parts for each.

For both the experimental data and the simulation data, the files and folders have been split in
a per-figure fashion. The filenames indicate to which figure in the paper the data belongs to.
Scanning tunneling microscopy topography images are housed in the files with the .gwy extension.
These files can be opened in the open-source [Gwyddion](https://gwyddion.net/) program. I(V) and
dI(V)/dV curves are found in the .csv files and are human-readable. The csv files contain two rows,
with the first row corresponding to the x-axis (i.e. Voltage) and the second row corresponds to the
y-axis (i.e. Current or dI/dV). The voltage and current values are printed in SI-units, dI/dV is
arbitrary units. The filenames of the csv files indicate the spatial location and the type of curve.

The simulation data is stored in a binary format that can be read-in using any open-source density 
functional theory tool, such as [SIESTA](https://siesta-project.org/).

# Methodology
## Experiments
The experiments were performed on an Omicron STM-1 using the MATRIX 3 controller and software. As
the software and data format are proprietary, the data presented in the paper has been converted to
open standards. Topography images were parsed using Gwyddion, where standard SPM processing
techniques have been applied, such as flattening, row alignment and FFT filtering. Spectroscopy
curves were obtained in point, line and grid datasets and parsed using Python. The MATRIX data files
were loaded in using a modified version of the 
[access2theMatrix](https://pypi.org/project/access2theMatrix/) Python library.

## Simulations
Simulations were perfomed using a combination of [Python](https://www.python.org/) and 
[SIESTA](https://siesta-project.org/).