import numpy as np
import plotly.graph_objects as go
import matplotlib.pyplot as plt

from scipy.interpolate import griddata

file = np.loadtxt('./biGe-slb-ml.LDOS.q.CC.STM')

a1 = np.array([ 11.646544623,       6.724134990,       0.00000000])
a2 = np.array([-11.646544623,       6.724134990,       0.000000000])

def plt_STM(file_in,grid_size,name):
    # Original data: [x, y, value]
    data = file_in

    # Extract x, y, and values
    x = data[:, 0]
    y = data[:, 1]
    values = data[:, 2]

    # Define spanning vectors
    v1 = a1  # Translation vector 1
    v2 = a2  # Translation vector 2

    # Define the range of spanning (e.g., -2 to 2 in both directions)
    span_range = np.arange(-15, 15)

    # Span the data
    X, Y, Z = [], [], []
    for n1 in span_range:
        for n2 in span_range:
            for i in range(len(x)):
                new_x = x[i] + n1 * v1[0] + n2 * v2[0]
                new_y = y[i] + n1 * v1[1] + n2 * v2[1]
                X.append(-new_x)
                Y.append(-new_y)
                Z.append(values[i])

    # Create a grid for visualization
    #grid_size = 500
    x_min, x_max = min(X), max(X)
    y_min, y_max = min(Y), max(Y)
    x_edges = np.linspace(x_min, x_max, grid_size)
    y_edges = np.linspace(y_min, y_max, grid_size)
    grid_x, grid_y = np.meshgrid(x_edges, y_edges)

    # Interpolate values onto the grid
    grid_values = griddata((X, Y), Z, (grid_x, grid_y), method='linear')

    # Display with imshow
    plt.imshow(
        grid_values,
        extent=(x_min, x_max, y_min, y_max),
        origin='lower',
        cmap='hot',
        aspect='equal'
    )
    #plt.colorbar(label='Intensity')
    plt.xlabel('X [$\AA$]')
    plt.ylabel('Y [$\AA$]')
    #plt.title('Spanned Data Visualization')
    plt.xlim(0,150)
    plt.ylim(0,100)
    plt.savefig('./' + name + '.pdf')
    
    return  print(name,'done')

plt_STM(file,2000,'stm_image_full')
#plt_STM(file,500,'stm_image')
