# -*- coding: utf-8 -*-
"""
@author: j.h.koo@tudelf.nl
"""

import numpy as np

MT = 264  # the maximun discharge via turbines
MSP = int(11680)  # the maximum discharge via spillway gates
LWL = 60.094
NHWL = 76.5
FWL = 80.0


def eval_ETS(SO_p_k, SP_n_k, ST_n_k, SO_n_k, E_RWL_k, TWL_F, TWL_L, TWL_H, max_INF, EV_weights=[1, 1, 1, 1, 1, 1]):

    F = len(SO_n_k)
    SP_p_k = [max(0, i-MT) for i in SO_p_k]

    def num_C_abs():
        num_C_ls = []
        for j in range(F-1):
            if abs(SP_n_k[j] - SP_p_k[j+1]) > 0.1:
                num_C_ls.append(1)
            else:
                num_C_ls.append(0)
        penalty_2_abs = max([num_C_ls[k] * 75 / (np.e ** (k*2)) for k in range(len(num_C_ls))])
        return penalty_2_abs, num_C_ls

    def num_C_ins():
        num_C_ls = []
        for j in range(F-1):
            if SP_n_k[j+1] - SP_n_k[j] > 0.1:
                num_C_ls.append(SP_n_k[j+1] - SP_n_k[j])
            else:
                num_C_ls.append(0)
        if max(SO_n_k) >= max_INF:
            penalty_2_inc = np.e ** (2.4 * 2 * max(num_C_ls) / MSP) - 1
        else:
            penalty_2_inc = 0
        return penalty_2_inc

    def Max_QTO_():
        penalty_4 = np.e ** (2.4 * max(SP_n_k) / (MSP)) - 1
        return penalty_4

    def Max_RWL_():
        penalty_5 = 5 * (max(max(E_RWL_k) - NHWL, 0)) + 5 * (max(E_RWL_k[-1] - E_RWL_k[0], 0))
        if max(E_RWL_k) >= 78.5:
            penalty_5 += 20 * (max(E_RWL_k) - 78.5)
        if min(E_RWL_k) < TWL_L:
            penalty_5 = 5 * (TWL_L - min(E_RWL_k)) + 5 * max(E_RWL_k[0] - E_RWL_k[-1], 0) + 20 * (TWL_L - min(E_RWL_k))
        return penalty_5

    def Comp_():
        penalty_5 = 0
        for i in range(F):
            if SP_n_k[i] > 0.01 and ST_n_k[i] < MT - 0.01:
                penalty_5 += 5000
            else:
                penalty_5 += 0
        return penalty_5

    def num_C_oc():
        num_C_o = 0
        num_C_c = 0
        C_oc = []
        for i in range(F):
            if SO_n_k[i] - 264 > 0.01:
                Bi = 1
            else:
                Bi = 0
            C_oc.append(Bi)
        for j in range(1, len(C_oc)):
            num_C_c += abs(min(C_oc[j] - C_oc[j - 1], 0))
            num_C_o += abs(max(C_oc[j] - C_oc[j - 1], 0))
        penalty_6 = 10 * num_C_c
        return penalty_6, num_C_c, num_C_o


    penalty_1 = Max_QTO_()
    penalty_2 = Max_RWL_()
    penalty_3, num_C_ls_abs = num_C_abs()
    penalty_4 = num_C_ins()
    penalty_5 = Comp_()
    penalty_6, num_C_c, num_C_o = num_C_oc()
    num_C_total = num_C_ls_abs
    penaltys = penalty_1 * EV_weights[0] + penalty_2 * EV_weights[1] + penalty_3 * EV_weights[2] + penalty_4 * 1 * EV_weights[3] + penalty_5 * EV_weights[4] + penalty_6 * EV_weights[5]
    return penaltys, num_C_total, num_C_c, num_C_o