%Summary results for Geophysics paper Barnhoorn et al., 2018

%citation: Auke Barnhoorn, Jeroen Verheij, Marcel Frehner, Alimzhan
%Zhubayev, Maartje E.  Houben, 2018, Experimental identification of the
%transition from elasticity to inelasticity from ultrasonic attenuation
%analyses: Geophysics

% contact auke.barnhoorn@tudelft.nl for queries. 

clear all
close all
% Explanation of variables (name in variable after _(underscore) denotes
% the sample name

% strain_     axial strain 
% Sigma_      axial stress in MPa
% Vel_        velocity of s- or p-wave in m/s
% dV_         velocity uncertainty in m/s
% Qinv        attenuation of s- or p-wave
% dQinv       attenuation uncertainty
% error_V_    velocity uncertainty in % with respect to measured velocity
% error_Qinv_ attenuation uncertainty in % with respect to measured attenuation


%sandstone samples, corresponds to Fig.6 of manuscript

% Sandstone s-wave
Sigma_005b=[0.300000000000000 0.900000000000000  5.30000000000000 7.40000000000000 10.4000000000000 15 17.9 000000000000 20.9000000000000 24.1000000000000 27.5000000000000 30.1000000000000 34 37.5000000000000 40 42.6000000000000 45 47.1000000000000 49 51 52.9000000000000 55 57 59 60 62 63.7000000000000 65 66.5000000000000 66 65];
strain_005b=[-0.00100112499873438 -0.000540015542830548 0.000201837178739254 0.000255029531055735 0.000435083983518345 0.000514315120482560 0.000747869874838120 0.00101239943061835 0.00112552750343477 0.00139129640698030 0.00143792599738568 0.00145427116874056 0.00170759263696869 0.00198010023478467 0.00200007927302024 0.00216894184481915 0.00234760620261428 0.00238940249316735 0.00259630733051339 0.00264440133943124 0.00285278948430233 0.00289772861535136 0.00310065220748187 0.00314697314494458 0.00324846355331915 0.00329396057597446 0.00351231288017934 0.00359998601314904 0.00367363900939607 0.00465269611820968 0.00504197117566009];
Vel_005b=[2086.39865397121 2112.99038398515 2229.23785926429 2301.35037972900 2351.73943850171 2360.23875210917 2368.43618771156 2376.62141635249 2363.16332659053 2362.53676954792 2362.42687334485 2362.38835361067 2357.42993739877 2356.78942860990 2356.74248306416 2352.00226423312 2351.58344729323 2347.15891582216 2342.36522220498 2342.25297753572 2337.47385620228 2337.36922000184 2332.62071916161 2332.51311620971 2332.27738997532 2332.17173198930 2335.93916252491 2335.73530117944 2335.56406756019 2337.57548356238 2353.96371432580];
dV_005b=[35.1340722849104 35.6273298640370 37.7496844574252 39.0576766746318 39.9789808188350 40.1363622386392 40.2940028898862 40.4526653546398 40.2119892233155 40.2103556298018 40.2100691402715 40.2099687254555 40.1290492797644 40.1273827001257 40.1272605646821 40.0471789406771 40.0460912485256 39.9670946761559 39.8874033258622 39.8871128021215 39.8077222819863 39.8074519244333 39.7284021396884 39.7281246006048 39.7275166325503 39.7272441440379 39.8037579909800 39.8032315597857 39.8027894132989 39.8750165087338 40.1880403632206];
Qinv_005b=[0.111196495333111 0.0894946874204008 0.0447680960616894 0.0997768344832077 0.0886714047687418 0.0817517047820425 0.0749914600647423 0.0718658505997979 0.0700306884293715 0.0683250627142485 0.0669961101567912 0.0655663210455181 0.0641412610808235 0.0624771656615194 0.0610461566748502 0.0604580885285748 0.0594682071115919 0.0587569417114838 0.0576052311845274 0.0570978782633889 0.0562373831133502 0.0562153831355359 0.0563649979244909 0.0569845413847621 0.0571960159527259 0.0578166912199149 0.0582314051230078 0.0584255168150104 0.0591988534495399 0.0649440415445618 0.0652859908145248];
dQinv_005b= [0.00290725438584122 0.00234109702934439 0.00117319480444365 0.00261719099839163 0.00232750441314414 0.00214616094822971 0.00196906393099937 0.00188737455919353 0.00183895580270632 0.00179433649112590 0.00175946496816097 0.00172192555354576 0.00168456145137844 0.00164101551667134 0.00160344022760614 0.00158800447731494 0.00156210312532755 0.00154336047403202 0.00151313950196950 0.00149983827646464 0.00147726603879509 0.00147671170475413 0.00148067044252652 0.00149697006350569 0.00150257962245962 0.00151890974890407 0.00153000419514589 0.00153515220574547 0.00155551261408989 0.00170715750891241 0.00171674870280486];
error_Vel_005b=100*dV_005b./Vel_005b;
error_Qinv_005b=100*dQinv_005b./Qinv_005b;

% Sandstone p-wave
Qinv_006b=[0.103577246386159 0.146943310806453 0.124054179014671 0.115733056460753 0.105347608704789 0.0939085191369571 0.0814717517764168 0.0747343787191930 0.0709718709574205 0.0668854312051574 0.0629302760622955 0.0598422420802671 0.0569074578979660 0.0562014238122880 0.0537967794173691 0.0532727832398657 0.0516356302512251 0.0509283126793260 0.0494190322003931 0.0492426165340179 0.0493038066549879 0.0492285340259744 0.0480317382974379 0.0480744737566480 0.0483138408282433 0.0480411446001953 0.0482929751451133 0.0480354032799153 0.0485685559237920 0.0476098030059560 0.0474942164660118 0.0475567300930436 0.0476077276590239 0.0479682184933321 0.0482071070995104 0.0485436098808856 0.0497149471407115 0.0501699900896624 0.0506182141414765 0.0511165272288463 0.0516030830904221 0.0524275549503706 0.0540719971414472 0.0535522347505732 0.0564180440305719 0.0498755208109679 0.0493710396968300];
dQinv_006b=[0.00288808167874322 0.00411650796136459 0.00348756212659808 0.00325815031880467 0.00297403021055236 0.00265245537992095 0.00230234126452770 0.00211406261770148 0.00200864453629681 0.00189490378207316 0.00178200820799921 0.00169543080629539 0.00161229885478311 0.00159316092153044 0.00152498109663798 0.00151017056979147 0.00146451902846054 0.00144376491438185 0.00140104525867296 0.00139678024314976 0.00139921815896568 0.00139710859606852 0.00136322146236296 0.00136444738145959 0.00137196021447718 0.00136355346959543 0.00137139383779353 0.00136342954635141 0.00137928535828384 0.00135277145939832 0.00134882693630050 0.00135064096545173 0.00135211513055795 0.00136237949376772 0.00136920354453750 0.00137882689398500 0.00141282886562761 0.00142581496470394 0.00143856707702383 0.00145277070943671 0.00146669702976440 0.00149027310019372 0.00153787670706038 0.00152249007851485 0.00160410324827217 0.00141819196464635 0.00140390105086411];
strain_006b=[0 0.000562816584328685 0.000719266973136942 0.000844462515247240 0.000844462515247240 0.000969689386593263 0.00106363010698868 0.00118891183280145 0.00125156445556946 0.00134555809368839 0.00140823032389297 0.00147091039964949 0.00150225338007011 0.00165899771496541 0.00162764492299987 0.00172170918766630 0.00178442851328930 0.00184715569330954 0.00200400801603206 0.00209814298687878 0.00209814298687878 0.00216090946102534 0.00234925606891151 0.00238065405337677 0.00244345592381430 0.00250626566416040 0.00250626566416040 0.00260049503399442 0.00266332445558515 0.00272616175226397 0.00278900692551158 0.00288328945718942 0.00294615432833950 0.00300902708124373 0.00310335099213191 0.00326059694005518 0.00329205204577520 0.00341789219529021 0.00344935716525557 0.00354376391632954 0.00376411543287328 0.00407907122685911 0.00423662325435431 0.00461494992622359 0.00489888204999372 0.00515140092976505 0.00527770796682584];
Vel_006b=[3441.05726677716 3609.92353420030 3744.61290909146 3797.50860023137 3908.93419989488 3927.65254592696 3946.67924157610 3985.55144123140 4005.27983274365 4045.46259052644 4024.82915321740 4044.95622727701 4044.82963646465 4064.77923059716 4064.90646568122 4064.52476042903 4085.06081249631 4064.01582009278 4063.37964467245 4083.78195302397 4104.77969862178 4104.52261161469 4103.75135059344 4103.62280708989 4124.57320369161 4103.10863307572 4124.31478797807 4102.72300256510 4123.66874869424 4144.83212801739 4123.15191726718 4122.76429369688 4122.50587798335 4122.24746226981 4121.85983869951 4121.21379941568 4142.49430398629 4141.97478753494 4141.84490842210 4141.45527108358 4140.54611729371 4139.24732616533 4160.21091069322 4137.03938124707 4135.87046923152 4134.83143632882 4134.31191987746];
dVel_006b=[66.8559243935486 70.8132951203991 73.9836395905369 75.2396873333520 77.8819138624791 78.3353136610384 78.7945993300517 79.7302730686568 80.2058784492188 81.1740365583440 80.6838127954836 81.1700539228252 81.1690583113107 81.6577361027712 81.6587407408363 81.6557268839023 82.1529204731314 81.6517086752293 81.6466863439429 82.1427835351248 82.6475671347795 82.6455212672927 82.6393841298410 82.6383613414203 83.1467611130195 82.6342703815395 83.1446967220566 82.6312023651407 83.1395360863091 83.6536901137246 83.1354079291806 83.1323120163886 83.1302481721831 83.1281844061091 83.1250889035074 83.1199301232443 83.6349438493556 83.6307788787254 83.6297376852806 83.6266142230685 83.6193268337149 83.6089179515412 84.1254206695371 83.5912273736829 83.5818640799238 83.5735424931093 83.5693821731098];
Sigma_006b=[0.140000000000000 2.10000000000000 3.96000000000000 6.30000000000000 8.08000000000000 10.1000000000000 12.1200000000000 14.2200000000000 16.1600000000000 17.7700000000000 19.3900000000000 21 22.6200000000000 24.3200000000000 25.9300000000000 27.5500000000000 29.0800000000000 30.7000000000000 32.3100000000000 33.9300000000000 35.2200000000000 37.0800000000000 38.2900000000000 39.5800000000000 40.5500000000000 41.6800000000000 42.7400000000000 43.6200000000000 44.4300000000000 45.2400000000000 46.1300000000000 46.9400000000000 47.6600000000000 48.4700000000000 49.3600000000000 50.1700000000000 50.5700000000000 51.5400000000000 52.1900000000000 53.3200000000000 54.2100000000000 54.7700000000000 55.5800000000000 56.3100000000000 57.6800000000000 56.0600000000000 56.1500000000000];
error_Vel_006b=100*dVel_006b./Vel_006b;
error_Qinv_006b=100*dQinv_006b./Qinv_006b;

% Sandstone p-wave
Qinv_004b=[0.0747991837075018 0.0771156502818233 0.0846205145832491 0.0707556576542660 0.0663849196817052 0.0611746026570706 0.0557453962485274 0.0550256167310320 0.0530135927695242 0.0504459361222397 0.0511492620285734 0.0490788515002125 0.0493332118361591 0.0487503497897155 0.0492285957071959 0.0496289425273810 0.0481001204692793 0.0484375195584400 0.0483878773471480 0.0490226574322186 0.0492946277501413 0.0495831596050774 0.0499506059872504 0.0506554435966238 0.0496144492883815 0.0532020484768374 0.0545955941361583 0.0554467569434254 0.0571546496480267 0.0574287431390414 0.0581084126331195 0.0584239768795199 0.0559572788236162];
dQinv_004b=[0.00207088033658098 0.00214738212131479 0.00236409757334267 0.00198426438111346 0.00186575375562068 0.00172167645984031 0.00157110982788462 0.00155235019687525 0.00149701163798002 0.00142456166103390 0.00144515161380907 0.00138735856086063 0.00139464261328424 0.00137886987640095 0.00139245960039841 0.00140379443490173 0.00136061193391579 0.00137085936117123 0.00136947677044476 0.00138750634608481 0.00139520536304485 0.00140343789140433 0.00141383836164278 0.00143381892619810 0.00140504196447385 0.00150667901762740 0.00154617980898727 0.00157044225398079 0.00161970316020150 0.00162754735449858 0.00164689491785833 0.00165588317116442 0.00158631591674621];
strain_004b=[-0.000713680000000000 2.74939319433458e-05 0.000375003943788871 0.000506557164043678 0.000506557164043678 0.000603678149315193 0.000779170279948549 0.000967265837233107 0.00101116496742829 0.00113974884336022 0.00124012992936226 0.00134053113282229 0.00156022893088695 0.00166383416641346 0.00181143012111757 0.00183655716579048 0.00198420399412168 0.00208475438094432 0.00213817997680905 0.00228905945123213 0.00229220325638398 0.00244627385464212 0.00244627385464212 0.00251546380662758 0.00253119012681642 0.00261612077632643 0.00269162675981613 0.00301895072049183 0.00321418778269981 0.00336854178293625 0.00353870117654443 0.00362695468050983 0.00433985480468983];
Vel_004b=[3181.08291532931 3380.34886363174 3497.49044149549 3640.42582658520 3725.28950497715 3777.76736412400 3831.45569459555 3867.84017796243 3905.49876840528 3904.99751327690 3923.79479967459 3942.77775049077 3941.91349613642 3961.06817863364 3960.48501355022 3960.38575140836 3959.80258632494 3979.15450771863 3978.94252356713 3978.34398008056 3978.33151042459 3977.72049728204 3977.72049728204 3977.44616485069 3997.32190816983 3996.98353972338 3996.68276777099 3995.37942264394 4014.72772001170 4014.11055015250 4013.43040377706 4013.07773528608 4010.23119675181];
dVel_004b=[60.8998608647782 65.4962948420495 68.2245371466639 71.5656389973686 73.5587402747071 74.8021692602514 76.0830276638631 76.9577363238894 77.8556405171516 77.8518082300957 78.3056956980529 78.7645272074148 78.7578681328621 79.2215657574448 79.2170552157202 79.2162875045020 79.2117774394425 79.6805823869906 79.6789365535714 79.6742897843195 79.6741929811787 79.6694498549025 79.6694498549025 79.6673204331374 80.1438225755550 80.1411856509207 80.1388418324762 80.1286865320923 80.6047438821800 80.5999169183875 80.5945979320387 80.5918401557773 80.5695863805877];
Sigma_004b=[0.397900000000000 2.30770000000000 4.69510000000000 7.16200000000000 9.54930000000000 12.3345000000000 16.2338000000000 18.9394000000000 21.9634000000000 23.8732000000000 26.2606000000000 28.6479000000000 31.1148000000000 33.4225000000000 35.0141000000000 36.6056000000000 38.1972000000000 40.5845000000000 41.6986000000000 43.2106000000000 45.2000000000000 46.7120000000000 47.7465000000000 48.5423000000000 49.3380000000000 49.9747000000000 50.7704000000000 49.7359000000000 52.5211000000000 54.1127000000000 55.3859000000000 55.9430000000000 56.7387000000000];
Sigma_ucs_004b=[0.385950737000000 0.700281750000000 0.895246555000000 1.09021136000000 1.27323954500000 1.57563393700000 1.81834522500000 1.98943678900000 2.20827483500000 2.40323964100000 2.78919037800000 3.22686647100000 3.59292284000000 3.96693695700000 4.52795813100000 4.73485955700000 5.38739482400000 5.90066951500000 6.58105689700000 7.20971892200000 8.01345138500000 8.71771200800000 9.44584587300000 10.3172191900000 11.1448248900000 12.1634165300000 12.9790856100000 13.9976772400000 14.9088392900000 16.0985224900000 16.8744028400000 18.0044029400000 19.0389100700000 19.9341566200000 21.1238398200000 22.1225370900000 23.0575723800000 24.1119738800000 25.4130655400000 26.1770092700000 27.5139107900000 28.6797207500000 29.5152842000000 30.6094744300000 31.3495449200000 32.6625732000000 33.5339465100000 34.6520099800000 35.4517635700000 36.5937002900000 37.6640172800000 38.6109891900000 39.8364822600000 40.6282781000000 41.8895810200000 42.9201092800000 43.9546164100000 45.1920460900000 46.0554616600000 47.0621166700000 48.0448984500000 49.0913422000000 49.9746521300000 50.9614127800000 51.8089128500000 49.8552859200000 50.9733494000000 51.8685959500000 52.7081382800000 53.5954270900000 54.0689130400000 55.1591244000000 55.5251807700000 55.9747934900000 55.1113779200000 54.7612370400000 55.4416244300000 56.0225399700000 56.5437724100000 57.1047935800000 56.4840893000000 57.3236316300000 56.9933851200000 56.2175047700000 55.9747934900000 55.5132441500000 55.2824694800000 55.1869765200000 50.4123282200000 49.3698633500000 48.3472928400000];
strain_ucs_004b=[-0.000713680000000000 2.74939319433458e-05 0.000375003943788871 0.000506557164043678 0.000506557164043678 0.000603678149315193 0.000779170279948549 0.000967265837233107 0.00101116496742829 0.00113974884336022 0.00124012992936226 0.00134053113282229 0.00156022893088695 0.00166383416641346 0.00181143012111757 0.00183655716579048 0.00198420399412168 0.00208475438094432 0.00213817997680905 0.00228905945123213 0.00229220325638398 0.00244627385464212 0.00244627385464212 0.00251546380662758 0.00253119012681642 0.00261612077632643 0.00269162675981613 0.00301895072049183 0.00321418778269981 0.00336854178293625 0.00353870117654443 0.00362695468050983 0.00433985480468983];
error_Vel_004b=100*dVel_004b./Vel_004b;
error_Qinv_004b=100*dQinv_004b./Qinv_004b;

% Sandstone s-wave
strain_007b=[-0.00198561191686299 -0.00142157129653995 -0.00122892939636527 -0.000208616923385679 -1.42524620385651e-05 0.000179716536503419 0.000372033379812532 0.000370777193664510 0.000597412711665116 0.000660725622730079 0.000691520896295061 0.000851812553320993 0.000947068924065890 0.00101058322416669 0.00123420497992391 0.00118343730276196 0.00129084752247868 0.00134966757701382 0.00146104888398588 0.00154852383457915 0.00161319971950979 0.00166811221205759 0.00174271745122367 0.00185843823336218 0.00183495770247088 0.00193006939282915 0.00196282469012984 0.00205056123297051 0.00206850984097867 0.00207117313258011 0.00220241809519050 0.00221942651505768 0.00229932507045846 0.00238002460461766 0.00238615794844035 0.00240238429097154 0.00243422439162148 0.00251952018336770 0.00259031592511913 0.00264692928507966 0.00280719904242649 0.00288277103326868 0.00296356435360475 0.00302810703221207 0.00310750278685126 0.00331467370135176 0.00339964513235667 0.00358515527944233 0.00371175457481979 0.00374982774620059 0.00423473827177901 0.00444348224546204 0.00473073146526877 0.00494887466314249 0.00545191834564897 0.00579686275411641 0.00617779261002374 0.00646142211595163 0.00692674159496898 0.00732283596432804];
Qinv_007b=[0.0844856445524638 0.0974318168491990 0.114206921460356 0.111839687389121 0.110534548949603 0.104913465545719 0.100653850099038 0.0970512186122654 0.0938158020011290 0.0902532249314331 0.0860756927618151 0.0822404468616305 0.0784460502233528 0.0734425238252592 0.0652950327411769 0.0616046282172004 0.0587853331550563 0.0569643864719936 0.0547843657191570 0.0529032186720645 0.0519565079293808 0.0521256885433654 0.0507239652917239 0.0498463075907125 0.0495041616507424 0.0479589965357061 0.0482349545036864 0.0493702817857621 0.0480435712383502 0.0491449732831725 0.0479200178062330 0.0466710577386347 0.0481180391133650 0.0469293599959478 0.0481598153823010 0.0471723165141379 0.0470192567547854 0.0466459926675353 0.0471127566122161 0.0480247344410231 0.0485763322156333 0.0495166802118539 0.0488504409710603 0.0499868959280119 0.0489889523335908 0.0495070200984284 0.0510328357217489 0.0514270431708655 0.0504505227847279 0.0506943911091971 0.0533442263051429 0.0519598983788305 0.0521022980380654 0.0521175242671994 0.0507814863929582 0.0509153113899920 0.0513502958125524 0.0521432311710345 0.0511358083009848 0.0486260094639802];
dQinv_007b=[0.00220552901543577 0.00254584876058314 0.00298542493934740 0.00292820507131205 0.00289560753826607 0.00274880976815977 0.00263764029680586 0.00254347880643522 0.00245912460964310 0.00236602646278452 0.00225675746787450 0.00215643341911247 0.00205711178601158 0.00192613776225619 0.00171276504344165 0.00161609414662307 0.00154227116064586 0.00149460404825670 0.00143753529534355 0.00138828770501869 0.00136347547323471 0.00136808092376255 0.00133132689656561 0.00130841199694515 0.00129948656774160 0.00125896850338374 0.00126622741140618 0.00129613797353040 0.00126131535732944 0.00129029853647702 0.00125819612791652 0.00122541063309830 0.00126350394170102 0.00123232646726499 0.00126470517229955 0.00123878001735645 0.00123483834250374 0.00122507268881270 0.00123736254958055 0.00126140531860917 0.00127603238652594 0.00130076896510814 0.00128330418496347 0.00131318906474442 0.00128707570229046 0.00130085040588857 0.00134105344147653 0.00135157243045113 0.00132603742515018 0.00133260566052616 0.00140265209895937 0.00136635343879925 0.00137031063256403 0.00137081735323881 0.00133591513785918 0.00133959992950198 0.00135115584092953 0.00137194115863163 0.00134488986854662 0.00127841474786223];
Vel_007b=[1970.52733581467 2022.34973485853 2047.86238246835 2138.22232117195 2174.19592882069 2181.20055006295 2188.25695980150 2195.78598617882 2202.86620361083 2210.35563607417 2217.96906154454 2221.47467687603 2225.13689472011 2232.78254465772 2240.12438774327 2248.13288001527 2251.86027317655 2255.71012396644 2259.45528560510 2263.26770406106 2263.12186674256 2271.05863322561 2270.88984894343 2274.67918624501 2278.79805414100 2278.58218377863 2278.50785014629 2282.38811782565 2282.34732219299 2286.43516912086 2286.13637157455 2286.09765523963 2290.02347941624 2289.83949982135 2293.94763101866 2293.91057547694 2297.97464961304 2297.77954334324 2297.61762976193 2301.63902011093 2305.43715134375 2305.26378869484 2305.07847711621 2304.93046022336 2308.92747581780 2312.64509718439 2316.65795805553 2320.45348447105 2324.39916721601 2332.83297980278 2340.28926214735 2339.80391671641 2343.44815756029 2342.94052849877 2341.77076105564 2340.96930928037 2335.77928559437 2322.30376266919 2275.43254447195 2234.45953768257];
dVel_007b=[33.0608653009089 34.0063367031087 34.4701681297407 36.1293602616843 36.7851531169495 36.9182896962319 37.0523814123856 37.1884679214568 37.3243034496047 37.4620004010273 37.6008708476553 37.6698893382633 37.7395140674290 37.8802237663581 38.0210704338166 38.1644819251397 38.2358377565047 38.3077288554664 38.3795873204108 38.4518454702375 38.4514787856763 38.5974782420276 38.5970526188841 38.6699523630323 38.7439208608171 38.7433749293931 38.7431869514533 38.8167890470435 38.8166857345551 38.8910524887645 38.8902947012033 38.8901965179529 38.9643915523851 38.9639243278184 39.0388233501735 39.0387291070249 39.1137593361212 39.1132624022037 39.1128500370090 39.1880144566918 39.2628539230966 39.2624111599664 39.2619379109162 39.2615599283355 39.3371510496250 39.4122741917397 39.4884011684087 39.5642200916923 39.6406749086925 39.7957411235505 39.9493052306546 39.9480500679059 40.0249960052378 40.0236817511400 40.0206541373492 40.0185805456828 39.9376503915619 39.7018411789645 38.8632040913019 38.1303868344932];
Sigma_007b=[1.03500000000000 2.06900000000000 2.54600000000000 3.50100000000000 5.01300000000000 6.52500000000000 7.87800000000000 9.07200000000000 10.1860000000000 11.5390000000000 12.7320000000000 14.1650000000000 15.1990000000000 16.7910000000000 19.0190000000000 20.5310000000000 21.8040000000000 22.8390000000000 24.0320000000000 25.6240000000000 26.5790000000000 28.1700000000000 29.4440000000000 30.6370000000000 31.5130000000000 32.4680000000000 32.9450000000000 33.5820000000000 34.2980000000000 35.1730000000000 36.1280000000000 36.8440000000000 37.5610000000000 38.2770000000000 39.1520000000000 39.8680000000000 40.3460000000000 40.9820000000000 41.8580000000000 42.4940000000000 43.4490000000000 44.2450000000000 44.9610000000000 45.9160000000000 46.6320000000000 47.3490000000000 47.9850000000000 47.1100000000000 47.1100000000000 48.4630000000000 48.8610000000000 49.5770000000000 49.0990000000000 49.6560000000000 49.8150000000000 50.4520000000000 50.5320000000000 50.1340000000000 46.9510000000000 38.9930000000000];
error_Vel_007b=100*dVel_007b./Vel_007b;
error_Qinv_007b=100*dQinv_007b./Qinv_007b;

%limestone samples, corresponds to Fig. 7 of manuscript

% Limestone s-wave
Qinv_003L=[0.0712595117907669 0.0687475973786715 0.0620879860927418 0.0584197492081813 0.0561630941908167 0.0554470760854647 0.0536059288046692 0.0525083585942839 0.0512666631493578 0.0511266597493543 0.0505104277715666 0.0500243158942099 0.0500731657937886 0.0509599653836186 0.0512110295552529 0.0509320716912508 0.0513958993802855 0.0520227187778243 0.0527731288791326 0.0529482453208161 0.0510055402081363 0.0512388831582257 0.0513965746418108 0.0541582773881589 0.0589004621119884 0.0441155403349374 0.0680199924631548 0.0762948514464039 0.0909706425816675 0.105600735412874 0.110146545884175 0.109895553530751 0.105690767985530 0.0998400619294522 0.0952806894215490 0.0890523189089549 0.0728426709196481 0.0526278146778042 0.0766862413571479 0.0846082245804539 0.102939367326396 0.0902968562367061 0.0911089417519704 0.0923315534602947 0.0362501585287352];
dQinv_003L=[0.00187381547058376 0.00180848694517500 0.00163484377677696 0.00153886147536133 0.00147982746262239 0.00146116606382988 0.00141291524724750 0.00138422478111298 0.00135160572909945 0.00134808805244912 0.00133186918937373 0.00131906714121157 0.00132056986716795 0.00134388943694845 0.00135052570644523 0.00134319810779142 0.00135533711006991 0.00137181169256010 0.00139158802434854 0.00139601960208267 0.00134458147276698 0.00135048211501048 0.00135450858135135 0.00142713639864782 0.00155202262565267 0.00116232084469259 0.00179180246817694 0.00200980135629586 0.00239618576394097 0.00278114796789290 0.00290048427854924 0.00289409025195146 0.00278372692740291 0.00262959241434169 0.00250962845007452 0.00234568487137009 0.00191885174183201 0.00138604719872253 0.00201931934759354 0.00222767887539845 0.00270956337778908 0.00237773671199987 0.00240026688836493 0.00243288024082369 0.000953857380973890];
Sigma_003L=[0.239000000000000 0.796000000000000 1.98900000000000 3.02400000000000 3.97900000000000 4.93400000000000 6.44600000000000 7.71900000000000 9.15100000000000 11.3800000000000 12.4940000000000 13.6870000000000 15.5970000000000 16.5520000000000 17.6660000000000 19.4960000000000 20.5310000000000 21.5650000000000 23.1570000000000 24.9080000000000 26.0220000000000 27.6130000000000 28.5680000000000 30.0800000000000 31.0350000000000 32.3880000000000 34.2980000000000 35.3320000000000 36.2080000000000 36.9240000000000 37.2420000000000 37.4810000000000 37.1630000000000 36.8440000000000 36.2870000000000 35.4120000000000 35.0140000000000 34.0590000000000 30.3190000000000 26.4200000000000 21.8840000000000 17.9050000000000 18.0640000000000 16.2340000000000 14.6420000000000];
Vel_003L=[2547.25581572645 2560.93548450227 2582.09244981100 2596.28472950890 2605.74537957091 2610.49370052976 2620.72352102618 2625.29639967131 2630.54078933377 2635.48132827698 2635.31545376057 2635.22610489388 2639.93540113511 2634.39300944242 2634.30862440165 2634.14812736334 2628.76607561529 2623.19500580123 2617.41376941612 2601.01328858691 2585.02862442556 2563.81589215797 2553.36527724870 2543.09051658137 2532.48120096827 2522.34611116712 2502.18213382256 2496.79652030843 2486.85362001023 2472.15629394051 2457.56597349099 2451.92706913802 2445.91254373483 2435.86220432490 2430.49285488237 2420.16258723842 2404.80386315289 2377.00348972173 2330.91405402034 2281.72805276411 2218.69706901042 2139.26463715479 2136.46190894133 2100.89901747932 1848.58247665014];
dVel_003L=[43.4873658996787 43.7624324010565 44.2228706392156 44.5073560675885 44.6987311826146 44.7949915097844 44.9906435495187 45.0874669186463 45.1865537007825 45.2851384509515 45.2846663874374 45.2844121191099 45.3826990456656 45.2820416486298 45.2818015762759 45.2813449857838 45.1815116079920 45.0815062419557 44.9812696895505 44.6853915322670 44.3938738068280 44.0103259382632 43.8210340380080 43.6335730543362 43.4465162002496 43.2620820264277 42.8973801887632 42.8060620483609 42.6266315331364 42.3604063271963 42.0972253082730 42.0080185694810 41.9181112989371 41.7445106086942 41.6572374677762 41.4846704495995 41.2283783419751 40.7311878411451 39.9250988946629 39.0725024298124 37.9678832251198 36.6431423979093 36.6364333165483 36.0407023420920 31.6093588895212];
strain_003L=[-0.00359296870056118 -0.00296068528783468 -0.00112482614104387 -0.000519288364389130 -7.76365041294945e-05 0.000147585712594130 0.000339836395454412 0.000655375237667235 0.000721879513073368 0.000912458308809103 0.000975685281506437 0.00100974600169245 0.00129604193431183 0.00132744188339733 0.00135963281287416 0.00142086439017925 0.00139991010464242 0.00145986597695788 0.00160933055367111 0.00174809777772719 0.00180288169947585 0.00195450219601470 0.00201926595658859 0.00204752448166482 0.00224111948034004 0.00227919490652389 0.00240881444350335 0.00260001608818237 0.00267293336246397 0.00275298481310516 0.00285901235741824 0.00322808243116758 0.00376103904701641 0.00403812299815246 0.00433139590145479 0.00477385043643181 0.00544254049712703 0.00576290414202383 0.00678233393514834 0.00808681321344293 0.00942401892792123 0.0131178599995393 0.0144516463963040 0.0160903805755356 0.0214547403256054];
error_Vel_003L=100*dVel_003L./Vel_003L;
error_Qinv_003L=100*dQinv_003L./Qinv_003L;

% Limestone p-wave
Qinv_004L=[0.129528155037149 0.125767874366755 0.121080755181457 0.118884175825494 0.117178724087164 0.116611748290578 0.114905911193006 0.114039244325259 0.112562000843164 0.110781560418506 0.107965133536809 0.104227632531623 0.101340182675822 0.0987509173837504 0.0972636699088986 0.0983737328966770 0.101514072791761 0.110703297786420 0.121048059030672 0.120326605252957 0.122466290046886 0.124140509190328 0.122665224039301 0.121718201044362 0.120713892722834 0.119402850070924 0.116311194793057 0.117043445989867 0.120857253073814 0.121461215663346 0.124046426953752 0.124057522039567 0.125620417211449 0.126451248473776 0.126333560866505 0.127183985706231 0.129072404076430 0.126873789284039 0.123034573740648 0.125582093871119 0.133023058925368];
Sigma_004L=[0.640000000000000 1.35000000000000 2.79000000000000 4.38000000000000 5.49000000000000 6.29000000000000 7.40000000000000 8.51000000000000 9.87000000000000 11.4600000000000 12.4900000000000 14.0900000000000 15.0400000000000 16.3100000000000 17.5100000000000 18.7000000000000 19.9700000000000 21.0900000000000 22.5200000000000 23.1600000000000 23.8700000000000 24.9100000000000 26.0200000000000 26.7400000000000 27.5300000000000 28.2500000000000 28.7300000000000 29.2800000000000 29.6800000000000 29.7600000000000 30 30.0800000000000 30.2400000000000 30.3200000000000 30.0800000000000 29.4400000000000 28.0100000000000 26.3400000000000 25.7800000000000 21.2500000000000 19.1800000000000];
Vel_004L=[4494.73086081172 4517.72824527455 4513.26887028872 4537.18911089316 4522.46154353047 4534.86933313341 4533.58585535881 4532.85497620547 4531.85490055154 4530.09482422311 4529.09901025521 4540.70344904496 4539.41275283734 4538.11920741071 4561.66968168237 4560.36943920938 4572.75363233462 4625.00541895874 4623.66240598788 4635.56837374327 4662.36271357222 4660.31058382309 4686.34257468408 4727.80731130321 4755.15945145289 4768.44408462676 4724.79756266008 4752.05231167013 4868.18964884160 4779.62189555825 4764.13382419331 4665.45937687235 4651.23405774900 4622.96082515458 4596.08721995114 4564.16923188931 4556.75140242761 4474.79747453091 4460.85203917518 4269.46992198598 4175.06321110095];
dQinv_004L=[0.00370605471607181 0.00360106929873030 0.00346788610589060 0.00340729610059171 0.00335787617718486 0.00334267703754734 0.00329405762512866 0.00326936995912297 0.00322723189918722 0.00317655424277827 0.00309599945790140 0.00298993192858944 0.00290734813797636 0.00283330632103723 0.00279268512379427 0.00282479877816458 0.00291595066476213 0.00318379349435803 0.00348160764927634 0.00346222188119052 0.00352595220899927 0.00357462460794016 0.00353456657089463 0.00351050756236901 0.00348385030086504 0.00344727118615140 0.00335519913771603 0.00337857704806641 0.00349733490368566 0.00350845922088609 0.00358229958962511 0.00357524862595002 0.00361934717684886 0.00364141577613718 0.00363592120138668 0.00365958306870939 0.00371574110561709 0.00364730823481355 0.00353625719152581 0.00359724764597740 0.00380343747887097];
dVel_004L=[91.9657960182612 92.5670779101626 92.5289082061055 93.1430955408856 92.8116254116934 93.1231691767739 93.1121469416509 93.1058711176758 93.0972847442190 93.0821758934989 93.0736291389915 93.3794926130934 93.3683951410186 93.3572750136015 93.9758026335944 93.9645831301029 94.2810848323108 95.5844703658170 95.5727630830851 95.8920133358527 96.5608472095047 96.5428524156245 97.2107478404528 98.2450286416857 98.9395737272009 99.2856625842683 98.2183683370841 98.9119361536107 101.812967655819 99.6144712183234 99.2472486097075 96.8069864208332 96.4633166642701 95.7819953843818 95.1187123556046 94.4175418178193 94.3534832844324 92.4043575077344 92.0819039664464 87.5514705749395 85.3104056167436];
strain_004L=[-0.000781402492089866 -0.000250498766846001 0.000738081809872075 0.00111890993699004 0.00153393292398368 0.00163142294831809 0.00191520956088278 0.00207688426680688 0.00229819129587803 0.00268791640470337 0.00290854880005125 0.00319589398848943 0.00348135515485374 0.00376760939363080 0.00430888009275858 0.00459544841471365 0.00475403906246966 0.00495490259759315 0.00524703316578422 0.00558887590147365 0.00567432364865300 0.00611750697904604 0.00643219308689369 0.00651334505078240 0.00671677529022542 0.00692727042653055 0.00715500122642847 0.00737552833525140 0.00747637492784459 0.00759901317544863 0.00783897334232540 0.00796472070117577 0.00808238738812725 0.00833339985577583 0.00834915620701827 0.00954873086955326 0.0111934191803341 0.0122102358234289 0.0125063112383811 0.0148876084734639 0.0158123932226441];
error_Vel_004L=100*dVel_004L./Vel_004L;
error_Qinv_004L=100*dQinv_004L./Qinv_004L;

% Limestone s-wave
Qinv_005L=[0.0669822614127828 0.0733538395234030 0.0757186290829073 0.0754831896350039 0.0732113049372945 0.0731815060285153 0.0725021661229347 0.0716312892890912 0.0708973307407931 0.0690611960715479 0.0679714513212898 0.0669970363403850 0.0661033584938540 0.0649999947288629 0.0651078795721261 0.0651461640002543 0.0649863043795485 0.0647322481502962 0.0662313045192817 0.0713070583900275 0.0745581598283039 0.0833968000170667 0.0905224753163447 0.0974118331595392 0.0816781369429947 0.0801364905834851 0.0838999062247328 0.123289494067820 0.0899452508121219];
Sigma_005L=[0.796000000000000 1.59200000000000 2.30800000000000 3.34200000000000 4.05800000000000 4.77500000000000 5.57000000000000 6.52500000000000 7.32100000000000 8.35600000000000 9.23100000000000 10.0270000000000 11.2200000000000 12.3350000000000 14.0850000000000 14.0060000000000 14.8010000000000 15.1200000000000 14.4040000000000 14.9610000000000 15.9150000000000 15.7560000000000 15.9150000000000 15.6770000000000 15.2790000000000 11.3000000000000 13.8460000000000 14.6420000000000 13.4490000000000];
Vel_005L=[2454.45534710999 2465.48946071750 2478.66015805982 2495.33908998874 2499.43888864450 2507.91931063328 2516.70678552706 2520.32560640984 2524.27829905343 2528.48621690262 2532.79764926089 2532.08003449083 2536.07941227603 2540.65900965221 2544.02851052576 2537.32832713519 2532.18787147621 2537.08736714026 2531.62396097294 2521.49155183813 2516.41265864548 2515.97420300860 2500.25488526092 2484.55459972519 2464.11794492586 2481.20845549325 2480.33479882105 2440.98059174070 2254.27608018133];
dQinv_005L=[0.00175941817290930 0.00192798192145162 0.00199081017651410 0.00198583658426974 0.00192639336076860 0.00192619944416384 0.00190884020289538 0.00188638283296880 0.00186743729487961 0.00181938576158030 0.00179096288718874 0.00176546623587502 0.00174227530651771 0.00171341187270434 0.00171676930111274 0.00171806778742300 0.00171377078178379 0.00170720961011572 0.00174674177793201 0.00188040671772991 0.00196604802809211 0.00219925376130430 0.00238703803082522 0.00256863610591741 0.00215361585682185 0.00211412501926191 0.00221368907564207 0.00325202187089952 0.00237027065792417];
dVel_005L=[41.7943699153655 42.0445506702439 42.3031384691527 42.6497304975164 42.7369465074313 42.9130677536988 43.0912743996281 43.1787201511406 43.2673959386797 43.3570902321992 43.4473890456831 43.4454098119295 43.5351657974837 43.6268470384069 43.7155052674757 43.6176424922575 43.5244275803457 43.6169769775608 43.5228726886123 43.3378444006839 43.2457851806027 43.2445821960267 42.9690318322652 42.6964195291272 42.3386897386334 42.6873366909389 42.6849669178490 41.9786567219799 38.6821873279868];
strain_005L=[-0.00259499997499988 -0.00131037024717930 -0.000834701713425627 0.000251074265039437 0.000567344144237909 0.00110744437265148 0.00155232676999499 0.00209411930554287 0.00250925302007847 0.00282947627021483 0.00311544947073439 0.00340047847897758 0.00381685094054372 0.00400996726315647 0.00468931206232099 0.00533131704022859 0.00536354195868736 0.00542704536562716 0.00558806236021236 0.00561855657760211 0.00565095870487644 0.00582666532209778 0.00616808610844383 0.00657704607886624 0.00703587009078362 0.00793801675598349 0.00829396196195564 0.00874316169259656 0.0122557438060103];
error_Vel_005L=100*dVel_005L./Vel_005L;
error_Qinv_005L=100*dQinv_005L./Qinv_005L;


%Shale samples, corresponds to Fig. 5 of manuscript

% Shale s-wave
Sigma_36s=[2.53000000000000 3.25000000000000 6.06000000000000 9.02000000000000 10.1100000000000 11.5500000000000 13.2100000000000 14.5800000000000 15.5200000000000 16.8900000000000 17.9000000000000 18.8400000000000 19.8500000000000 20.7900000000000 21.2900000000000 21.8000000000000 22.8100000000000 23.8200000000000 24.8300000000000 24.8300000000000 26.1300000000000 27.1400000000000 28.1500000000000 29.0900000000000 29.9500000000000 31.0400000000000 32.6200000000000 33.7100000000000 34.7900000000000 36.8100000000000 37.8200000000000 38.6900000000000 39.7000000000000 40.1300000000000 41.8600000000000 43.3800000000000 44.5300000000000 45.5500000000000 46.3400000000000 47.2800000000000 48.7900000000000 49.3700000000000 50.7400000000000 52.4700000000000 53.2700000000000 54.2800000000000 54.9300000000000 54.5700000000000 46.9200000000000 47.6400000000000];
strain_36s=[0.00374108081771571 0.00402642050155863 0.00560546580859975 0.00646876483961673 0.00675481476536093 0.00718770720419668 0.00775891925330849 0.00833581323763060 0.00847732893646247 0.00883316012900834 0.00890382919818661 0.00923249363800817 0.00948782560152162 0.00951395298624759 0.00962057073618704 0.0100144813351980 0.0102236329086324 0.0104358030101472 0.0107907317693333 0.0107907317693333 0.0111236134480043 0.0113375591542724 0.0115468883236942 0.0117632828730137 0.0119840794306133 0.0121909597569836 0.0125009065882749 0.0127040581091514 0.0130528092197922 0.0134723553255003 0.0138260411258471 0.0141885309782659 0.0145406187343347 0.0146519936135048 0.0149515383839582 0.0155546005564035 0.0156097036444643 0.0161065031879208 0.0164774789395520 0.0166938734888716 0.0170085774493935 0.0172530191317861 0.0174364318938387 0.0178849499030875 0.0181108587108683 0.0187486413072428 0.0191280659189713 0.0195888278948927 0.0204533539753305 0.0209709576759749];
Vel_36s=[1619.52553429112 1633.15248165533 1654.56965200824 1687.91546899254 1718.41714621850 1728.24946041044 1732.59402802373 1742.35408311573 1747.53774396949 1746.91295638099 1752.25187192729 1757.16844210151 1762.24593532777 1762.19962632421 1767.57345132960 1766.87306751300 1772.09582761428 1771.71738861209 1771.08431691861 1771.08431691861 1776.11565671760 1781.39256235849 1781.01681054247 1786.32185024359 1785.92424687372 1785.55170340738 1790.71930040247 1796.11370769105 1795.48164588504 1800.51539288451 1799.87231822066 1805.04066594139 1804.39842342705 1810.05781900947 1809.50964457208 1814.30141889005 1814.20025011993 1819.21877336519 1818.53543757773 1824.10285366800 1823.52126811851 1823.06953007894 1828.73135460420 1827.89974649253 1833.51717371623 1734.91175883966 1723.46335977139 1717.31939308844 1715.81081817093 1714.90761353932];
Qinv_36s=[0.0768642037248966 0.0774801608631210 0.0696451698506265 0.0667017307423327 0.0653668494269704 0.0625551114864392 0.0608573485056751 0.0594390824284852 0.0578518870061391 0.0570370744119804 0.0566200327426933 0.0562718300667342 0.0563817222437772 0.0563817222437772 0.0560254928382197 0.0559067321989925 0.0563352685341022 0.0563352685341022 0.0555549964376530 0.0555549964376530 0.0556897499728197 0.0558704491765783 0.0556877413838401 0.0556547233661836 0.0553049351760679 0.0549304822779159 0.0551317685882452 0.0551438079720000 0.0551071297348849 0.0553290457417174 0.0552507979104232 0.0561397800352091 0.0561897837025961 0.0566585567568128 0.0570111596016307 0.0576873194523059 0.0581683226490126 0.0588321302785460 0.0593695072541083 0.0602247543200217 0.0611406110371527 0.0618340391614828 0.0638590567715709 0.0678646041976933 0.0705841362092542 0.0674895801662998 0.0680612257884024 0.0651195223455047 0.0635969855576830 0.0662275135511742];
dQinv_36s=[0.00210513042934353 0.00212269315854814 0.00190997837096049 0.00183084226114515 0.00179521376819977 0.00171856511577276 0.00167245254955331 0.00163412339169622 0.00159070452214770 0.00156853646844309 0.00155723395277336 0.00154799212863294 0.00155130318976427 0.00155132036458365 0.00154170851198770 0.00153869740527845 0.00155075059770093 0.00155089023088797 0.00152964013281342 0.00152964013281342 0.00153368762731281 0.00153892524472536 0.00153402919705260 0.00153338210198660 0.00152388803572715 0.00151370358603853 0.00151957167088773 0.00152015635263714 0.00151937115754648 0.00152588497052094 0.00152395717802390 0.00154884195826582 0.00155045493566190 0.00156359057662194 0.00157352296667656 0.00159272558188228 0.00160604383475388 0.00162485007136656 0.00163995268100369 0.00166386753149143 0.00168939891257116 0.00170873885221236 0.00176498270003884 0.00187605300279403 0.00195158242158036 0.00186401712257918 0.00187982841407461 0.00179880280116026 0.00175740470314546 0.00183050695749319];
dVel_36s=[30.3021728872278 30.5785210339147 31.0468344290819 31.7311736448814 32.3433921191743 32.5515068403870 32.6553317999058 32.8669313611388 32.9742640048202 32.9730141129547 33.0812821180053 33.1893352793078 33.2983485191745 33.2982551348175 33.4085102563535 33.4070941657633 33.5176909753636 33.5169239273669 33.5156410981312 33.5156410981312 33.6264994248461 33.7385176807442 33.7377523624527 33.8504943252287 33.8496824306131 33.8489218539375 33.9620528292112 34.0763285143045 34.0750314056827 34.1892493779762 34.1879266834872 34.3031089325309 34.3017848899925 34.4186765237190 34.4175435050489 34.5333439723451 34.5331343934226 34.6501120822769 34.6486931962162 34.7675256072902 34.7663150091552 34.7653749321240 34.8851267897253 34.8833918602296 35.0037822226466 33.0466537076817 32.8294221614982 32.7209250806897 32.7179553646978 32.7161784748997];
error_Vel_36s=100*dVel_36s./Vel_36s;
error_Qinv_36s=100*dQinv_36s./Qinv_36s;

% Shale s-wave
Sigma_47s=[0.270000000000000 1.93000000000000 4.85000000000000 9.94000000000000 14.9500000000000 19.8100000000000 24.7200000000000 29.7000000000000 34.9600000000000 36.9300000000000 38.0500000000000 38.9600000000000 39.9200000000000 40.9300000000000 42.1000000000000 43.0200000000000 44.1300000000000 45.0500000000000 46.0300000000000 46.9900000000000 47.9300000000000 49.0700000000000 49.9100000000000 51.1200000000000 50.7100000000000 51.1800000000000 52.1900000000000 52.9300000000000 53.4600000000000 53.9200000000000 54.9300000000000 56.3200000000000 56.8000000000000 57.1900000000000 57.4800000000000 57.4200000000000 57.5100000000000 57.6900000000000 57.9700000000000 58.7300000000000 59.2700000000000 59.5400000000000 59.2200000000000 59.7500000000000 60.6000000000000 60.9200000000000 61.4500000000000 62.0300000000000 60 58.8700000000000 57.4611735200000 57.4611735200000 57.4400000000000 57.6600000000000 57.8100000000000 57.7000000000000 57.9500000000000 58.3100000000000 58.1900000000000 57.8500000000000 57.6083212100000 57.7554689000000 57.8290427500000 56.8500000000000 56.9300000000000 57.6300000000000 57.4611735200000 56.4311396800000 56.1368443000000 55.9896966000000 55.4011058400000 55.0332366100000 55.0332366100000 55.1068104500000 55.1803843000000 55.1803843000000 54.9596627600000 54.6653673800000 54.5917935300000 54.5917935300000];
strain_47s=[3.32104423963032e-06 0.000603938045058698 0.000832967095954685 0.00139114853148959 0.00179348689103888 0.00224883895678374 0.00253284482002585 0.00301843560858074 0.00354353944348893 0.00373680699800602 0.00387677794255897 0.00397896524379601 0.00407806520390658 0.00417358581633666 0.00436791118494489 0.00441875514223725 0.00455668671962379 0.00465537831429452 0.00475105390878912 0.00485347491313932 0.00495452321920380 0.00509168480633331 0.00519804678318120 0.00533386273238546 0.00540572274963275 0.00548275375576278 0.00558098040423996 0.00568933500763164 0.00576371901850105 0.00588889532597464 0.00603890566426235 0.00616530460802268 0.00629050059575844 0.00642698567387616 0.00646324901694015 0.00651644968562626 0.00661106500599695 0.00665207867233999 0.00673882434787914 0.00679738296793852 0.00691784093255906 0.00710808264676894 0.00717566466702903 0.00719949500447296 0.00735635899405816 0.00744031499243601 0.00757250977340269 0.00763974738907497 0.00785072717953676 0.00796911133653211 0.00819970268043941 0.00819970268043941 0.00822840617059860 0.00824399785829547 0.00828578151489556 0.00834883461482590 0.00844446838876341 0.00847446602836197 0.00849673424499688 0.00862456738786218 0.00866242999823001 0.00867915339940243 0.00872472309563636 0.00908090346671508 0.00918910062800946 0.00935116758690342 0.00976871158120697 0.00983707279224667 0.00987161517018568 0.00989815761995765 0.00997948101426659 0.0102993588539593 0.0102993588539593 0.0104515709707769 0.0105976330056693 0.0105976330056693 0.0106603095729838 0.0109477740700984 0.0111041730642894 0.0111041730642894];
Vel_47s=[2074.24251833637 2099.78312538150 2113.50304139305 2134.53691284025 2151.78054324001 2162.26533991953 2174.40128246289 2183.88302219748 2193.37020465155 2197.70496101675 2198.58929892462 2198.36375739223 2205.32950820309 2203.91743442970 2208.29651582686 2209.38925333416 2210.28981524294 2212.48771573146 2213.48543022095 2214.46922674687 2215.45715725254 2216.36572097801 2217.34393102149 2218.25752776091 2215.66613831432 2220.36176254295 2220.14246220718 2219.90055024871 2220.95428607518 2217.01972436945 2221.56037668054 2218.83790284291 2216.12408622007 2215.81970464945 2212.09800805882 2211.97955778535 2214.19442280934 2212.88962988623 2219.99602327879 2185.02478912138 2187.12713233836 2190.26812648123 2219.01966323114 2205.62649332150 2190.90938143065 2182.42922582351 2182.13855837799 2179.04406453581 2175.64271213617 2180.08729268270 2180.75949818514 2186.67343813751 2186.61015427935 2192.52161590022 2191.23754035903 2195.87251958934 2198.05548119973 2196.79100279933 2194.34967213410 2208.49551465542 2218.13586190917 2208.37391333886 2207.06287918419 2202.65053255656 2200.00400289637 2193.65300113913 2190.34208664925 2177.15927899128 2171.21120607945 2171.15300244448 2170.97467236577 2169.10310851962 2167.93425016113 2167.60083140770 2167.28088433242 2166.11363690191 2168.31202415847 2171.19384462469 2170.85051453112 2175.54997351536];
Qinv_47s=[0.0505454769823239 0.0456732368616086 0.0444976007831164 0.0443191199975435 0.0443055024210220 0.0441455525045712 0.0436460310513695 0.0430718424820840 0.0426007488292463 0.0425966402759544 0.0426343634191010 0.0426483159550605 0.0432125083404452 0.0432131952104655 0.0434919694330056 0.0431274768915691 0.0431753772981651 0.0434003405228076 0.0435849394977860 0.0438387529728868 0.0438234121627433 0.0440674520814820 0.0443632237695603 0.0445297500490192 0.0445262726224109 0.0447885719855998 0.0447336290812734 0.0435054094772099 0.0436263463221394 0.0451695643781740 0.0454973932050125 0.0457682140373749 0.0460939679218875 0.0462778243482085 0.0469726538377783 0.0472026763702190 0.0473383825099573 0.0474000359242319 0.0475736247859434 0.0470813050335705 0.0472170710177880 0.0476719514264972 0.0485215773988951 0.0487592580371247 0.0488570518120246 0.0488178964012636 0.0489330796448678 0.0489359756148941 0.0467774511336859 0.0456454430720484 0.0456406726848066 0.0456306925182863 0.0455048265149067 0.0456966441949939 0.0456219249274534 0.0460040688587695 0.0461798415899470 0.0466610459011896 0.0470852439131766 0.0476771851094559 0.0476534175274158 0.0464711676445409 0.0477629536297017 0.0460069215291147 0.0457198668290730 0.0452440679675873 0.0451267728647881 0.0444553956318361 0.0438766649081877 0.0438188920217533 0.0447468069366941 0.0460065171776025 0.0464550881748353 0.0465396107627605 0.0465396107627605 0.0466008985797996 0.0464544000754122 0.0463205740085471 0.0460043383365274 0.0459607907588033];
dQinv_47s=[0.00121885219127472 0.00110159831424783 0.00107349218102096 0.00106940387695678 0.00106931183882298 0.00106576542726744 0.00105390857407375 0.00104036156966545 0.00102918581771955 0.00102920047137632 0.00103027401671421 0.00103063879317868 0.00104430019716381 0.00104440626165115 0.00105119745711115 0.00104246499085919 0.00104366060575321 0.00104912573081205 0.00105320199704165 0.00105936375661775 0.00105902118201295 0.00106550421491199 0.00107275148153556 0.00107681671258233 0.00107681926033099 0.00108318462364258 0.00108188381168343 0.00105227427188169 0.00105522004705289 0.00109258290081739 0.00110055604154945 0.00110721248108975 0.00111506073340252 0.00111954867511551 0.00113643916928161 0.00114202026338970 0.00114533210070601 0.00114683618040607 0.00114636639379889 0.00113452078870927 0.00113788477840607 0.00114890509638948 0.00116934479460181 0.00117508022852083 0.00117748619999805 0.00117656883767262 0.00117944442315032 0.00117953535666720 0.00112751501577076 0.00110031813471808 0.00110027081993418 0.00109997614951050 0.00109700434566953 0.00110163316037478 0.00109979006365913 0.00110902092577812 0.00111334143169623 0.00112495170974788 0.00113512965929631 0.00114949590188020 0.00114893448672200 0.00112043518506822 0.00115159459198126 0.00110930667075456 0.00110247135665047 0.00109109920056860 0.00109300856768784 0.00107676679594213 0.00106275894659053 0.00106136708466973 0.00108386616148194 0.00110976817611952 0.00112053340326418 0.00112261799830355 0.00112266200763291 0.00112414043649368 0.00112057033370568 0.00111748332031550 0.00110990078485223 0.00110885015588022];
dVel_47s=[27.9433358564686 28.3067576350766 28.5128823700157 28.8153743659079 29.0686861726315 29.2377926683230 29.4199128162058 29.5769465364375 29.7240789872007 29.7932985346522 29.8201827026207 29.8196590702655 29.9166130414819 29.9055851493987 29.9698522118284 29.9917333038725 30.0074019227763 30.0397082795067 30.0183313311021 30.0342401164213 30.0501733982739 30.1149436182753 30.1367567747389 30.1525808052924 30.1250253205487 30.1908033439394 30.1902885610666 30.1956174931703 30.2118200295371 30.1614388301024 30.2269850689606 30.1990291718837 30.1593330501232 30.1586175635327 30.1147632553152 30.1144842773100 30.1470124962093 30.1302761139415 29.8380983136208 29.3695335157741 29.4054665377882 29.4524850564814 29.8361157546926 29.6566405126548 29.4627080683642 29.3507771747465 29.3548217542980 29.3148795473380 29.2697846355626 29.3371801312598 29.3520182978909 29.4269755456810 29.4314885934015 29.5114499987506 29.4905703199654 29.5545456708334 29.5910146524785 29.5747514763989 29.5377911357000 29.7361481826573 29.8669185992322 29.7359011444324 29.7194080374805 29.6643741335481 29.6361463308085 29.5593637509255 29.9243802442039 29.7459747339427 29.6655632432553 29.6654254090432 29.6650031179089 29.2523320430062 29.2319616047582 29.2312852508228 29.2306363078495 29.2148933622216 29.2415246545718 29.2922194444931 29.2915233739787 29.3549336879366];
error_Vel_47s=100*dVel_47s./Vel_47s;
error_Qinv_47s=100*dQinv_47s./Qinv_47s;

% Shale s-wave
Sigma_29s=[0.577000000000000 1.29900000000000 2.52600000000000 3.60900000000000 4.40300000000000 5.26900000000000 6.06300000000000 7.07400000000000 8.73400000000000 9.74400000000000 11.0430000000000 12.4870000000000 13.7140000000000 14.8690000000000 16.0240000000000 17.1060000000000 18.1890000000000 19.8490000000000 21.4370000000000 22.3760000000000 23.6750000000000 24.6130000000000 26.8510000000000 27.4280000000000 28.4390000000000 29.3050000000000 30.1710000000000 31.1090000000000 32.6250000000000 33.5630000000000 34.9350000000000 35.8730000000000 36.4500000000000 37.3170000000000 37.7500000000000 38.8320000000000 40.2040000000000 41.2860000000000 42.0800000000000 42.5860000000000 43.3070000000000 44.4620000000000 45.1840000000000 45.6170000000000 46.3390000000000 46.7720000000000 47.6380000000000 48.7210000000000 50.0200000000000 50.4530000000000 50.5980000000000 51.1030000000000 51.6080000000000 52.2580000000000 53.0520000000000 53.7730000000000 54.3510000000000 54.7120000000000 55.6500000000000 56.3720000000000 57.0210000000000 57.3820000000000 57.7430000000000 55.9390000000000 50.5250000000000 48.9370000000000 44.8230000000000];
strain_29s=[1.37825611091960e-06 0.000401378807413364 0.000864626000250230 0.00142496367912299 0.00156079847583251 0.00181010969234108 0.00208269812316740 0.00230735386924729 0.00264824254734807 0.00292649714218595 0.00322848837004523 0.00363737101628471 0.00392343572908447 0.00415084798738620 0.00430551895094496 0.00463905692978750 0.00473293148489791 0.00501960875596919 0.00542481605257955 0.00550691604322272 0.00592346822530077 0.00611026502180478 0.00646200565973215 0.00667172735766405 0.00685562369075241 0.00704639289701931 0.00736135832346476 0.00754953334545178 0.00783196286181711 0.00801814710004960 0.00842291672377496 0.00861109177638989 0.00882265114913635 0.00901479861151417 0.00923966271929012 0.00966583506776656 0.00994977757243463 0.0101306203331674 0.0103310281438366 0.0105494695781357 0.0107512464259139 0.0110472593606944 0.0111249931584898 0.0113438848231184 0.0114214654813460 0.0117627156607107 0.0119534848976055 0.0122594426546683 0.0126746165806354 0.0130196952491971 0.0131338026346438 0.0133476499125343 0.0135613440202291 0.0137667870292624 0.0138402421381591 0.0140409470089622 0.0142552628939305 0.0146029357467721 0.0149116316086806 0.0152388297931804 0.0158144111071516 0.0161611651225859 0.0166302776527563 0.0168677201545913 0.0175841823978012 0.0181822962083715 0.0188160756423707];
Vel_29s=[1551.99200865287 1566.26143198121 1569.30115403435 1572.20267067985 1575.78818420985 1575.39470894741 1574.96449643687 1582.25833060630 1585.56852320567 1585.12616060488 1584.64606206402 1583.99603006397 1587.40591269585 1590.92618034212 1594.58020805661 1594.04605593101 1597.81434060063 1597.35410592090 1600.63878210137 1604.46097196906 1607.76117269142 1611.45027681974 1610.87998039511 1610.53994708191 1614.24986489820 1617.96709865430 1621.50005289805 1621.19266471908 1624.79584970863 1624.49095079433 1627.91063687568 1631.70404898711 1633.41434712964 1635.16099724730 1638.93130420788 1638.22632419911 1637.75662270359 1645.79591245625 1645.46270698171 1649.29888936254 1651.06985702842 1652.68787456283 1656.79802683148 1656.43128809294 1656.30130674905 1655.72956428220 1659.66824293568 1663.43325088701 1667.03332488228 1670.77072207663 1668.41499465920 1670.21555772140 1674.19392663446 1673.84524711411 1673.72057851498 1677.74055105261 1677.37586456058 1681.16515145492 1680.63849269127 1680.08026754936 1683.49671698592 1682.90357841971 1682.10114003066 1681.69498379647 1671.71127289358 1670.69350406399 1669.61504551419];
Qinv_29s=[0.0650002601177616 0.0603373190011110 0.0607701213010369 0.0611362892665600 0.0610234045116668 0.0605317292516875 0.0597293729541704 0.0585217407138447 0.0567537353708704 0.0556057765214044 0.0543642156291736 0.0532952347767176 0.0523256269619387 0.0508708462170936 0.0499390720342422 0.0482876929142454 0.0497493487471234 0.0485897837219030 0.0464761077903928 0.0461831858390285 0.0457283123579364 0.0463286197061437 0.0458312868376872 0.0454609681654671 0.0456645858536012 0.0453816023594890 0.0457922509918238 0.0451480472018145 0.0457781219867421 0.0453300818172521 0.0456235904647500 0.0454810590210091 0.0452251061715438 0.0469823895341207 0.0471031014026004 0.0473832295756689 0.0472697502557927 0.0473649349970518 0.0476357949312884 0.0481526749390779 0.0483434660468310 0.0488694473090932 0.0484938808191438 0.0490772322097178 0.0503764333634484 0.0513394100795554 0.0516704535318250 0.0518647636175611 0.0522031014090556 0.0520768348731646 0.0520460229447919 0.0522899334346714 0.0523157392099736 0.0523479064517695 0.0526376214540736 0.0526757811429103 0.0521654051422282 0.0519498501617375 0.0526876594992982 0.0523682979904447 0.0524914891426518 0.0522006075718278 0.0517205104060260 0.0510310620603125 0.0500593187379272 0.0535301045597326 0.0541711299781737];
dQinv_29s=[0.00167353393619208 0.00155405599519091 0.00156555083373627 0.00157538851241340 0.00157264723279327 0.00156011418420382 0.00153958366767633 0.00150875325879645 0.00146343585499510 0.00143397680739596 0.00140210977755341 0.00137473983622381 0.00134994655693005 0.00131259917807443 0.00128870497732278 0.00124623857808233 0.00128408181505998 0.00125428067602004 0.00119996482507381 0.00119250882181352 0.00118101089145643 0.00119666757829183 0.00118397062707518 0.00117449237224954 0.00117990261429506 0.00117274277934423 0.00118356115765279 0.00116698969401792 0.00118346893731904 0.00117196448346567 0.00117979757346266 0.00117626450809538 0.00116977037331840 0.00121534541088253 0.00121864298177571 0.00122607872783306 0.00122326764905240 0.00122596520058208 0.00123306517816278 0.00124662200374068 0.00125169235769873 0.00126548652244757 0.00125587653895370 0.00127108458635565 0.00130477010413140 0.00132987586124558 0.00133862924692228 0.00134389857510127 0.00135295636388733 0.00134994031463907 0.00134915378432335 0.00135562571027494 0.00135648818504225 0.00135742361067819 0.00136497261216907 0.00136615096636581 0.00135301982472305 0.00134768773949854 0.00136698178470015 0.00135885804027806 0.00136243023785871 0.00135505197002487 0.00134281966602542 0.00132503465071936 0.00129997413764595 0.00139041103229767 0.00140738906905325];
dVel_29s=[25.1636261030836 25.4187569331098 25.4823287084608 25.5459442776940 25.6110660305716 25.6103663280540 25.6096014751483 25.7409513381598 25.8064752166555 25.8056833275444 25.8048241085308 25.8036611335327 25.8696585742768 25.9361584061354 26.0032062216902 26.0022441067082 26.0698061498313 26.0689753484136 26.1359738235320 26.2042583769411 26.2719123249674 26.3405906627860 26.3395518535785 26.3389326298798 26.4079663946087 26.4773373831459 26.5466965551605 26.5461328768161 26.6159466686258 26.6153863416794 26.6851905985228 26.7560152668687 26.7912089395077 26.8265533866549 26.8980081981623 26.8967008882950 26.8958301541691 27.0406824935594 27.0400618033919 27.1126642506570 27.1488209978581 27.1847783369015 27.2585922224478 27.2579043065700 27.2576605244343 27.2565884133551 27.3304309685001 27.4043033260248 27.4782222422527 27.5527601927503 27.5145254767105 27.5517096750466 27.6270651494856 27.6264039000419 27.6261675032331 27.7019676423041 27.7012745107816 27.7770043269119 27.7760012481820 27.7749383514373 27.8503234101675 27.8491919728517 27.8476618485715 27.8468876184033 27.6905253851638 27.6885974799600 27.6865557483100];
error_Vel_29s=100*dVel_29s./Vel_29s;
error_Qinv_29s=100*dQinv_29s./Qinv_29s;

% Shale s-wave
Sigma_22s=[1.09000000000000 2.41000000000000 3.50000000000000 4.36000000000000 5.68000000000000 7.47000000000000 8.95000000000000 10.4300000000000 12.2200000000000 13.9300000000000 15.4100000000000 17.6600000000000 19.4500000000000 21.3200000000000 22.8000000000000 24.9800000000000 26.9200000000000 28.4800000000000 30.1900000000000 31.5200000000000 33.1500000000000 34.4000000000000 35.6400000000000 36.8900000000000 38.1300000000000 39.6900000000000 41.0900000000000 42.4100000000000 43.5800000000000 44.9000000000000 45.9900000000000 47.4700000000000 48.7900000000000 50.1900000000000 50.9700000000000 52.1400000000000 53.2300000000000 54.2400000000000 55.4800000000000 56.9600000000000 58.3600000000000 59.6900000000000 61.0900000000000 61.8600000000000 62.2500000000000 60.0700000000000 57.2000000000000 56.8100000000000 51.3600000000000 30.3500000000000];
strain_22s=[-0.000918736756591365 0.000222062857552368 0.000937451095669740 0.00165066126758994 0.00208605285220233 0.00259540859449396 0.00310028772556985 0.00324942405042131 0.00368067007040802 0.00389553878525333 0.00411425269453090 0.00454874644324715 0.00498325801430209 0.00511312152327737 0.00543364903574599 0.00599637039886926 0.00613812901375571 0.00659593998327180 0.00690005401885475 0.00723312190922776 0.00768703395270454 0.00803074455006803 0.00822492778419157 0.00856648079642158 0.00890664123617389 0.00952014583643044 0.00985726284152922 0.0103373876838459 0.0106909103659177 0.0110270329564234 0.0110892311685173 0.0118571317667161 0.0121956645452770 0.0123804823287111 0.0126145453905527 0.0132649569424153 0.0136187446860830 0.0138368743937079 0.0141822379756905 0.0143611794894217 0.0149916308583202 0.0151824387975060 0.0156705276967186 0.0157564858610014 0.0164684371927819 0.0176802155520836 0.0183511598278343 0.0189772878490567 0.0207481414974990 0.0242035852571248];
Vel_22s=[1663.22839690501 1663.78142489725 1665.04723144057 1666.32210174006 1665.59867020498 1669.68941215641 1671.32756012694 1676.05647224998 1675.33688710350 1677.47669489939 1679.61662161362 1681.40214167291 1683.19361087363 1685.50140859874 1692.58304449640 1694.19042156738 1696.51268633405 1698.30905691066 1700.37088899928 1702.39039303976 1706.80808592592 1708.82950666030 1711.11103947547 1711.05487456122 1712.57235897829 1714.15544252751 1713.58365204014 1715.39893334334 1720.07976016670 1724.81958631701 1730.05738664446 1733.04114948181 1733.53887437076 1735.38007957981 1738.22474828164 1742.54257147532 1747.39974061643 1747.02407074287 1749.17341485863 1753.71433140400 1761.61798615441 1764.64038198541 1766.03454069570 1765.88520462594 1764.64929388890 1762.54968264126 1764.19184324045 1757.51588201137 1740.66526750366 1732.61597339125];
Qinv_22s=[0.0445358048122227 0.0423252416648527 0.0428531965574240 0.0430976543977075 0.0432911966382586 0.0430286748260677 0.0424658520414711 0.0423621818542818 0.0421111058037369 0.0420150227283827 0.0420775787528304 0.0419742357820730 0.0425197500976985 0.0424437408691886 0.0427973887246738 0.0427285554514233 0.0427504141848440 0.0429189635822068 0.0429920705220574 0.0436184141923161 0.0436502080105482 0.0438077882601372 0.0440429772499086 0.0443579786702227 0.0445623960714006 0.0446763474337282 0.0447794990208605 0.0447354984832285 0.0447959345819647 0.0447783861363946 0.0446173761088242 0.0447029101059154 0.0446591971356600 0.0452163368872924 0.0450079881598001 0.0452044040558110 0.0446087757451612 0.0445022868309516 0.0446590007522767 0.0457525377093457 0.0462441573667038 0.0464983608865173 0.0458712872735457 0.0461337177034848 0.0466202685266934 0.0487385432020570 0.0457063166029430 0.0447615595351578 0.0379110885089900 0.0210581173214229];
dQinv_22s=[0.00121869724933473 0.00115880044982360 0.00117364799864613 0.00118073745276762 0.00118625595732073 0.00117939796916272 0.00116425884140785 0.00116157254439601 0.00115489636208920 0.00115240640003357 0.00115426949911245 0.00115168557286562 0.00116690772272064 0.00116492732052728 0.00117491971268023 0.00117334909466895 0.00117406202263839 0.00117895995684426 0.00118116187128632 0.00119858116055815 0.00119977131566540 0.00120432034692836 0.00121092928286757 0.00121977328851626 0.00122560528464865 0.00122910043350989 0.00123211193636051 0.00123119443723290 0.00123313245921842 0.00123291546049694 0.00122860709795979 0.00123143237736564 0.00123042103504338 0.00124590516696303 0.00124034236244626 0.00124618931125226 0.00123004545113710 0.00122722099364028 0.00123176785274611 0.00126210956364879 0.00127616784248958 0.00128334530574965 0.00126633600640141 0.00127362647664805 0.00128744174652452 0.00134662069056120 0.00126324537762889 0.00123736113272785 0.00104856445441723 0.000583261099824511];
dVel_22s=[31.0633203289609 31.1078515697239 31.1538713335002 31.2000374845429 31.1986544476156 31.2943253569684 31.3415799611155 31.4392797153031 31.4378961932316 31.4865168944104 31.5352742008875 31.5834847302382 31.6318427314441 31.6813355540252 31.8309607219263 31.8796543090107 31.9298774578630 31.9792187568650 32.0292184628070 32.0792780802237 32.1805678740216 32.2310628622445 32.2822129387060 32.2914550779641 32.3318989725347 32.3819682372296 32.3808447464789 32.4315146177742 32.5353647851479 32.6399324157976 32.7460937834528 32.8290706691297 32.8493824331862 32.8917591335507 32.9556747265884 33.0618545669095 33.1697377360975 33.1689860345895 33.2226050538159 33.3188807982297 33.4965077876694 33.5629208335138 33.6060728094501 33.6057710017694 33.6032741061176 33.5990358694716 33.6529116169116 33.5384904696637 33.2550678840644 33.1994608869823];
error_Vel_22s=100*dVel_22s./Vel_22s;
error_Qinv_22s=100*dQinv_22s./Qinv_22s;

% Shale p-wave
Sigma_47p=[0.706000000000000 1.64600000000000 2.97900000000000 4.07700000000000 5.33100000000000 6.89900000000000 7.99700000000000 9.48600000000000 11.0540000000000 13.2490000000000 15.2870000000000 17.4830000000000 19.4420000000000 21.7160000000000 22.8920000000000 24.0680000000000 25.4790000000000 27.2040000000000 28.5370000000000 29.7130000000000 31.0450000000000 31.8290000000000 32.9270000000000 34.1030000000000 35.3570000000000 36.5330000000000 38.1010000000000 38.2580000000000 40.4530000000000 41.4720000000000 42.8050000000000 44.2160000000000 45.3140000000000 46.3330000000000 47.5870000000000 48.4490000000000 49.5470000000000 50.7230000000000 52.1340000000000 53.7800000000000 54.7210000000000 55.5050000000000 56.7600000000000 58.4840000000000 59.2680000000000 60.2090000000000 61.4630000000000 62.6390000000000 63.8940000000000 64.7560000000000 66.6380000000000 67.8130000000000 69.0680000000000 70.0870000000000 71.4200000000000 72.2040000000000 72.9880000000000 70.0090000000000];
strain_47p=[0.00200112359676809 0.00200486893756412 0.00215901404549150 0.00186031913893677 0.00201161062169636 0.00216519582447887 0.00222476961114857 0.00214178039845723 0.00229971527049303 0.00248712856446959 0.00278713594962330 0.00297473194871410 0.00312485939257593 0.00347821184752476 0.00366944908180301 0.00368823860438942 0.00401265688347043 0.00416911434899732 0.00444039797259245 0.00473969515962151 0.00485456730769231 0.00500770832085052 0.00523722483541931 0.00543064293033316 0.00566374858636592 0.00585563277682635 0.00605117727820904 0.00620279555766258 0.00647366990474618 0.00670442498921918 0.00690030034098864 0.00725140321047931 0.00748251580763500 0.00771373469723685 0.00775370221892998 0.00798561440571400 0.00821516875019785 0.00844653507221160 0.00879207575450488 0.00895173834943639 0.00918230376920059 0.00941563554343471 0.00980520597443534 0.0101164703010587 0.0103852711546106 0.0104641110473844 0.0106589784437865 0.0108518246048758 0.0112392641700784 0.0119376732284246 0.0120937495625764 0.0124792756188192 0.0126722446689878 0.0130597439746803 0.0134084601476656 0.0139499156803155 0.0151571932358287 0.0163195710681868];
Vel_47p=[2553.92923282057 2566.19285538637 2584.42704464243 2604.10695777250 2616.47069440766 2641.95913019665 2648.35420797831 2661.77792277169 2668.00808429343 2701.25896675684 2714.18570456404 2720.59652116579 2741.15722917886 2761.47702345813 2768.11777758158 2775.27100548232 2788.89118380593 2803.12497019030 2817.18670866479 2823.81271041265 2830.99496908018 2830.56272769837 2852.66497586825 2867.48298667893 2874.56141394830 2881.79682983845 2889.06122848033 2888.62502725222 2911.57016381114 2918.89450810249 2926.36106527400 2941.53782450431 2949.02671222444 2948.34871543641 2956.43980974669 2972.30884017799 2979.97383771885 2987.67692874666 2995.08414139813 3003.08825988456 3010.92600895840 3010.22863571644 3009.06502189497 3033.98061705822 3041.88339984502 3059.21828163764 3058.62725740219 3066.90189102928 3065.72452984510 3072.50567158058 3072.03091820042 3088.80771312927 3097.26957705740 3114.33886589357 3113.26509562816 3120.80035765006 3126.32621195715 3132.03248135025];
Qinv_47p=[0.0557365047647284 0.0524435015421752 0.0599243523725024 0.0617862947002764 0.0588295561202998 0.0536823349800604 0.0506430928062968 0.0486311825903782 0.0474621714114250 0.0458941344175014 0.0372325182395481 0.0442581530404797 0.0437737106307088 0.0431168437356638 0.0429138272030633 0.0425642000072754 0.0421508398117809 0.0414561356457820 0.0409697605556926 0.0408020958488203 0.0403001908297208 0.0395395810098068 0.0393897637024908 0.0389241702761080 0.0388891282882114 0.0382370235271158 0.0376910052364056 0.0370601141757552 0.0367848036761263 0.0368855045086813 0.0361009658286865 0.0357158437968207 0.0350901879552829 0.0344924629112392 0.0340762065070711 0.0344376143413184 0.0338556275977015 0.0337410520442065 0.0329253095212181 0.0323870215491458 0.0317246175808829 0.0312469651805644 0.0313447139290243 0.0312476737045334 0.0305147594146114 0.0296858515315121 0.0296858515315121 0.0290556984428316 0.0284052824206672 0.0282455671810001 0.0282150602475117 0.0277152513933226 0.0269767112749214 0.0266612839309218 0.0261705876319496 0.0256910962801697 0.0267324868364402 0.0270846648397620];
dQinv_47p=[0.00164198283733015 0.00154554095635957 0.00176709686695903 0.00182280721707562 0.00173633984667544 0.00158573012645851 0.00149627783675484 0.00143734431605490 0.00140315554424708 0.00135823923687143 0.00110247111246228 0.00131086495049287 0.00129738186491713 0.00127887890878740 0.00127321699133235 0.00126311476182463 0.00125153086853380 0.00123149713141744 0.00121769487714783 0.00121311377867409 0.00119850167266136 0.00117595323634806 0.00117235996656828 0.00115909431556580 0.00115841068051996 0.00113932229019324 0.00112338697067984 0.00110464953625547 0.00109728996209980 0.00110064000813863 0.00107755475655473 0.00106668810464361 0.00104833554296596 0.00103057236754382 0.00101838305542797 0.00102974917306724 0.00101267134445620 0.00100956945744372 0.000985524185228441 0.000969698711687213 0.000950173897113841 0.000935953869136375 0.000939025818836500 0.000936894536590187 0.000915233399605710 0.000890824351850166 0.000890892530656952 0.000872256499087579 0.000852860624464461 0.000848501996091583 0.000847637483804730 0.000833151420945165 0.000811208926827950 0.000802238385800330 0.000787580875775121 0.000773505390075542 0.000805438918807752 0.000816623570275480];
dVel_47p=[55.2426271399744 55.5458180075936 56.0045374018885 56.4771004438412 56.7913190544159 57.4321398018687 57.5942028205064 57.9240093762138 58.0872633135469 58.9262805192583 59.2649109649408 59.4350426794954 59.9576725444821 60.4858944072309 60.6627664145718 60.8434403058753 61.2031777933685 61.5698029143080 61.9387296671651 62.1220328254484 62.3094997194440 62.3069126895088 62.8777992450870 63.2632747149082 63.4553385645981 63.6492452482561 63.8442265955382 63.8415656266704 64.4390214632790 64.6380383703846 64.8388646700883 65.2448609247047 65.4486748717715 65.4444593115709 65.6529786051928 66.0710234824425 66.2798439576035 66.4898986271532 66.6990895224128 66.9130552475012 67.1269923146294 67.1225727242511 67.1151999742066 67.7720728290927 67.9905747071386 68.4405964715021 68.4367963246509 68.6609100536090 68.6533230169336 68.8688676167091 68.8658024746282 69.3209085887218 69.5506173539745 70.0143895019713 70.0073728663646 70.2344184771084 70.4494084570604 70.6666689816084];
error_Vel_47p=100*dVel_47p./Vel_47p;
error_Qinv_47p=100*dQinv_47p./Qinv_47p;

% Shale p-wave
strain_22p=[0 0.000132476564108820 0.00135544129159750 0.00245634672368507 0.00316028379897786 0.00363117048073933 0.00400515762387202 0.00443846538268694 0.00481338556386256 0.00511703434451952 0.00542318673988565 0.00562573412739300 0.00592887884938887 0.00624116961514575 0.00645185595980555 0.00662583843598387 0.00707427213964528 0.00727441877740007 0.00758530697851848 0.00765693821405773 0.00786740872976105 0.00805097737404109 0.00825284567063353 0.00859949172038668 0.00891466989252425 0.00910860333955182 0.00928881645475357 0.00962056860322547 0.00982273171745194 0.0100327701529274 0.0104659315980653 0.0108019094512972 0.0110025352750143 0.0112688939523606 0.0114803730376029 0.0118025240758367 0.0121260559248279 0.0123378937368753 0.0129049141622138 0.0133542806363848 0.0137034024604727 0.0140678371400180 0.0143282568889441 0.0148055633947954 0.0159333726295984 0.0164123393951362 0.0165337155773846 0.0173358923606728 0.0199978231915440 0.0218488333382059];
Sigma_22p=[0.155000000000000 0.621000000000000 1.70800000000000 3.49300000000000 5.74400000000000 6.90900000000000 8.92700000000000 10.6350000000000 12.8080000000000 14.2830000000000 15.6030000000000 17.3880000000000 18.6300000000000 20.3380000000000 21.5800000000000 22.9770000000000 24.2970000000000 25.3060000000000 26.7030000000000 27.6340000000000 28.4880000000000 29.7300000000000 30.7390000000000 32.0590000000000 33.3790000000000 34.5430000000000 35.8630000000000 37.0270000000000 38.0360000000000 38.8900000000000 40.4420000000000 41.4520000000000 42.4610000000000 42.5380000000000 43.3920000000000 44.6340000000000 45.8760000000000 46.7300000000000 48.3600000000000 49.7570000000000 50.6110000000000 51.2320000000000 51.3880000000000 52.3970000000000 53.9490000000000 52.9400621600000 53.1730000000000 51.4650000000000 31.0500000000000 28.3330000000000];
Vel_22p=[2440.10396079756 2447.61344375963 2452.49767394582 2457.72002355728 2471.97003907929 2478.87195402792 2486.06006419856 2501.36384964925 2508.69678016463 2516.25746820377 2532.28995032137 2540.26196402449 2548.03294025123 2555.83357026302 2563.94630498009 2580.97245727169 2579.82319244576 2588.12913570550 2596.20689928604 2604.95914611026 2613.41182524944 2621.99330455546 2630.58691271398 2629.68280501880 2638.03751737608 2646.76924801486 2655.59866059327 2664.09060785285 2663.55726587416 2672.43037845200 2680.77468964316 2689.43803967601 2698.52520837728 2707.50185137246 2716.69096171826 2725.64861424866 2734.66812205532 2744.05663579490 2762.65009754354 2771.59650863309 2791.20433053459 2800.59355656617 2810.34187075847 2830.18133417015 2837.72826777952 2847.15587361525 2846.81591744370 2855.40819359886 2858.84771668758 2875.66383181106];
Qinv_22p=[0.0141811257481184 0.0117918507021709 0.00995570643126732 0.00903701331732133 0.00946491000559870 0.00926944280505930 0.00944807400489725 0.00946369903180017 0.00895822641668905 0.00930656789707794 0.00947804380509020 0.00913492498717259 0.00987692121377174 0.0104572581084962 0.0103087067734250 0.0105918006918612 0.0110368816792368 0.0110183847007085 0.0122560809143385 0.0122826765053879 0.0115961093113737 0.0121310933770108 0.0122450770365828 0.0119501396516723 0.0118841698914519 0.0119457682040772 0.0116625546946495 0.0112698188964684 0.0114204158141858 0.0117250002788983 0.0117028161717836 0.0112844110558762 0.0110780441011163 0.0112466048478875 0.0112498748834204 0.0115043915206189 0.0112841384233214 0.0115628598919932 0.0116578858931513 0.0118681983788332 0.0113677417846139 0.0114774100952590 0.0119946621399096 0.0116848702855408 0.0124226103139853 0.0129065650500870 0.0132970395024173 0.0149635164627834 0.0352387633531852 0.0191464174356551];
dQinv_22p=[0.000391907655659292 0.000325972399308573 0.000275399934202516 0.000250144744472652 0.000262183381859662 0.000256875300646097 0.000261925512472754 0.000262531076474870 0.000248604752334391 0.000258365331358421 0.000263289714323641 0.000253842199750254 0.000274561701286737 0.000290802205736921 0.000286768019763971 0.000294817969569921 0.000307254706622873 0.000306843522682651 0.000341440407398375 0.000342282699698267 0.000323261910881091 0.000338289906649719 0.000341586643425572 0.000333399360789980 0.000331687145481273 0.000333521770585186 0.000325726198732959 0.000314882379420730 0.000319112528183356 0.000327740026396790 0.000327262317022546 0.000315689033490345 0.000310026578510834 0.000314864059479601 0.000315070379277374 0.000322328792255924 0.000316286240422573 0.000324218279601458 0.000327142028866680 0.000333195732044486 0.000319377762333978 0.000322598123886632 0.000337270654924479 0.000328817798064219 0.000349823335227559 0.000363625840670485 0.000374642603709266 0.000421845105673525 0.000994662273606637 0.000541124038121992];
dVel_22p=[46.5376479119603 46.7092639391134 46.8687029051780 47.0307522496488 47.3768687016680 47.5502916782719 47.7261715370621 48.0857441689270 48.2654645701386 48.4474077619396 48.8192254014451 49.0065482222144 49.1939281659851 49.3825727079758 49.5739772170055 49.9644526161653 49.9583718516229 50.1542450261351 50.3500792925005 50.5506958303400 50.7509187899623 50.9530468161942 51.1564675877036 51.1515876001511 51.3549366047188 51.5615743756219 51.7700097222776 51.9778787836033 51.9749616642045 52.1861912276668 52.3958130460962 52.6084931958893 52.8248416877560 53.0419223286653 53.2615433906478 53.4812431821044 53.7026689198637 53.9275682705491 54.3805977337079 54.6072740254453 55.0748008061039 55.3084242727877 55.5456211351270 56.0266061771755 56.2555934157346 56.4970733871883 56.4950841160241 56.7332268877021 56.9426063670276 57.4243662889125];
error_Vel_22p=100*dVel_22p./Vel_22p;
error_Qinv_22p=100*dQinv_22p./Qinv_22p;


% Matlab plotting routines to plot figures 5, 6 and 7 of manuscript
figure (6)


subplot(3,2,1);
 plot(strain_004b,Sigma_004b,'-sk','MarkerSize',4);
 hold on
 plot(strain_006b,Sigma_006b,'-sk','MarkerEdgeColor',[0.5 0.5 0.5],'MarkerFaceColor',[0.5 0.5 0.5],'MarkerSize',4);
 hold on
scatter(strain_004b(14),Sigma_004b(14),'s','filled','r');
hold on
scatter(strain_006b(26),Sigma_006b(26),'s','filled','r');
hold on
xlabel('strain (-)','fontsize',10,'fontweight','n');
ylabel('Axial stress (MPa)','fontsize',10,'fontweight','n','Color','k');
axis([0 0.008 0 80])
curtick = get(gca, 'XTick');
set(gca, 'XTickLabel', cellstr(num2str(curtick(:))));
axis square 
grid on
title('P-wave')

 subplot(3,2,3)
plot(strain_004b,Vel_004b,'-sk','MarkerSize',4);
hold on
plot(strain_006b,Vel_006b,'-sk','MarkerEdgeColor',[0.5 0.5 0.5],'MarkerFaceColor',[0.5 0.5 0.5],'MarkerSize',4);
 hold on
scatter(strain_004b(14),Vel_004b(14),'s','filled','r');
hold on
scatter(strain_006b(26),Vel_006b(26),'s','filled','r');
hold on
xlabel('strain (-)','fontsize',10,'fontweight','n');
ylabel('V_p (m/s)','fontsize',10,'fontweight','n','Color','k'); 
axis([0 0.008 3300 4400])
curtick = get(gca, 'XTick');
set(gca, 'XTickLabel', cellstr(num2str(curtick(:))));
axis square 
grid on

 subplot(3,2,5)
plot(strain_004b,Qinv_004b,'-sk','MarkerSize',4);
hold on
plot(strain_006b,Qinv_006b,'-sk','MarkerEdgeColor',[0.5 0.5 0.5],'MarkerFaceColor',[0.5 0.5 0.5],'MarkerSize',4);
 hold on
scatter(strain_004b(14),Qinv_004b(14),'s','filled','r');
hold on
scatter(strain_006b(26),Qinv_006b(26),'s','filled','r');
hold on
xlabel('strain (-)','fontsize',10,'fontweight','n');
ylabel('1/Q_p (-)','fontsize',10,'fontweight','n','Color','k'); 
axis([0 0.008 0.04 0.15])
curtick = get(gca, 'XTick');
set(gca, 'XTickLabel', cellstr(num2str(curtick(:))));
grid on
axis square 

 subplot(3,2,2)
plot(strain_005b,Sigma_005b,'-sk','MarkerSize',4);
hold on
plot(strain_007b,Sigma_007b,'-sk','MarkerEdgeColor',[0.5 0.5 0.5],'MarkerFaceColor',[0.5 0.5 0.5],'MarkerSize',4);
 hold on
scatter(strain_005b(15),Sigma_005b(15),'s','filled','r');
hold on
scatter(strain_007b(24),Sigma_007b(24),'s','filled','r');
hold on
xlabel('strain (-)','fontsize',10,'fontweight','n');
ylabel('Axial stress (MPa)','fontsize',10,'fontweight','n','Color','k');
axis([0 0.008 0 80])
axis square 
curtick = get(gca, 'XTick');
set(gca, 'XTickLabel', cellstr(num2str(curtick(:))));
title('S-wave')
grid on

 subplot(3,2,4)
plot(strain_005b,Vel_005b,'-sk','MarkerSize',4);
hold on
plot(strain_007b,Vel_007b,'-sk','MarkerEdgeColor',[0.5 0.5 0.5],'MarkerFaceColor',[0.5 0.5 0.5],'MarkerSize',4);
 hold on
scatter(strain_005b(15),Vel_005b(15),'s','filled','r');
hold on
scatter(strain_007b(24),Vel_007b(24),'s','filled','r');
hold on
xlabel('strain (-)','fontsize',10,'fontweight','n');
ylabel('V_s (m/s)','fontsize',10,'fontweight','n','Color','k'); 
axis([0 0.008 2050 2400])
axis square 
curtick = get(gca, 'XTick');
set(gca, 'XTickLabel', cellstr(num2str(curtick(:))));
grid on

 subplot(3,2,6)
plot(strain_005b,Qinv_005b,'-sk','MarkerSize',4);
hold on
plot(strain_007b,Qinv_007b,'-sk','MarkerEdgeColor',[0.5 0.5 0.5],'MarkerFaceColor',[0.5 0.5 0.5],'MarkerSize',4);
 hold on
scatter(strain_005b(15),Qinv_005b(15),'^','filled','r');
hold on
scatter(strain_007b(24),Qinv_007b(24),'^','filled','r');
hold on
xlabel('strain (-)','fontsize',10,'fontweight','n');
ylabel('1/Q_s (-)','fontsize',10,'fontweight','n','Color','k'); 
axis([0 0.008 0.04 0.15])
curtick = get(gca, 'XTick');
set(gca, 'XTickLabel', cellstr(num2str(curtick(:))));
axis square 
grid on

figure (7)
 subplot(3,2,1)
plot(strain_004L,Sigma_004L,'-sk','MarkerSize',4);
hold on
scatter(strain_004L(17),Sigma_004L(17),'s','filled','r');
hold on
xlabel('strain (-)','fontsize',10,'fontweight','n');
ylabel('Axial stress (MPa)','fontsize',10,'fontweight','n','Color','k');
axis([0 0.022 0 40])
axis square 
title('P-wave')
grid on

 subplot(3,2,3)
plot(strain_004L,Vel_004L,'-sk','MarkerSize',4);
hold on
scatter(strain_004L(17),Vel_004L(17),'s','filled','r');
hold on
xlabel('strain (-)','fontsize',10,'fontweight','n');
ylabel('V_p (m/s)','fontsize',10,'fontweight','n','Color','k'); 
axis([0 0.022 4000 5000])
axis square 
grid on

 subplot(3,2,5)
plot(strain_004L,Qinv_004L,'-sk','MarkerSize',4);
hold on
scatter(strain_004L(17),Qinv_004L(17),'s','filled','r');
hold on
xlabel('strain (-)','fontsize',10,'fontweight','n');
ylabel('1/Q_p (-)','fontsize',10,'fontweight','n','Color','k'); 
axis([0 0.022 0.035 0.14])
axis square 
grid on

 subplot(3,2,2)
plot(strain_003L,Sigma_003L,'-sk','MarkerSize',4);
hold on
plot(strain_005L,Sigma_005L,'-sk','MarkerEdgeColor',[0.5 0.5 0.5],'MarkerFaceColor',[0.5 0.5 0.5],'MarkerSize',4);
hold on
scatter(strain_003L(18),Sigma_003L(18),'s','filled','r');
hold on
scatter(strain_005L(13),Sigma_005L(13),'s','filled','r');
hold on
xlabel('strain (-)','fontsize',10,'fontweight','n');
ylabel('Axial stress (MPa)','fontsize',10,'fontweight','n','Color','k');
axis([0 0.022 0 40])
title('S-wave')
axis square 
grid on

 subplot(3,2,4)
plot(strain_003L,Vel_003L,'-sk','MarkerSize',4);
hold on
plot(strain_005L,Vel_005L,'-sk','MarkerEdgeColor',[0.5 0.5 0.5],'MarkerFaceColor',[0.5 0.5 0.5],'MarkerSize',4);
xlabel('strain (-)','fontsize',10,'fontweight','n');
ylabel('V_s (m/s)','fontsize',10,'fontweight','n','Color','k'); 
hold on
scatter(strain_003L(18),Vel_003L(18),'s','filled','r');
hold on
scatter(strain_005L(13),Vel_005L(13),'s','filled','r');
hold on
axis([0 0.022 2000 2700])
axis square 
grid on

 subplot(3,2,6)
plot(strain_003L,Qinv_003L,'-sk','MarkerSize',4);
hold on
plot(strain_005L,Qinv_005L,'-sk','MarkerEdgeColor',[0.5 0.5 0.5],'MarkerFaceColor',[0.5 0.5 0.5],'MarkerSize',4);
hold on
scatter(strain_003L(18),Qinv_003L(18),'s','filled','r');
hold on
scatter(strain_005L(13),Qinv_005L(13),'s','filled','r');
hold on
xlabel('strain (-)','fontsize',10,'fontweight','n');
ylabel('1/Q_s (-)','fontsize',10,'fontweight','n','Color','k'); 
axis([0 0.022 0.035 0.14])
axis square 
grid on

figure (5)
 subplot(3,2,1)
 plot(strain_22p,Sigma_22p,'-sk','MarkerSize',4);
 hold on
 plot(strain_47p,Sigma_47p,'-sk','MarkerEdgeColor',[0.5 0.5 0.5],'MarkerFaceColor',[0.5 0.5 0.5],'MarkerSize',4);
 hold on
scatter(strain_22p(30),Sigma_22p(30),'s','filled','r');
hold on
scatter(strain_47p(44),Sigma_47p(44),'s','filled','r');
hold on
xlabel('strain (-)','fontsize',10,'fontweight','n');
ylabel('Axial stress (MPa)','fontsize',10,'fontweight','n','Color','k');
axis([0 0.023 0 80])
title('P-wave')
axis square 
grid on

 subplot(3,2,3)
 plot(strain_22p,Vel_22p,'-sk','MarkerSize',4);
 hold on
 plot(strain_47p,Vel_47p,'-sk','MarkerEdgeColor',[0.5 0.5 0.5],'MarkerFaceColor',[0.5 0.5 0.5],'MarkerSize',4);
hold on
scatter(strain_22p(30),Vel_22p(30),'s','filled','r');
hold on
scatter(strain_47p(44),Vel_47p(44),'s','filled','r');
hold on
grid on 
xlabel('strain (-)','fontsize',10,'fontweight','n');
ylabel('V_p (m/s)','fontsize',10,'fontweight','n','Color','k'); 
axis([0 0.023 2360 3200])
axis square 

 subplot(3,2,5) 
h=plot(strain_22p,Qinv_22p,'-sk','MarkerSize',4);
hold on
plot(strain_47p,Qinv_47p,'-sk','MarkerEdgeColor',[0.5 0.5 0.5],'MarkerFaceColor',[0.5 0.5 0.5],'MarkerSize',4);
hold on
scatter(strain_22p(30),Qinv_22p(30),'s','filled','r');
hold on
scatter(strain_47p(44),Qinv_47p(44),'s','filled','r');
hold on
xlabel('strain (-)','fontsize',10,'fontweight','n');
ylabel('1/Q_p (-)','fontsize',10,'fontweight','n','Color','k'); 
axis([0 0.023 0.008 0.08])
axis square 
grid on

 subplot(3,2,2)
plot(strain_22s,Sigma_22s,'-sk','MarkerSize',4);
hold on
plot(strain_29s,Sigma_29s,'-sk','MarkerEdgeColor',[0.25 0.25 0.25],'MarkerFaceColor',[0.25 0.25 0.25],'MarkerSize',4);
hold on
plot(strain_36s,Sigma_36s,'-sk','MarkerEdgeColor',[0.5 0.5 0.5],'MarkerFaceColor',[0.5 0.5 0.5],'MarkerSize',4);
hold on
plot(strain_47s,Sigma_47s,'-sk','MarkerEdgeColor',[0.75 0.75 0.75],'MarkerFaceColor',[0.75 0.75 0.75],'MarkerSize',4);
hold on
xlabel('strain (-)','fontsize',10,'fontweight','n');
ylabel('Axial stress (MPa)','fontsize',10,'fontweight','n','Color','k');
scatter(strain_36s(30),Sigma_36s(30),'s','filled','r');
hold on
scatter(strain_22s(18),Sigma_22s(18),'s','filled','r');
hold on
scatter(strain_29s(42),Sigma_29s(42),'s','filled','r');
hold on
scatter(strain_47s(14),Sigma_47s(14),'s','filled','r');
hold on
axis([0 0.025 0 70])
axis square 
title('S-wave')
grid on


subplot(3,2,4)
plot(strain_22s,Vel_22s,'-sk','MarkerSize',4);
hold on
plot(strain_29s,Vel_29s,'-sk','MarkerEdgeColor',[0.25 0.25 0.25],'MarkerFaceColor',[0.25 0.25 0.25],'MarkerSize',4);
hold on
plot(strain_36s,Vel_36s,'-sk','MarkerEdgeColor',[0.5 0.5 0.5],'MarkerFaceColor',[0.5 0.5 0.5],'MarkerSize',4);
hold on
plot(strain_47s,Vel_47s,'-sk','MarkerEdgeColor',[0.75 0.75 0.75],'MarkerFaceColor',[0.75 0.75 0.75],'MarkerSize',4);
hold on
scatter(strain_36s(30),Vel_36s(30),'s','filled','r');
hold on
scatter(strain_22s(18),Vel_22s(18),'s','filled','r');
hold on
scatter(strain_29s(42),Vel_29s(42),'s','filled','r');
hold on
scatter(strain_47s(14),Vel_47s(14),'s','filled','r');
hold on
xlabel('strain (-)','fontsize',10,'fontweight','n');
ylabel('V_s (m/s)','fontsize',10,'fontweight','n','Color','k'); 
grid on
axis([0 0.025 1500 2350])
axis square 

 subplot(3,2,6)
 plot(strain_22s,Qinv_22s,'-sk','MarkerSize',4);
 hold on
 plot(strain_29s,Qinv_29s,'-sk','MarkerEdgeColor',[0.25 0.25 0.25],'MarkerFaceColor',[0.25 0.25 0.25],'MarkerSize',4);
 hold on
 plot(strain_36s,Qinv_36s,'-sk','MarkerEdgeColor',[0.5 0.5 0.5],'MarkerFaceColor',[0.5 0.5 0.5],'MarkerSize',4);
 hold on
 plot(strain_47s,Qinv_47s,'-sk','MarkerEdgeColor',[0.75 0.75 0.75],'MarkerFaceColor',[0.75 0.75 0.75],'MarkerSize',4);
hold on
scatter(strain_36s(30),Qinv_36s(30),'s','filled','r');
hold on
scatter(strain_22s(18),Qinv_22s(18),'s','filled','r');
hold on
scatter(strain_29s(42),Qinv_29s(42),'s','filled','r');
hold on
scatter(strain_47s(14),Qinv_47s(14),'s','filled','r');
hold on
 xlabel('strain (-)','fontsize',10,'fontweight','n');
ylabel('1/Q_s (-)','fontsize',10,'fontweight','n','Color','k'); 
axis([0 0.025 0.04 0.085])
axis square 
grid on
