theory More_Functions
  imports Base_MEC
begin

  definition "popWhile P xs \<equiv> 
    WHILET (\<lambda> (wo,succs). wo = None \<and> succs\<noteq>[]) 
    (\<lambda> (wo,succs). do {
      let (w,succs) = op_list_pop_last succs; 
      let wo = (if P w then None else Some w);
      RETURN (wo, succs)
    }) (None, xs)"

  lemma popWhile_correct: "popWhile P xs\<^sub>0 \<le> SPEC (\<lambda> (wo, xs). case wo of 
    None \<Rightarrow> xs = [] \<and> (\<forall> x \<in> set xs\<^sub>0. P x)
  | Some v \<Rightarrow> \<not>P v \<and> (\<exists> xs\<^sub>1. xs\<^sub>0 = xs @ v # xs\<^sub>1 \<and> (\<forall> x \<in> set xs\<^sub>1. P x)))"
    unfolding popWhile_def
    apply(refine_vcg WHILET_rule[where 
      ?I ="(\<lambda> (wo, xs). case wo of 
        None \<Rightarrow> \<exists> xs\<^sub>1. xs\<^sub>0 = xs @ xs\<^sub>1 \<and> (\<forall> x \<in> set xs\<^sub>1. P x)
      | Some v \<Rightarrow> \<not>P v \<and> (\<exists> xs\<^sub>1. xs\<^sub>0 = xs @ v # xs\<^sub>1 \<and> (\<forall> x \<in> set xs\<^sub>1. P x)))" and 
      ?R="measure (\<lambda> (_,xs). length xs)"])
    apply simp
    
    apply simp

    apply (auto)[]
    subgoal for xs xs\<^sub>1
      apply(rule exI[where ?x="last xs # xs\<^sub>1"])
      apply simp
      done
    subgoal for xs xs\<^sub>1
      apply(rule exI[where ?x="xs\<^sub>1"])
      apply simp
      done

    apply simp
    apply (simp split: option.splits)
    done



end