require(RODBC)
require(reshape2)
require(foreach)
require(plyr)
require(lubridate)
require(MASS)
require(base)
require(polynom)
require(xtable)
require(gridExtra)
require(ggplot2)
require(stringr)
library(scales)
###import File with Total Densities (Density2)
TNumCrus <- read.csv  (file = "./R Data/Density2.csv",     header = TRUE)
Biomass  <- read.csv  (file = "./R Data/Biomass.csv",      header = TRUE)
AvgLCrus4<- read.csv  (file = "./R Data/GrowthN2.csv",      header = TRUE)
Temp     <- read.csv  (file = "./R Data/Temp.csv",         header = TRUE)
Names    <- read.csv  (file = "./R Data/Names.csv",        header = TRUE)
NumH6    <- read.csv  (file = "./Data/SpeciesCaughtY.csv", header = TRUE)
Para     <- read.table(file = "./Data/Coefficents.txt",    header = TRUE)
MP       <- read.table(file = "./Data/2014-02-05FoodItems.txt",header=TRUE,dec=".")

source("./R Scripts/FunctionsFI.R")

# CC<-subset(TNumCrus,Species==213)
# CC$Month<-month(CC$datum)
# CC$Year<-year(CC$datum)
# ggplot(CC,aes(x=LK,y=TNumCrus,group=Cruiseid))+
#   geom_line()+
#   facet_grid(Month~Year,scales="free_y")
# CM<-subset(TNumCrus,Species==200)
# CM$Month<-month(CM$datum)
# CM$Year<-year(CM$datum)
# ggplot(CM,aes(x=LK,y=TNumCrus,group=Cruiseid))+
#   geom_line()+
#   facet_grid(Month~Year,scales="free_y")

#################################################################################################
###2. Calculate Growth and Weights with Coeffients (Table Para) that were estimated before
#Plaice and Flounder changing growth with every year, all other same for all years
names(TNumCrus)
#[1] "Cruiseid" "NumStat" "datum" "Year" "Species" "Age" "Length" "LK" "TNumCr"  
#[10] "TNumCrus"
#we want to have Cruiseid,Date,Year,Species, Age, LK, Length, TNumCrus=> 1,3,4,5,6,7,9
GrowthH<-dcast(TNumCrus,Cruiseid+datum+Species+Age+LK+Length~.,
               value.var="TNumCrus",sum, na.rm=TRUE)
colnames(GrowthH)[7] <- "TNumCrus"
GrowthH2<-merge(GrowthH,Para,by=c("Species"))
Growth<-merge(GrowthH2,AvgLCrus4,by=c("Cruiseid","Species","Age"))
Growth$WW<-ifelse(Growth$ref==1,
                  (Growth$a*(Growth$Length/10))^Growth$b,
                  Growth$a*((Growth$Length/10)^Growth$b))
Growth$MetWW<-Growth$WW^0.8
Growth$Wiplus1<-Growth$WW*exp(Growth$PredGW*1)
Growth$dW<-Growth$Wiplus1-Growth$WW
Growth$FI_growth<-Growth$AssiEff*Growth$dW*Growth$TNumCrus
Growth$SumMetWW<-Growth$MetWW*Growth$TNumCrus

FIGroCrus<-ddply(Growth,c("Cruiseid","datum","Species","Age","G.a", "G.b","Q10","WW.AFDM",
                          "MaintC","AssiEff","a","b","ref"),
                 summarize, sumWW=sum(WW),sumMetWW=sum(SumMetWW),sumGW=sum(PredGW),
                 sumWiplus1=sum(Wiplus1), sumdW=sum(dW),TNumCrus=sum(TNumCrus),
                 FIGroWW=sum(FI_growth))
FIGroCrus$Year<-year(FIGroCrus$datum)

#################################################################################################
##Calculate Daily Maintanance requierment (DGR)
MainCrus<-merge(FIGroCrus,Temp,by="Cruiseid")
MainCrus$FIMainWW<-MainCrus$Q10^(0.1*MainCrus$Temp)*MainCrus$MaintC*MainCrus$sumMetWW

################################################################################################
##Get Food Intake per cruise per species per age class 
#get impotant columns
names(MainCrus)
#  [1] "Cruiseid"      "datum"         "Species"       "Age"           "G.a"           "G.b"          
# [7] "Q10"           "WW.AFDM"       "MaintC"        "AssiEff"       "a"             "b"            
# [13] "ref"           "sumWW"         "sumMetWW"      "sumGL"         "sumWiplus1"    "sumdW"        
# [19] "TNumCrus"      "FIGroWW"     "Year"          "Date_start"    "Date_end"      "Julian_start" 
# [25] "Julian_end"    "Julian_mean"   "T_Mars_cruise" "Temp_expected" "Temp_observed" "Temp"         
# [31] "FIMainWW"        
#
#we want to have "Cruiseid","datum","Species","Age",,"WW.AFDM","sumWW","sumMetWW","TNumCrus",
#"FIGroCrus","FIMainWW"
FICrus<-MainCrus[,c("Cruiseid","datum","Year","Species","Age","WW.AFDM","sumWW","sumMetWW",
                    "TNumCrus","FIGroWW","FIMainWW")]
FICrus$Day_nr<-yday(FICrus$datum)
FICrus$FIGrowAFDM<-FICrus$WW.AFDM*FICrus$FIGroWW
FICrus$FIMainAFDM<-FICrus$WW.AFDM*FICrus$FIMainWW

FICrus$TDFI<-FICrus$FIGrowAFDM+FICrus$FIMainAFDM
FICrus$FracFI<-FICrus$FIGrowAFDM/FICrus$TDFI
FICrus<-FICrus[order(FICrus$Species,FICrus$Cruiseid,FICrus$Age),]
FICrus2<-merge(FICrus,NumH6,by=c("Cruiseid","Species","Age","datum","Year"),all=TRUE)
FICrus2$Day_nr<-yday(FICrus2$datum)
FICrus2$TDFI2<-ifelse(FICrus2$TDFI %in% NA,ifelse(FICrus2$Ind==1,0,NA),FICrus2$TDFI)
FICrus2$TDFI2<-ifelse(FICrus2$Cruiseid %in% c(199701:199704)& FICrus2$Species %in% c(124,162),NA,FICrus2$TDFI2)
FICrus2<-FICrus2[!is.na(c(FICrus2$TDFI2, FICrus2$Age)),]
FICrus2$TDFI<-FICrus2$TDFI2
FICrus2<-FICrus2[,c("Cruiseid","datum","Year","Species","Age","Day_nr","TDFI")]
FICrus2$Year<-year(FICrus2$datum)
FICrus2$datum<-ymd(FICrus2$datum)


################################################################################################
#Calculation of yearly Food Intake
################################################################################################
#let all Species & Age classes run through Functions
#Plaice
Pp0<-TFoodIntake(Data=subset(FICrus2,Species==154 & Age==0))
Pp1<-TFoodIntake(Data=subset(FICrus2,Species==154 & Age==1))
Pp2<-TFoodIntake(Data=subset(FICrus2,Species==154 & Age==2))
#Flounder
Pf0<-TFoodIntake(Data=subset(FICrus2,Species==155 & Age==0))
Pf1<-TFoodIntake(Data=subset(FICrus2,Species==155 & Age==1))
Pf2<-TFoodIntake(Data=subset(FICrus2,Species==155 & Age==2))
#Sole
Ss0<-TFoodIntake(Data=subset(FICrus2,Species==158 & Age==0))
Ss1<-TFoodIntake(Data=subset(FICrus2,Species==158 & Age==1))
#Common goby
Pmic0<-TFoodIntake(Data=subset(FICrus2,Species==124 & Age==0))
Pmic1<-TFoodIntake(Data=subset(FICrus2,Species==124 & Age==1))
#Sand goby
Pmin0<-TFoodIntake(Data=subset(FICrus2,Species==162 & Age==0))
Pmin1<-TFoodIntake(Data=subset(FICrus2,Species==162 & Age==1))
#Crab
Cm<-TFoodIntake(Data=subset(FICrus2,Species==200 & Age==0))
#shrimp
Cc<-TFoodIntake(Data=subset(FICrus2,Species==213 & Age==0))

#Make table with all Species and all age classes
TFIAll<-rbind(Pp0,Pp1,Pp2,Pf0,Pf1,Pf2,Ss0,Ss1,Pmic0,Pmic1,Pmin0,Pmin1,Cm,Cc)
TFIAll$FI[TFIAll$Type %in% NA]<--99
TFIAll$FI<-round(TFIAll$FI,3)
TFIAll2<-unique(TFIAll[,c("Year","Species","Age","FI")])

TFIAll4<-merge(TFIAll2,MP,by=c("Species","Age"))
TFIAll3<-dcast(TFIAll2,Year~Species+Age)
TFIAll4$Age[TFIAll4$Age==0 & TFIAll4$Species %in% c(200,213)]<-"All ages"
TFIAll4$Age[TFIAll4$Age==0 & TFIAll4$Species %in% c(124,154,155,158,162)]<-"0-group"
TFIAll4$Age[TFIAll4$Age==1 & TFIAll4$Species %in% c(124,154,155,158,162)]<-"I-group"
TFIAll4$Age[TFIAll4$Age==2 & TFIAll4$Species %in% c(154,155)]<-"II-group"
TFIAll4$Species[TFIAll4$Species==200]<-"Carcinus maenas"
TFIAll4$Species[TFIAll4$Species==213]<-"Crangon crangon"
TFIAll4$Species[TFIAll4$Species==162]<-"Pomatoschistus minutus"
TFIAll4$Species[TFIAll4$Species==124]<-"Pomatoschistus microps"
TFIAll4$Species[TFIAll4$Species==158]<-"Solea solea"
TFIAll4$Species[TFIAll4$Species==155]<-"Platichthys flesus"
TFIAll4$Species[TFIAll4$Species==154]<-"Pleuronectes platessa"
TFIAll4$Age<-as.factor(TFIAll4$Age)
TFIAll4$Age<-factor(TFIAll4$Age,levels=c("All ages","0-group","I-group","II-group"))
TFIAll4$FI[TFIAll4$FI<0]<-NA
TFIAll4$Species<-factor(TFIAll4$Species,levels=c("Carcinus maenas","Crangon crangon",
                                                 "Pomatoschistus minutus",
                                                 "Pomatoschistus microps","Solea solea",
                                                 "Platichthys flesus",
                                                 "Pleuronectes platessa"))
TFIAll4$Month<-"Total"
TFIAll4$MFI2<-TFIAll4$FI
TFIAll4$SpeciesAge<-str_c(TFIAll4$Species,TFIAll4$Age,sep=" ")

TFIAllN<-TFIAll4[,c("Species","Age","Year","Month","MFI2","SpeciesAge","MP")]


#Monthly Food Intakes
PpM0<-MonthlyFI(Data=subset(FICrus2,Species==154 & Age==0))
PpM1<-MonthlyFI(Data=subset(FICrus2,Species==154 & Age==1))
PpM2<-MonthlyFI(Data=subset(FICrus2,Species==154 & Age==2))
#Flounder
PfM0<-MonthlyFI(Data=subset(FICrus2,Species==155 & Age==0))
PfM1<-MonthlyFI(Data=subset(FICrus2,Species==155 & Age==1))
PfM2<-MonthlyFI(Data=subset(FICrus2,Species==155 & Age==2))
#Sole
SsM0<-MonthlyFI(Data=subset(FICrus2,Species==158 & Age==0))
SsM1<-MonthlyFI(Data=subset(FICrus2,Species==158 & Age==1))
#Common goby
PmicM0<-MonthlyFI(Data=subset(FICrus2,Species==124 & Age==0))
PmicM1<-MonthlyFI(Data=subset(FICrus2,Species==124 & Age==1))
#Sand goby
PminM0<-MonthlyFI(Data=subset(FICrus2,Species==162 & Age==0))
PminM1<-MonthlyFI(Data=subset(FICrus2,Species==162 & Age==1))
#Crab
CmM<-MonthlyFI(Data=subset(FICrus2,Species==200 & Age==0))
#shrimp
CcM<-MonthlyFI(Data=subset(FICrus2,Species==213 & Age==0))

MFIAll<-rbind(PpM0,PpM1,PpM2,PfM0,PfM1,PfM2,SsM0,SsM1,PmicM0,PmicM1,PminM0,PminM1,CmM,CcM)
MFIAll$MFI2<-MFIAll$MFI/1000
MFIAll2<-merge(MFIAll,MP,by=c("Species","Age"))
MFIAll2$MFIMac<-MFIAll2$MFI2*MFIAll2$MP

MFIAll2$Age[MFIAll2$Age==0 & MFIAll2$Species %in% c(200,213)]<-"All ages"
MFIAll2$Age[MFIAll2$Age==0 & MFIAll2$Species %in% c(124,154,155,158,162)]<-"0-group"
MFIAll2$Age[MFIAll2$Age==1 & MFIAll2$Species %in% c(124,154,155,158,162)]<-"I-group"
MFIAll2$Age[MFIAll2$Age==2 & MFIAll2$Species %in% c(154,155)]<-"II-group"
MFIAll2$Species[MFIAll2$Species==200]<-"Carcinus maenas"
MFIAll2$Species[MFIAll2$Species==213]<-"Crangon crangon"
MFIAll2$Species[MFIAll2$Species==162]<-"Pomatoschistus minutus"
MFIAll2$Species[MFIAll2$Species==124]<-"Pomatoschistus microps"
MFIAll2$Species[MFIAll2$Species==158]<-"Solea solea"
MFIAll2$Species[MFIAll2$Species==155]<-"Platichthys flesus"
MFIAll2$Species[MFIAll2$Species==154]<-"Pleuronectes platessa"
MFIAll2$Age<-as.factor(MFIAll2$Age)
MFIAll2$Age<-factor(MFIAll2$Age,levels=c("All ages","0-group","I-group","II-group"))
MFIAll2$MFI2[MFIAll2$MFI2<0]<-NA
MFINA<-subset(MFIAll2,MFI2 %in% NA)
MFIAll2$Species<-factor(MFIAll2$Species,levels=c("Carcinus maenas","Crangon crangon",
                                                 "Pomatoschistus minutus",
                                                 "Pomatoschistus microps","Solea solea",
                                                 "Platichthys flesus",
                                                 "Pleuronectes platessa"))
MFIAll2$SpeciesAge<-str_c(MFIAll2$Species,MFIAll2$Age,sep=" ")
MFIAll2$Month<-month(MFIAll2$datum, label = TRUE, abbr = FALSE)
MFIAll2N<-MFIAll2[,c("Species","Age","Year","Month","MFI2","SpeciesAge","MP")]
YearM<-c(1976,1980,1981,1986,1993,1996,1997,2000,2001,2007,2009,2014)
TMFIAll2<-rbind(MFIAll2N,TFIAllN)
TMFIAll22<-subset(TMFIAll2,Year %in% YearM)

Mtable<-dcast(TMFIAll22,Species+Age+Year~Month,value.var="MFI2")

FracH2<-FICrus[,c("Species","Cruiseid","Age","Day_nr","FracFI")]

write.csv(Mtable,file="./R Data/MFI.csv",row.names=FALSE)
write.csv(TFIAll2,file="./R Data/TotalFoodIntake.csv",row.names=FALSE)
write.csv(TFIAll,file="./R Data/DailyFoodIntake.csv",row.names=FALSE)
write.csv(FracH2,file="./R Data/FracFI.csv",row.names=FALSE)
write.csv(TMFIAll22,file="./R Data/TMFI.csv",row.names=FALSE)

#####Plots####

#define theme for ggplot






