summary=fileread('summary.txt'); % read the Summary that shall be reviewed
key % read the variable 'api_key' in m-file key.m (secret key)

%% 
% this part of the code continues looping until breaking the loop manually.
% break the loop when enough prompts have been collected

% Connecting to Outlook
outlook = actxserver('Outlook.Application');
mapi=outlook.GetNamespace('mapi');
INBOX=mapi.GetDefaultFolder(6);
SelectedMailCounter=0;
SelectedMailsNumbers=[];

while true
    count = INBOX.Items.Count; % index of the most recent email
    start_index=count-30; % start 30 mails before most recent email
    end_index=count;
    for mail_number=start_index:end_index % loop over mails
        firstemail=INBOX.Items.Item(mail_number); % imports mail number 'mail_number'
        subject = firstemail.get('Subject'); % read the subject line
        emailbody = firstemail.get('Body'); % read the email body

        % Check if the address is an SMTP address or an Exchange X.500 address
        senderSMTPAddress='NONE';
        if strcmp(firstemail.get('Class'),'olMail')
            if strcmp(firstemail.SenderEmailType, 'EX') % It is an Exchange X.500 address. Get the SMTP address
                exchangeUser = firstemail.Sender.GetExchangeUser();
                if ~isempty(exchangeUser)
                    senderSMTPAddress = exchangeUser.PrimarySmtpAddress;
                else
                    senderSMTPAddress = 'SMTP address not found';
                end
            else   % It is an SMTP address
                senderSMTPAddress = firstemail.SenderEmailAddress;
            end

            if contains(lower(subject),'chat') && ~ismember(mail_number,SelectedMailsNumbers) % if the subject line contains the word 'chat' and the mail is not just identified

                % remove the email signature
                cut_off=min([strfind(emailbody,'Met vriendelijke groet');strfind(emailbody,'Verzonden vanaf')]);
                if ~isempty(cut_off)
                    emailbody = emailbody(1:cut_off);
                end

                SelectedMailsNumbers=[SelectedMailsNumbers;mail_number]; % store mail number for inclusin
                SelectedMailCounter=SelectedMailCounter+1; % add 1 to the included mail counter
                SelectedPrompts{SelectedMailCounter,1} = SelectedMailCounter; % mail number
                SelectedPrompts{SelectedMailCounter,2} = senderSMTPAddress;   % recipient address
                SelectedPrompts{SelectedMailCounter,3} = emailbody;  % mail body
                save('SelectedPrompts.mat','SelectedPrompts')

                clc
                disp('SEND AN EMAIL WITH A SUGGESTED PROMPT TO: j.c.f.dewinter@tudelft.nl')
                disp('SUBJECT: chatgpt')
                disp('BODY: your prompt')
                disp(newline)

                disp('PROMPTS RECEIVED:')
                for i=1:size(SelectedPrompts,1)
                    prompt=char(SelectedPrompts(i,3));
                    prompt=strrep(prompt,newline,' ');
                    prompt=strrep(prompt,char(13),' '); % remove returns for outputs
                    for i2=1:100
                        prompt=strrep(prompt,'  ',' '); % remove double spaces
                    end
                    if strcmp(prompt(1),' ')
                        prompt=prompt(2:end);
                    end
                    disp([num2str(i) '. ' prompt]) % only display the mail number and the mail body, not the recipient address for privacy reasons
                    disp(' ')
                end
                PromptStore{i}=prompt; % store 'formatted prompt'
                pause(0.5)
            end
        end
    end
end

%% CONNECT TO API: "Please provide the best prompt among the listed prompts"
clc % clear screen
key % read the variable 'api_key' (secret key)
import matlab.net.* matlab.net.http.* matlab.net.http.io.*
uri = URI('https://api.openai.com/v1/chat/completions');
prompt = ['These are a number of prompts that are supposed to be used by ChatGPT for judging a sample text:' newline];

for i=1:length(SelectedPrompts(:,3))
    prompt=[prompt newline 'PROMPT NUMBER ' num2str(i) ': ' PromptStore{i}];
end
prompt = [prompt newline newline 'Please provide the best prompt among the above listed prompts, which would yield me the best output to improve the quality of the text.'];
body = JSONProvider(struct('model','gpt-4-1106-preview','temperature',0,'n',1,'messages', {{struct('role', 'user','content', prompt')}}));
disp(newline)
disp('PROMPTS PROVIDED TO CHATGPT')
disp(prompt)
response = RequestMessage('post', [HeaderField('Content-Type', 'application/json') HeaderField('Authorization', api_key)], body).send(uri.EncodedURI);
disp([newline 'CHATGPT OUTPUT:'])
disp(response.Body.Data.choices.message.content)

%% CONNECT TO API: SUBMIT PROMPT OF AUDIENCE
clc % clear screen
key % read the variable 'api_key' (secret key)

disp('PROMPTS RECEIVED FROM THE AUDIENCE')
for i=1:length(PromptStore)
    disp(['PROMPT NUMBER ' num2str(i) ': ' PromptStore{i}]) % only display the mail number and the mail body, not the recipient address for privacy reasons
    disp(' ')
end
disp(' ')
prompt_no_execute = input('Which prompts shall I submit to ChatGPT?: ');
import matlab.net.* matlab.net.http.* matlab.net.http.io.*
uri = URI('https://api.openai.com/v1/chat/completions');
prompt_base = ['This is a sample text:' newline newline newline char(summary)];

prompt=[prompt_base newline PromptStore{prompt_no_execute}];

body = JSONProvider(struct('model','gpt-4-1106-preview','temperature',0,'n',1,'messages', {{struct('role', 'user','content', prompt')}})); % model 'gpt-4' was used in the workshop in August 2023
response = RequestMessage('post', [HeaderField('Content-Type', 'application/json') HeaderField('Authorization', api_key)], body).send(uri.EncodedURI);

disp([newline 'CHATGPT OUTPUT:'])
disp(response.Body.Data.choices.message.content)

%% CONNECT TO API: EXECUTE OWN CUSTOM PROMPTS
clc % clear screen
CustomPrompt='Do you think this text has been written by ChatGPT? Give me a ChatGPT generation score between 0 (not at all) to 100 (certainly used ChatGPT)';

import matlab.net.* matlab.net.http.* matlab.net.http.io.*
uri = URI('https://api.openai.com/v1/chat/completions');
prompt_base = ['This is a summary text of a research paper:' newline newline newline char(summary)];
prompt=[prompt_base newline CustomPrompt];

disp('CUSTOM PROMPT:');
disp(CustomPrompt)

body = JSONProvider(struct('model','gpt-4-1106-preview','temperature',0,'n',1,'messages', {{struct('role', 'user','content', prompt')}}));
response = RequestMessage('post', [HeaderField('Content-Type', 'application/json') HeaderField('Authorization', api_key)], body).send(uri.EncodedURI);

disp([newline 'CHATGPT OUTPUT:'])
disp(response.Body.Data.choices.message.content)
