import numpy as np
import matplotlib.pyplot as plt
import matplotlib.pyplot as mpl

mpl.rc('font', family='sans-serif')
mpl.rc('text', usetex=True)

fig, axs = plt.subplots(2,3)

# Filenames
datas = ['Fig8_E1_2D.txt', \
         'Fig8_E2_2D.txt', \
         'Fig8_E3_2D.txt', \
         'Fig8_D1_2D.txt', \
         'Fig8_D2_2D.txt', \
         'Fig8_D3_2D.txt']

figlabel = ['$(a)$', \
            '$(b)$', \
            '$(c)$', \
            '$(d)$', \
            '$(e)$', \
            '$(f)$']

phival   = [0.3246, \
            0.2841, \
            0.2675, \
            0.3229, \
            0.2813, \
            0.2661]

#my_cmap     = 'coolwarm'
#my_cmap     = 'RdYlGn'
#my_cmap     = 'turbo'
my_cmap     = 'jet'
#my_cmap     = 'viridis'
#my_fontname = "Liberation Serif"
my_fontname = "FreeSerif"
my_fontsize = 20
my_density  = 1.5
my_streamline_color = 'k'
plt.rc('font', size=18) #controls default text size
plt.rc('axes', titlesize=20) #fontsize of the title
plt.rc('axes', labelsize=20) #fontsize of the x and y labels
plt.rc('xtick', labelsize=20) #fontsize of the x tick labels
plt.rc('ytick', labelsize=20) #fontsize of the y tick labels
plt.rc('legend', fontsize=20) #fontsize of the legend

sizeX = 21
sizeY = 21

#--------------------------------------------------
Xe    = np.zeros(shape=(sizeX,sizeY))
Ye    = np.zeros(shape=(sizeX,sizeY))
Phie = np.zeros(shape=(sizeX,sizeY))

# Plot the circle
theta = np.linspace(0, 2 * np.pi, 100)
pc = 0.
radius = 10.
Cx = radius * np.cos(theta)
Cy = radius * np.sin(theta)

#--------------------------------------------------
for index in range(0,3):
    print('dataset : ',index+1)
    data = np.loadtxt(datas[index])
    for i in range (0,sizeX):
        for j in range (0,sizeY):
            Xe[i,j]    =  data[i*sizeY + j,0]
            Ye[i,j]    =  data[i*sizeY + j,1]
            if (((Xe[i,j]-pc)**2. + (Ye[i,j]-pc)**2.)**0.5 < radius):
                Phie[i,j]    = data[i*sizeY + j,2]
            else:
                Phie[i,j] = float("NaN") 

#--------------------------------------------------
    c4 = axs[0,index].pcolor(Xe-pc, Ye-pc, Phie/phival[index], cmap=my_cmap, vmin=0.0, vmax=2.0)
    axs[0,index].set_xlim(-10.0, 10.0)
    axs[0,index].set_ylim(-10.0, 10.0)
    axs[0,index].set_aspect(1.)
    axs[0,0].set_ylabel("$z/D_p$", fontname=my_fontname, fontsize=my_fontsize)
    axs[0,index].annotate(figlabel[index], xy=(0.03, 0.9), xycoords="axes fraction", fontsize=23)
    fig.colorbar(c4, ax = axs[0,index])

#--------------------------------------------------
sizeX = 351 
sizeY = 351
Xe    = np.zeros(shape=(sizeX,sizeY))
Ye    = np.zeros(shape=(sizeX,sizeY))
Phie = np.zeros(shape=(sizeX,sizeY))

# Plot the circle
theta = np.linspace(0, 2 * np.pi, 100)
pc = 11.
radius = 10.
Cx = radius * np.cos(theta)
Cy = radius * np.sin(theta)

#--------------------------------------------------
for index in range(0,3):
    print('dataset : ',index+1)
    data = np.loadtxt(datas[3+index])
    for i in range (0,sizeX):
        for j in range (0,sizeY):
            Xe[i,j]    =  data[i*sizeY + j,0]
            Ye[i,j]    =  data[i*sizeY + j,1]
            if (((Xe[i,j]-pc)**2. + (Ye[i,j]-pc)**2.)**0.5 < radius):
                Phie[i,j]    = data[i*sizeY + j,2]
            else:
                Phie[i,j] = float("NaN") 

#--------------------------------------------------
    c4 = axs[1,index].pcolor(Xe-pc, Ye-pc, Phie/phival[3+index], cmap=my_cmap, vmin=0.0, vmax=2.0)
    axs[1,index].set_xlim(-10.0, 10.0)
    axs[1,index].set_ylim(-10.0, 10.0)
    axs[1,index].set_aspect(1.)
    axs[1,0].set_ylabel("$z/D_p$", fontname=my_fontname, fontsize=my_fontsize)
    axs[1,index].set_xlabel("$x/D_p$", fontname=my_fontname, fontsize=my_fontsize)
    axs[1,index].annotate(figlabel[3+index], xy=(0.03, 0.90), xycoords="axes fraction",fontsize=23)
    fig.colorbar(c4, ax = axs[1,index])
    axs[0,index].set_xticklabels([-10,-5,0,5,10],fontname=my_fontname,fontsize=18)
    axs[1,index].set_xticklabels([-10,-5,0,5,10],fontname=my_fontname,fontsize=18)
    axs[0,index].set_yticklabels([-10,-5,0,5,10],fontname=my_fontname,fontsize=18)
    axs[1,index].set_yticklabels([-10,-5,0,5,10],fontname=my_fontname,fontsize=18)

#--------------------------------------------------
plt.show()

