import numpy as np
import matplotlib.pyplot as plt

import matplotlib.pyplot as mpl

mpl.rc('font', family='sans-serif')
mpl.rc('text', usetex=True)

fig, axs = plt.subplots(2,5)

# Filenames
# Filenames
datas = ['Fig13_S1_2D.txt', \
         'Fig13_S2_2D.txt', \
         'Fig13_S3_2D.txt', \
         'Fig13_S4_2D.txt' , \
         'Fig13_S5_2D.txt' ]

figlabel = ['$(a)$', \
            '$(b)$', \
            '$(c)$', \
            '$(d)$', \
            '$(e)$', \
            '$(f)$', \
            '$(g)$', \
            '$(h)$', \
            '$(i)$', \
            '$(j)$']

#my_cmap     = 'coolwarm'
#my_cmap     = 'RdYlGn'
#my_cmap     = 'turbo'
my_cmap     = 'jet'
#my_cmap     = 'viridis'
#my_fontname = "Liberation Serif"
my_fontname = "FreeSerif"
my_fontsize = 20
my_density  = 1.5
my_streamline_color = 'k'
plt.rc('font', size=20) #controls default text size
plt.rc('axes', titlesize=20) #fontsize of the title
plt.rc('axes', labelsize=20) #fontsize of the x and y labels
plt.rc('xtick', labelsize=20) #fontsize of the x tick labels
plt.rc('ytick', labelsize=20) #fontsize of the y tick labels
plt.rc('legend', fontsize=20) #fontsize of the legend

sizeX = 335
sizeY = 335

#--------------------------------------------------
X    = np.zeros(shape=(sizeX,sizeY))
Y    = np.zeros(shape=(sizeX,sizeY))
UfWf = np.zeros(shape=(sizeX,sizeY))
Phi = np.zeros(shape=(sizeX,sizeY))
U    = np.zeros(shape=(sizeX,sizeY))
W    = np.zeros(shape=(sizeX,sizeY))


# Plot the circle
theta = np.linspace(0, 2 * np.pi, 100)
pc = 10.5
radius = 10.
Cx = radius * np.cos(theta)
Cy = radius * np.sin(theta)


#--------------------------------------------------
# Arrow Scaling
arrow_mp = [1.7,1.0,1.0,0.8,0.3]

#--------------------------------------------------
for index in range(0,5):
    print('dataset : ',index+1)
    data = np.loadtxt(datas[index])
    for i in range (0,sizeX):
        for j in range (0,sizeY):
            X[i,j]    =  data[i*sizeY + j,0]
            Y[i,j]    =  data[i*sizeY + j,1]
            if (((X[i,j]-pc)**2. + (Y[i,j]-pc)**2.)**0.5 < radius):
                U[i,j]    =  data[i*sizeY + j,2]
                W[i,j]    =  data[i*sizeY + j,3]
                UfWf[i,j] =  data[i*sizeY + j,4]
                Phi[i,j]  =  data[i*sizeY + j,5]
            else:
                U[i,j]    = 0.0 
                W[i,j]    = 0.0 
                UfWf[i,j] = float("NaN") 
                Phi[i,j] = float("NaN") 


#--------------------------------------------------
    c4 = axs[0,index].pcolor(X-pc, Y-pc, Phi/0.25, cmap=my_cmap, vmin=0.0, vmax=2.0)
    axs[0,index].set_xlim(-10.0, 0.0)
    axs[0,index].set_ylim(-10.0, 10.0)
    axs[0,index].set_aspect(1.)
    axs[0,0].set_ylabel("$z/D_p$", fontname=my_fontname, fontsize=my_fontsize)
    axs[0,index].annotate(figlabel[index], xy=(0.03, 0.9), xycoords="axes fraction",fontsize=23)
    fig.colorbar(c4, ax = axs[0,index])


#--------------------------------------------------
    magnitude = np.sqrt(U**2 + W**2)
    lw = 2.5*magnitude / magnitude.max()
    c2 = axs[1,index].pcolor(X-pc, Y-pc, UfWf, cmap=my_cmap,vmin=0.0,vmax=np.round(np.nanmax(UfWf),3))
    c3 = axs[1,index].plot(Cx,Cy,color="black",linewidth=3)
    
    #c1 = axs[1,index].streamplot(X-pc, Y-pc, U, W, density=my_density, color=my_streamline_color, linewidth=lw)
    # 03-01-24
    #----------------------------
    skip = (slice(None, None, 10), slice(None, None, 10))
    c1 = axs[1,index].quiver(X[skip]-pc, Y[skip]-pc, U[skip], W[skip], color=my_streamline_color, units ='xy',width=0.06,headwidth=8,headaxislength=2,angles='xy',scale=0.016*arrow_mp[index])
    #----------------------------
    fig.colorbar(c2, ax = axs[1,index], ticks=[0.0,np.around(np.nanmax(UfWf)/4,3),np.around(np.nanmax(UfWf)/2,3),np.around(np.nanmax(UfWf)*3/4,3),np.around(np.nanmax(UfWf),3)])
    #fig.colorbar(c2, ax = axs[1,index], ticks=np.linspace(0.0,np.round(np.nanmax(UfWf),3),5))
    axs[1,index].set_xlim(-10.0, 0.0)
    axs[1,index].set_ylim(-10.0, 10.0)
    axs[1,index].set_aspect(1.)
    axs[1,index].set_xlabel("$x/D_p$", fontname=my_fontname, fontsize=my_fontsize)
    axs[1,0].set_ylabel("$z/D_p$", fontname=my_fontname, fontsize=my_fontsize)
    axs[1,index].annotate(figlabel[5+index], xy=(0.03, 0.9), xycoords="axes fraction",fontsize=23)
#cbar = fig.colorbar(c2, ax=axs, ticks=[0.0, 1.0])
    axs[0,index].set_xticklabels([-10,-5,0],fontname=my_fontname,fontsize=15)
    axs[1,index].set_xticklabels([-10,-5,0],fontname=my_fontname,fontsize=15)
    axs[0,index].set_yticklabels([-10,-5,0,5,10],fontname=my_fontname,fontsize=15)
    axs[1,index].set_yticklabels([-10,-5,0,5,10],fontname=my_fontname,fontsize=15)


#--------------------------------------------------
plt.show()

