%-------------------------------------------------------------------------%
% Background
% Function to get reltaions between dependent and independent nodes 
% Created by Lei, TU/e, 2017
%-------------------------------------------------------------------------%

function [IndNodes,DepNodes,freeNodes,Cdi] = relationInd(nNodes, presNodes, boundaries)

% nodes on the left, right, bottom and top boundaries
leftNodes = boundaries{1};
rightNodes = boundaries{2};
bottomNodes = boundaries{3};
topNodes = boundaries{4};

boundaryNodes = [presNodes,leftNodes(2:end),bottomNodes];

% default left and right boundary nodes, prescribed nodes as independent
IndNodes = boundaryNodes;
boundaryNodes = [boundaryNodes,rightNodes,topNodes];

% node numbers
nleft = length(leftNodes);
nright = length(rightNodes);
nbottom = length(bottomNodes);
ntop = length(topNodes);

% dependency relations (just for checking)
Depn =[];
for ileft =1:nleft
    Depn = [Depn;rightNodes(ileft),leftNodes(ileft),presNodes(2),presNodes(1)];
end

for ibottom =1:nbottom
    Depn = [Depn;topNodes(ibottom),bottomNodes(ibottom),presNodes(3),presNodes(1)];
end

% independent and dependent nodes (i and d)
for iInd =1:nNodes
    if any(iInd == boundaryNodes)
       continue
    end
    IndNodes = [IndNodes,iInd];
end

DepNodes = [rightNodes,topNodes];

% free nodes
freeNodes =[];
for ifreeNode =1:length(IndNodes)
    if any(IndNodes(ifreeNode)==presNodes)
        continue
    end
    freeNodes = [freeNodes,IndNodes(ifreeNode)];   
end

% dependency matrix Cdi
Cdi = zeros(2*length(DepNodes),2*length(IndNodes));
Cdc = [1,0;0,1];

for ileft =1:nleft
    Cdi(2*ileft-1:2*ileft,1:2) = -Cdc;
    Cdi(2*ileft-1:2*ileft,3:4) =  Cdc;
    Cdi(2*ileft-1:2*ileft,2*(ileft+2)-1:2*(ileft+2)) = Cdc;
end
    
for ibottom =1:nbottom
    ncurrent = ibottom+nleft;
    Cdi(2*ncurrent-1:2*ncurrent,1:2) = -Cdc;
    Cdi(2*ncurrent-1:2*ncurrent,5:6) =  Cdc;
    Cdi(2*ncurrent-1:2*ncurrent,2*(ncurrent+2)-1:2*(ncurrent+2)) = Cdc;   
end

end
