%-------------------------------------------------------------------------%
% Background
% Function to get mesh information, nodes, elems, prescribed nodes and 
% boundaries for RVE
% Created by Lei, TU/e, 2017
%-------------------------------------------------------------------------%

function [coords,elems,presNodes,boundaries] = readMeshMicro(meshfile)

% open file to read
fidin = fopen(meshfile,'r');

% initilaize
nStrings = 0;                 % mark the names, 1-NNODES, 2-NELEMS...
coords = [];                  % nodal coordinates
elems = [];                   % connectivity
boundaries =cell(1,4);        % boundary nodes

while ~feof(fidin)

% read one line 
tline = fgetl(fidin);
ltline = length(tline);
numtline =  str2num(tline);

  % get the names
  if isempty(numtline) && ~isempty(tline)
    % read the number of nodes      
    if ltline>=6 && strcmpi(tline(1:6),'NNODES')
       nNodes = tline(8:end);
       nNodes = str2double(nNodes);
       nStrings = nStrings+1;
    end
    
    % read the number of elements
    if ltline>=6 && strcmpi(tline(1:6),'NELEMS')
       nelems = tline(8:end);
       nelems = str2double(nelems);
       nStrings = nStrings+1;
    end
    
    % detect the prescribed nodes (LB, RB, LT)
    if ltline>=6 && strcmpi(tline(1:6),'CORNER')
       nStrings = nStrings+1;
    end
    
    % detect boundary nodes
    if ltline>=4 && strcmpi(tline(1:4),'LEFT')
       nStrings = nStrings+1;
    end
    
    if ltline>=5 && strcmpi(tline(1:5),'RIGHT')
       nStrings = nStrings+1;
    end
    
    if ltline>=6 && strcmpi(tline(1:6),'BOTTOM')
       nStrings = nStrings+1;
    end
    
    if ltline>=3 && strcmpi(tline(1:3),'TOP')
       nStrings = nStrings+1;
    end
  end
  
  % scan the data
  if ~isempty(numtline)  
    % read the nodes
    if nStrings ==1 
       coords = [coords; numtline(2:end)] ;
    end
    
    % read the elems
    if nStrings ==2
       elems = [elems; numtline(2:end)] ;
    end
    
    % read the corner nodes
    if nStrings ==3
       presNodes = numtline(1:3);
       rtNode = numtline(4);
    end
    
    % get left boundary
    if nStrings ==4
       leftNodes = [presNodes(3) numtline]; 
       boundaries{1} = leftNodes;
    end
    
    % get right boundary
    if nStrings ==5
       rightNodes = [rtNode numtline];
       boundaries{2} = rightNodes;
    end
    
    % get bottom boundary
    if nStrings ==6
       bottomNodes = numtline;
       boundaries{3} = bottomNodes;
    end
    
    % get top boundary
    if nStrings ==7
       topNodes = numtline;
       boundaries{4} = topNodes;
    end
    
  end
end

% node starts from 1
elems = elems+1;
presNodes = presNodes +1;

for ib =1:4
    boundaries{ib}(1:end) = boundaries{ib}(1:end)+1;
end
