%-------------------------------------------------------------------------%
% Background
% Function to get unit cell mesh information
% Created by Lei, TU/e, 2018
%-------------------------------------------------------------------------%

function [coords,elems,parts,presNodes,cornerNodes,boundaries] = readMesh(meshFile)

% open file to read
fidin = fopen(meshFile,'r');

% initilaize
nStrings = 0;                  % mark the names, 1-NNODES, 2-NELEMS (and PARTS)...
coords = [];                   % nodal coordinates
elems = [];                    % connectivity
parts = [];                    % parts
boundaries =cell(1,4);        % boundary nodes
iElem=0;
while ~feof(fidin)

% read one line 
tline = fgetl(fidin);
ltline = length(tline);
numtline =  str2num(tline);

  % get the names
  if isempty(numtline) && ~isempty(tline)
    % read the number of nodes      
    if ltline>=6 && strcmpi(tline(1:6),'NNODES')
       nNodes = tline(8:end);
       nNodes = str2double(nNodes);
       nStrings = nStrings+1;
    end
    
    % read the number of elements
    if ltline>=6 && strcmpi(tline(1:6),'NELEMS')
       nelems = str2double(tline(8:end));
       nStrings = nStrings+1;
    end
    
    % detect boundary nodes
    if ltline>=4 && strcmpi(tline(1:4),'LEFT')
       nStrings = nStrings+1;
    end
    
    if ltline>=5 && strcmpi(tline(1:5),'RIGHT')
       nStrings = nStrings+1;
    end
    
    if ltline>=6 && strcmpi(tline(1:6),'BOTTOM')
       nStrings = nStrings+1;
    end
    
    if ltline>=3 && strcmpi(tline(1:3),'TOP')
       nStrings = nStrings+1;
    end
    
    % detect the corner nodes (left-bottom, right-bottom, right-top, left-top)
    if ltline>=7 && strcmpi(tline(1:7),'CORNERS')
       nStrings = nStrings+1;
    end
    
  end
  
  % scan the data
  if ~isempty(numtline)  
    % read the nodes
    if nStrings ==1 
       coords = [coords; numtline(2:end)] ;
    end
    
    % read the elems
    if nStrings ==2
       iElem=iElem+1;
       elems = [elems; numtline(2:end-1)] ;
       parts = [parts; numtline(end)];
       
    end
    
    % get left boundary nodes
    if nStrings ==3
       leftNodes = numtline; 
       boundaries{1} = leftNodes;
    end
    
    % get right boundary nodes
    if nStrings ==4
       rightNodes = numtline; 
       boundaries{2} = rightNodes;
    end
    
    % get bottom boundary
    if nStrings ==5
       bottomNodes = numtline;
       boundaries{3} = bottomNodes;
    end
    
    % get top boundary
    if nStrings ==6
       topNodes = numtline;
       boundaries{4} = topNodes;
    end
    
    % read the corner and prescribed nodes
    if nStrings ==7
       cornerNodes = numtline;
       presNodes   = numtline([1 2 4]); % LB, RB, LT corner nodes are prescribed---------------modified by Lei, 2022
    end

  end
end

% Remove repeated corner nodes from boundary nodes----------------added by
% Lei, 2022
nBs = 4;

for iB = 1:nBs
    boundaries{iB} = setdiff(boundaries{iB}, cornerNodes);
    
    switch iB
        case 1
        boundaries{iB} = [cornerNodes(4) boundaries{iB}];  % Add LT corner node to the left boundary nodes, just a choice
       
        case 2
        boundaries{iB}  =  [cornerNodes(3) boundaries{iB}];  % Add RT corner node to the right boundary nodes

    end

end


fclose(fidin);



end