function matrixNodes = plotMesh(coords,elems,parts)
% function plots the mesh and colors the parts (currently limited by 3
% cases) accordingly.
% input:
%   coords (2 x n): nodal coordinates of n nodes.
%   elems  (m x l): l elements containing m nodes
%   parts  (1 x l): part index corresponding to each subsequent element
% 
% output:
%   function outputs the indices of the nodes within the matrix (if not
%   relevant, one can suppres the output in the main code using the
%   semicolon (;).
% 
% Function created by L. Liu and S.A. Verhoeven, TU/e, 2022

figure
SizeM = [5 5 10 10];
set(gcf,'Units','centimeters','Position',SizeM);

hold on

nElems = length(elems);
matrixNodes = zeros(length(coords),1);   % mark the matrix nodes

% plot the mesh
for iElem =1:nElems
     elemNodes = elems(iElem,:);
     nodeZone = [elemNodes elemNodes(1)];
     
     % identify the part
     switch parts(iElem)
%          case 1
%             Col = [ 78 110 241]./255;
%             matrixNodes(nodeZone) = 1;
%          case 2
%          	Col = [109 184 115]./255;  
%          case 3
%          	Col = [218  32  36]./255;

        case 2
            Col = [ 78 110 241]./255; %blue - matrix
         case 1
         	Col = [109 184 115]./255;  %green -hard
         case 3
         	Col = 'green';   %soft
         case 4
         	Col = [218  32  36]./255;   %red - core
     end
     
     fill(coords(nodeZone,1),coords(nodeZone,2),Col,'edgecolor','k');
     
end

axis equal
axis tight

end