%-------------------------------------------------------------------------%
% Background
% Function to get constitutive relation (2D)
% Created by Lei, TU/e, 2017
%-------------------------------------------------------------------------%

function Co = planeModel(Kc,Gc,Model)

% initialize
Co = zeros(3,3);

if strcmpi(Model,'Planestrain')
   Co(1,1) = Kc + 4/3*Gc;
   Co(1,2) = Kc - 2/3*Gc;
   Co(2,1) = Co(1,2);
   Co(2,2) = Co(1,1);
   Co(3,3) = Gc;
    
else if strcmpi(Model,'Planestress')
     mu = (3*Kc-2*Gc)/(2*Gc+6*Kc);
     E = Kc*3*(1-2*mu);
     Co(1,1) = E/(1-mu^2);
     Co(1,2) = Co(1,1)*mu;
     Co(2,1) = Co(1,2);
     Co(2,2) = Co(1,1);
     Co(3,3) = E/2/(1+mu);
        
    end
end