%-------------------------------------------------------------------------%
% Function to compute impedance tensor components for general enriched
% continuum
% Created by X.Kuci, TU/e, 2024
%---------------------------------------------------------------------------
function Z_tensor = get_Z_tensor_UC(HM,W,f,n,DirWave)
 
omega = f*2*pi;
 
e_x = [1;0];
e_y = [0;1];
 
 
% \bar(\rho)
rho_M = HM.rhoM; %HM.rhoM(1,1);
 
 
rOmega = HM.Omega*2*pi;          % resonant frequency
 
% compute the dynamic density
rhoE = zeros(2,2);                      
    for s =1:length(rOmega)  
        
        J = [HM.jh(s,1)*HM.jh(s,1) HM.jh(s,1)*HM.jh(s,2);...
             HM.jh(s,2)*HM.jh(s,1) HM.jh(s,2)*HM.jh(s,2) ]/W/W;
          
        rhoE = rhoE + (omega^2 / (rOmega(s)^2 - omega^2))*J;
    end
rhoD = rho_M + rhoE; %rho_M*eye(2)+ rhoE;            % dynamic density
 

% Compute C_theta
Ct = zeros(2,2);

for Nrow =1:4
    
    % determine i
    i = 1*(Nrow == 1 || Nrow ==3) + 2*(Nrow == 2 || Nrow ==4);
    
    % determine j
    j = 2*(Nrow == 2 || Nrow ==3) + 1*(Nrow == 1 || Nrow ==4);
    
    for Ncol = 1:4
        % determine k
        kr = 2*(Ncol == 2 || Ncol == 3) + 1*((Ncol == 1 || Ncol == 4));
        
        % determine l
        l = 1*(Ncol == 1 || Ncol == 3) + 2*(Ncol == 2 || Ncol == 4);
        
        Ct(j,kr) = DirWave(i)*HM.CMO_LC(Nrow,Ncol)* DirWave(l) + Ct(j,kr);
        
    end
end
Ct_LC = Ct;

%e_theta p directions:
e_t = DirWave;


% Solve eigenvalue problem to get k_p and e_{\theta p}
[e_p, eigvals] = eig(rhoD*omega^2, Ct_LC); % Get eigenvectors and eigenvalues

k_p = sqrt(diag(eigvals));
v_1 = e_p(:,1)/norm(e_p(:,1));
v_2 = e_p(:,2)/norm(e_p(:,2));

% n = e_x;
C_nt = zeros(2,2);
% C_nt2 = zeros(2,2); 
for Nrow =1:4
    % determine i
    i = 1*(Nrow == 1 || Nrow ==3) + 2*(Nrow == 2 || Nrow ==4);
    
    % determine j
    j = 2*(Nrow == 2 || Nrow ==3) + 1*(Nrow == 1 || Nrow ==4);
    
    for Ncol = 1:4
        % determine k
        kr = 2*(Ncol == 2 || Ncol == 3) + 1*((Ncol == 1 || Ncol == 4));
        
        % determine l
        l = 1*(Ncol == 1 || Ncol == 3) + 2*(Ncol == 2 || Ncol == 4);
        
        C_nt(j,kr) = n(i)* HM.CMO_LC(Nrow,Ncol)* e_t(l) + C_nt(j,kr);   

%         
    end
end
C_nt = C_nt;
% C_nt2 = C_nt2;

Z_tensor =  (k_p(1)/omega)*C_nt*(v_1*v_1') +  (k_p(2)/omega)*C_nt*(v_2*v_2');

end % function