function [Ct] = get_Ct(C,e_theta)

if isequal(size(C),[3,3])
    % Convert isotropic to transverse isotropic
    CMO = [[C,[0;0;C(3,3)]];[0,0,C(3,3),C(3,3)]];
elseif isequal(size(C),[4,4])
    CMO = C;
else
    error('Dimensions of C are not converted');
end

% Compute C_theta
DirWave = e_theta; %[0,1];
Ct = zeros(2,2);


for Nrow =1:4
    
    % determine i
    i = 1*(Nrow == 1 || Nrow ==3) + 2*(Nrow == 2 || Nrow ==4);
    
    % determine j
    j = 2*(Nrow == 2 || Nrow ==3) + 1*(Nrow == 1 || Nrow ==4);
    
    for Ncol = 1:4
        % determine k
        kr = 2*(Ncol == 2 || Ncol == 3) + 1*((Ncol == 1 || Ncol == 4));
        
        % determine l
        l = 1*(Ncol == 1 || Ncol == 3) + 2*(Ncol == 2 || Ncol == 4);
        
        Ct(j,kr) = DirWave(i)*CMO(Nrow,Ncol)* DirWave(l) + Ct(j,kr);
        
    end
end

end % function