function [B_0, B_ell] = get_B(HM,W,f,k0,theta0,ell,n)
% get_B - Computes the B_0 (\vec{\ell_r}=\vec{0} fro r-layer) and B_ell (\vec{\ell_r}=\vec{\ell} for r-layer) matrices for an enriched layer
% Created by X.Kuci, TU/e, 2024

omega = f*2*pi;
 
e_x = [1;0];
e_y = [0;1];
 
% Compute \mathbf{C}_{xx} = \vec{e}_x \cdot (\mathbb{c}^{(4)})^{LT} \cdot
% \vec{e}_x ... Similar C_xy, C_yx, C_yy
C_xx = zeros(2,2);
C_xy = zeros(2,2);
C_yx = zeros(2,2);
C_yy = zeros(2,2);
 
for Nrow =1:4
    
    % determine i
    i = 1*(Nrow == 1 || Nrow ==3) + 2*(Nrow == 2 || Nrow ==4);
    
    % determine j
    j = 2*(Nrow == 2 || Nrow ==3) + 1*(Nrow == 1 || Nrow ==4);
    
    for Ncol = 1:4
        % determine k
        kr = 2*(Ncol == 2 || Ncol == 3) + 1*((Ncol == 1 || Ncol == 4));
        
        % determine l
        l = 1*(Ncol == 1 || Ncol == 3) + 2*(Ncol == 2 || Ncol == 4);
        
        C_xx(j,kr) = e_x(i)* HM.CMO_LC(Nrow,Ncol)* e_x(l) + C_xx(j,kr); 
        C_xy(j,kr) = e_x(i)* HM.CMO_LC(Nrow,Ncol)* e_y(l) + C_xy(j,kr);  
        C_yx(j,kr) = e_y(i)* HM.CMO_LC(Nrow,Ncol)* e_x(l) + C_yx(j,kr); 
        C_yy(j,kr) = e_y(i)* HM.CMO_LC(Nrow,Ncol)* e_y(l) + C_yy(j,kr);   
    end
end

 
% From Snell's law:
k0_y = k0*sin(theta0);
 
% \bar(\rho)
rho_M = HM.rhoM; %HM.rhoM(1,1);
 
%Volume
V = W*W;
 
rOmega = HM.Omega*2*pi;          % resonant frequency
 
% compute the dynamic density
rhoE = zeros(2,2);                      
    for s =1:length(rOmega)  
        
        J = [HM.jh(s,1)*HM.jh(s,1) HM.jh(s,1)*HM.jh(s,2);...
             HM.jh(s,2)*HM.jh(s,1) HM.jh(s,2)*HM.jh(s,2) ]/W/W;
          
        rhoE = rhoE + (omega^2 / (rOmega(s)^2 - omega^2))*J;
    end
rhoD = rho_M + rhoE; %rho_M*eye(2)+ rhoE;            % dynamic density
 
% Construct matrices for quadratic problem: Q(lambda) = lambda^2 *M +
% lambda*C +K
 M = C_xx;
 C = k0_y * (C_yx + C_xy);
 K = k0_y^2 * C_yy - rhoD*omega^2;
 
n1 = size(M, 1);
 
% Construct the block matrix for first companion linearization
I = eye(n1);
zero_block = zeros(n1);
%L1
A = [zero_block, I; -K, -C];
B = [I, zero_block; zero_block, M];
% %L2
% A = [-K, zero_block; zero_block, I];
% B = [C, M; I, zero_block];

 
% Compute the eigenvalues of the matrix pencil (A,B)so
[eigenvectors, eigenvalues_matrix] = eig(A,B);
 
 
% Solve L(lambda)z=0 for lambda and z=[x,lambda*x]T. Then take the first n
% component of z as the eigenvector of x of the original quadratic
% Q(lambda)
 
eigenvalues = diag(eigenvalues_matrix);

positive_imag_indices = find(imag(eigenvalues) > 0);
positive_real_indices = find(imag(eigenvalues) == 0 & real(eigenvalues) > 0);
positive_indices = [positive_real_indices; positive_imag_indices];
k_px_f = eigenvalues(positive_indices);
 
negative_real_indices = find(imag(eigenvalues) == 0 & real(eigenvalues) < 0);
negative_imag_indices = find(imag(eigenvalues) < 0);
negative_indices = [negative_real_indices; negative_imag_indices];
k_px_b = eigenvalues(negative_indices);


k_p_f = [sqrt(k_px_f(1)^2+k0_y^2);sqrt(k_px_f(2)^2+k0_y^2)];
k_p_b = [sqrt(k_px_b(1)^2+k0_y^2);sqrt(k_px_b(2)^2+k0_y^2)];
 
%% Filter and keep appropriate eigenvectors 
 
% Extract first n rows (actual displacements) from eigenvectors
first_half_eigenvectors = eigenvectors(1:2, :);

% Initialize matrices to store the selected parts for k_p_f and k_p_b
e_pf = zeros(2, length(positive_indices));
e_pb = zeros(2, length(negative_indices));
 
% Filter and store parts for k_p_f
for i = 1:length(positive_indices)
    % Extract parts of the current eigenvector
    part1 = eigenvectors(1:2, positive_indices(i));
    part2 = eigenvectors(3:4, positive_indices(i));
    
    % Select the corresponding k_p vector
    k_p = k_p_f(i);
    
    % Normalize parts
    part1_norm = part1;
    part2_norm = part2;
    
    % Determine collinearity in the same direction for one part
    if dot(part1_norm, [k_px_f(i); k0_y]) > 0
        e_pf(:, i) = part1;
    elseif dot(part2_norm, [k_px_f(i); k0_y] ) > 0
        e_pf(:, i) = part2;
    else
        % Check if the cross product is positive counterclockwise for the other part
        if det([part1_norm'; [k_px_f(i); k0_y]']) > 0
            e_pf(:, i) = part1;
        else
            e_pf(:, i) = part2;
        end
    end
end
 
% Filter and store parts for k_p_b
for i = 1:length(negative_indices)
    % Extract parts of the current eigenvector
    part1 = eigenvectors(1:2, negative_indices(i));
    part2 = eigenvectors(3:4, negative_indices(i));
    
    % Select the corresponding k_p vector
    k_p = k_p_b(i);
    
    % Normalize parts
    part1_norm = part1;
    part2_norm = part2;
    
    % Determine collinearity in the same direction for one part
    if dot(part1_norm, [k_px_b(i); k0_y]) > 0
        e_pb(:, i) = part1;
    elseif dot(part2_norm, [k_px_b(i); k0_y]) > 0
        e_pb(:, i) = part2;
    else
        % Check if the cross product is positive counterclockwise for the other part
        if det([part1_norm'; [k_px_b(i); k0_y]']) > 0
            e_pb(:, i) = part1;
        else
            e_pb(:, i) = part2;
        end
    end
end
 
 
e_pf;
e_pb;
%  
e_1f = (e_pf(:,1));
e_2f = (e_pf(:,2));
e_1b = (e_pb(:,1));
e_2b = (e_pb(:,2));
 
% Calculate \vec{n}\cdot \mathbb{C}^{(4)LT} \cdot \vec{e}_{\theta p}
 
e_t1f = [k_px_f(1);k0_y]./k_p_f(1); 
e_t2f = [k_px_f(2);k0_y]./k_p_f(2); 
e_t1b = [k_px_b(1);k0_y]./k_p_b(1); 
e_t2b = [k_px_b(2);k0_y]./k_p_b(2); 

% theta_1f = (atan(k0_y/k_px_f(1)))*(180/pi)
% theta_2f = (atan(k0_y/k_px_f(2)))*(180/pi)
% theta_1b = (atan(k0_y/k_px_b(1)))*(180/pi)
% theta_2b = (atan(k0_y/k_px_b(2)))*(180/pi)
 
C_t1f = zeros(2,2);
C_t2f = zeros(2,2);
C_t1b = zeros(2,2);
C_t2b = zeros(2,2);
 
for Nrow =1:4
    
    % determine i
    i = 1*(Nrow == 1 || Nrow ==3) + 2*(Nrow == 2 || Nrow ==4);
    
    % determine j
    j = 2*(Nrow == 2 || Nrow ==3) + 1*(Nrow == 1 || Nrow ==4);
    
    for Ncol = 1:4
        % determine k
        kr = 2*(Ncol == 2 || Ncol == 3) + 1*((Ncol == 1 || Ncol == 4));
        
        % determine l
        l = 1*(Ncol == 1 || Ncol == 3) + 2*(Ncol == 2 || Ncol == 4);
        
        C_t1f(j,kr) = e_t1f(i)* HM.CMO_LC(Nrow,Ncol)* e_t1f(l) + C_t1f(j,kr); 
        C_t2f(j,kr) = e_t2f(i)* HM.CMO_LC(Nrow,Ncol)* e_t2f(l) + C_t2f(j,kr); 
        C_t1b(j,kr) = e_t1b(i)* HM.CMO_LC(Nrow,Ncol)* e_t1b(l) + C_t1b(j,kr); 
        C_t2b(j,kr) = e_t2b(i)* HM.CMO_LC(Nrow,Ncol)* e_t2b(l) + C_t2b(j,kr); 
  
    end
end
C_t1f = C_t1f;
C_t2f = C_t2f;
C_t1b = C_t1b;
C_t2b = C_t2b;
 
C_xx11 = e_1f'*C_t1f*e_1f;
C_xx12 = e_2f'*C_t2f*e_2f;
C_xx21 = e_1b'*C_t1b*e_1b;
C_xx22 = e_2b'*C_t2b*e_2b;
 
v_1f = e_1f/norm(e_1f); 
v_2f = e_2f/norm(e_2f);
v_1b = e_1b/norm(e_1b);
v_2b = e_2b/norm(e_2b); 


C_nt1f = zeros(2,2);
C_nt2f = zeros(2,2); 
C_nt1b = zeros(2,2); 
C_nt2b = zeros(2,2); 
for Nrow =1:4
    % determine i
    i = 1*(Nrow == 1 || Nrow ==3) + 2*(Nrow == 2 || Nrow ==4);
    
    % determine j
    j = 2*(Nrow == 2 || Nrow ==3) + 1*(Nrow == 1 || Nrow ==4);
    
    for Ncol = 1:4
        % determine k
        kr = 2*(Ncol == 2 || Ncol == 3) + 1*((Ncol == 1 || Ncol == 4));
        
        % determine l
        l = 1*(Ncol == 1 || Ncol == 3) + 2*(Ncol == 2 || Ncol == 4);
        
        C_nt1f(j,kr) = n(i)* HM.CMO_LC(Nrow,Ncol)* e_t1f(l) + C_nt1f(j,kr);   
        C_nt2f(j,kr) = n(i)* HM.CMO_LC(Nrow,Ncol)* e_t2f(l) + C_nt2f(j,kr); 
        C_nt1b(j,kr) = n(i)* HM.CMO_LC(Nrow,Ncol)* e_t1b(l) + C_nt1b(j,kr); 
        C_nt2b(j,kr) = n(i)* HM.CMO_LC(Nrow,Ncol)* e_t2b(l) + C_nt2b(j,kr); 
    end
end
C_nt1f = C_nt1f;
C_nt2f = C_nt2f;
C_nt1b = C_nt1b;
C_nt2b = C_nt2b;


Z_tensor = (k_p_f(1)/omega)*C_nt1f*(v_1f*v_1f') + (k_p_f(1)/omega)*C_nt2f*(v_2f*v_2f') + (k_p_b(1)/omega)*C_nt1b*(v_1b*v_1b') + (k_p_b(1)/omega)*C_nt2b*(v_2b*v_2b');
B_0 = [v_1f*v_1f' + v_2f*v_2f', v_1b*v_1b' + v_2b*v_2b'; (1i*k_p_f(1))*C_nt1f*(v_1f*v_1f') + (1i*k_p_f(2))*C_nt2f*(v_2f*v_2f'),(1i*k_p_b(1))*C_nt1b*(v_1b*v_1b') + (1i*k_p_b(2))*C_nt2b*(v_2b*v_2b')];
B_ell = [(v_1f*v_1f')*exp(1i*(k_px_f(1)*ell)) + (v_2f*v_2f')*exp(1i*(k_px_f(2)*ell)), (v_1b*v_1b')*exp(1i*(k_px_b(1)*ell)) + (v_2b*v_2b')*exp(1i*(k_px_b(2)*ell)); (1i*k_p_f(1))*C_nt1f*(v_1f*v_1f')*exp(1i*(k_px_f(1)*ell)) +  (1i*k_p_f(2))*C_nt2f*(v_2f*v_2f')*exp(1i*(k_px_f(2)*ell)),(1i*k_p_b(1))*C_nt1b*(v_1b*v_1b')*exp(1i*(k_px_b(1)*ell)) + (1i*k_p_b(2))*C_nt2b*(v_2b*v_2b')*exp(1i*(k_px_b(2)*ell))];


end % function