%-------------------------------------------------------------------------%
% Function to compute dispersion curves and dynamic effective properties
% kome-ga form
% X. Kuci, TU/e, 2024
%-------------------------------------------------------------------------%
function [NormkH, FreqH, DynParas,CS,CS_LC,DS,rhoS,Polarization,V_modes_all] = getDisperHomK(HM,nk,nOmega,nMode,dirWave,W,computeDispersion)

%% G-X
kmax = pi / W; %2*pi / (W*sqrt(2));
% ky = 1*ones(1,nk);
% kx = linspace(0*kmax,1*kmax,nk);                       % wave number  
% k = sqrt(kx.^2 + ky.^2);

k = linspace(0*kmax, 1*kmax, nk);
NormkH = linspace(0,1,nk); 

%%
eW = dirWave(1);                                    % in-plane wave direction
eC = 1;                                             % out-of-plane basis
V = W*W;

% constant terms
resOmega = HM.Omega;

[DynParas,CS,CS_LC,DS,rhoS] = getDynParas(resOmega,nOmega,HM.jh,HM.H,dirWave,HM.CMO,HM.CMO_LC,HM.DMO,HM.rhoM);

Kk = zeros(2+length(resOmega));
Mk = eye(2+length(resOmega));
Freq = zeros(nMode,nk);
Omega= Freq;

% get relevant component from H
% compute Hw
Hh = zeros(size(HM.jh));
Hh_T = zeros(size(HM.jh));  % k*H^T, H can be asymmetric!!!!!!
for io = 1:length(resOmega)
    Hh(io,1) = dirWave(1) * HM.H{io}(1,1) + dirWave(2) * HM.H{io}(1,2);
    Hh(io,2) = dirWave(1) * HM.H{io}(2,1) + dirWave(2) * HM.H{io}(2,2);
    %----------------------------------------------------------------------%
    Hh_T(io,1) = dirWave(1) * HM.H{io}(1,1) + dirWave(2) * HM.H{io}(2,1);
    Hh_T(io,2) = dirWave(1) * HM.H{io}(1,2) + dirWave(2) * HM.H{io}(2,2);     
end

Polarization = zeros(nMode, nk);
V_modes_all = cell(nk, nMode); % Initialize to store all modes for each k point

if computeDispersion
for iK = 1:nk      
    % fill in the matrix Kk
    Kk(1:2,1:2) = [k(iK)^2*CS_LC];
    
    Kk(3:end,3:end) = diag((2*pi*resOmega).^2);                             % angular frequency
    
    
    % fill in the matrix Mk
    Mk(1:2,1:2) = [rhoS*eye(2)];
    
    for io =1:length(resOmega)
          Mk(1:2,2+io) = (HM.jh(io,:))'/V;
          Mk(2+io,1:2) = (HM.jh(io,:));
    end
    Mk(3:end,3:end) = eye(length(resOmega));
 
  
    % solve the eigenvalue problem
    [V_modes, Omega2] = eigs(Kk,Mk,nMode,'sm');

    % Get the unsorted eigenvalues
    Omega_unsorted = sqrt(abs(diag(Omega2)));

    % Sort the eigenvalues and get the indices of sorting
    [Omega_sorted, sortIdx] = sort(Omega_unsorted);

    % Sort the eigenvectors accordingly
    V_modes_sorted = V_modes(:, sortIdx);

    % Store the sorted results
    Omega(:, iK) = Omega_sorted;
    Freq(:, iK) = Omega_sorted ./ (2 * pi);  % Convert to Hz
    
    % Compute polarization for each mode
    for mode = 1:nMode
        u = V_modes_sorted(1:2, mode);  % Displacement components [u1, u2]
       
        % Normalize the displacement vector u
        u_norm = u;
        
        dirWave_vec = dirWave;
        
        % Compute the projection of u onto dirWave_norm (similar to us_dot_ek)
        u_dot_dirWave = dot(conj(u_norm), dirWave_vec);
        
        % Calculate the polarization index
        Polarization(mode, iK) = abs(u_dot_dirWave)/(norm(u)*norm(dirWave_vec)); 
        V_modes_all{iK, mode} = V_modes(1:2, mode);
    end
    
    % show process
    pcenK = (iK-1)/(nk-1)*100;
    
    if rem(pcenK,1) == 0
    pcomp = fix(pcenK);
    fprintf('omega(k) Homogenization-based Dispersion Analysis: %d%% completed \n ',pcomp)
    end
    
end
end
    
    FreqH = Freq;

  

end
