%-------------------------------------------------------------------------%
% Background
% Function to get effective tangent stiffness and inertial coupling
% Created by Lei, TU/e, 2017
%-------------------------------------------------------------------------%

function [CMO,CMO_LC,DMO,presCoords]= getCD(coords,presNodes,coordsRef,Kqs,Mqs)

presCoords = coords(presNodes,:);
presCoords(:,1) = presCoords(:,1) - coordsRef(:,1);
presCoords(:,2) = presCoords(:,2) - coordsRef(:,2);
presNode = length(presNodes);

% standard form CM[ijkl], DM[ijkl] [4*4]
CMO = zeros(4,4);
CMO_LC = zeros(4,4);
DMO = zeros(4,4);

for Nrow =1:4
    
    % determine i
    i = 1*(Nrow == 1 || Nrow ==3) + 2*(Nrow == 2 || Nrow ==4);
    
    % determine j
    j = 2*(Nrow == 2 || Nrow ==3) + 1*(Nrow == 1 || Nrow ==4);
    
    for Ncol = 1:4
        
        % determine k
        k = 2*(Ncol == 2 || Ncol == 3) + 1*((Ncol == 1 || Ncol == 4));
        
        % determine l
        l = 1*(Ncol == 1 || Ncol == 3) + 2*(Ncol == 2 || Ncol == 4);
       
        % assemble
        for npw = 1:presNode
            for npv = 1:presNode % i don't understand indexing, SV
                km = Kqs((2*npw-1):2*npw,(2*npv-1):2*npv); % (2.49a)?
                CMO(Nrow,Ncol) = CMO(Nrow,Ncol) + presCoords(npw,j)*km(i,k)*presCoords(npv,l);
                CMO_LC(Nrow,Ncol) = CMO_LC(Nrow,Ncol) + presCoords(npw,i)*km(j,k)*presCoords(npv,l);
                
                mm = Mqs((2*npw-1):2*npw,(2*npv-1):2*npv);
                DMO(Nrow,Ncol) = DMO(Nrow,Ncol) + presCoords(npw,j)*mm(i,k)*presCoords(npv,l);
                
            end
        end
        
    end     
        
end

end