%-------------------------------------------------------------------------%
% Background
% Compute the elementwise area (2D only) of the discretised geometry
% Able to distinct between different parts of the geometry (e.g. core,
% coating or matrix)
% 2D
% Created by S.A. Verhoeven, TU/e, 2022
%-------------------------------------------------------------------------%

function A = elemArea(coords,elems,varargin)
if mod(nargin,2)~=0 || nargin>4
    error('wrong number of input arguments')
end
A = 0;
if nargin>2
    parts = varargin{1};
    sParts = varargin{2};
else
    parts = ones(length(elems));
    sParts = [1,2,3];
end

s = ismember(parts,sParts); % selector

for i = 1:length(elems(s))
    coordsElem = coords(elems(i,:),:);
    if length(coordsElem) == 3 % triangular
        fprintf('triangular\n')
        [~,Lidx] = min(coordsElem(:,1)); % Left
        [~,Ridx] = max(coordsElem(:,1)); % Right
        [~,Bidx] = min(coordsElem(:,2)); % Bottom
        [~,Tidx] = max(coordsElem(:,2)); % Top

        if ( (Tidx == Ridx) && (Tidx ~= Lidx) ) || ( (Tidx == Lidx) && (Tidx ~= Ridx) )
            Cidx = Tidx;
        elseif ( (Bidx == Ridx) && (Bidx ~= Lidx) ) || ( (Bidx == Lidx) && (Bidx ~= Ridx) )
            Cidx = Bidx;
        else
            error('incorrectly selected triangular element')
        end

        Lc = coordsElem(Lidx,:);
        Rc = coordsElem(Ridx,:);
        Cc = coordsElem(Cidx,:);

        B  = sqrt( ( Rc(1) - Lc(1) )^2 + ( Rc(2) - Lc(2) )^2 );
        theta = atan( (Rc(2)-Lc(2)) / (Rc(1)-Lc(1)) );
        h1 = abs( Cc(2)-Lc(2) ) * cos(theta);

        A  = A + (h1*B + h2*B)/2;

    elseif length(coordsElem) == 4 % quadrilaterial
        coordsElem = coords(elems(i,:),:);
        [~,Lidx] = min(coordsElem(:,1)); % Left
        [~,Ridx] = max(coordsElem(:,1)); % Right
        [~,Bidx] = min(coordsElem(:,2)); % Bottom
        [~,Tidx] = max(coordsElem(:,2)); % Top

        Lc = coordsElem(Lidx,:);
        Rc = coordsElem(Ridx,:);
        Bc = coordsElem(Bidx,:);
        Tc = coordsElem(Tidx,:);

        % Area computed by: https://www.archtoolbox.com/calculating-area/
        % Section: Area of a Quadrilateral
        B  = sqrt( ( Rc(1) - Lc(1) )^2 + ( Rc(2) - Lc(2) )^2 );
        theta = atan( (Rc(2)-Lc(2)) / (Rc(1)-Lc(1)) );
        h1 = ( Tc(2)-Lc(2) ) * cos(theta);
        h2 = ( Lc(2)-Bc(2) ) / cos(theta);

        A  = A + (h1+h2)*B/2;

    else
        error('wrong element type detected')
    end
end    

end