%-------------------------------------------------------------------------%
% Background
% Function to get system stiffness matrix and mass matrix
% Created by Lei, TU/e, 2017
%-------------------------------------------------------------------------%

function [Ksp,Msp] = assembleKeMe(coords,elems,parts,matProp,elemProp,nElems,order)

% define sparse assembly vectors
nElemDofs = 2*elemProp.nNodes;
rowV = zeros(nElemDofs^2,nElems);
colV = zeros(nElemDofs^2,nElems);

KV = zeros(nElemDofs^2,nElems);
MV = zeros(nElemDofs^2,nElems);

MM = 0;
% assemble
for iElem =1:nElems
    
    elemNode = elems(iElem,:);
    elemDofs = getDofs(elemNode);
    
    % shape function information
    sData = getElemShapeData(coords(elemNode,:),order);
    
    % initialize
    Ke = zeros(nElemDofs);                % stiffness matrix
    Me = zeros(nElemDofs);                % mass matrix
    
    % judge the part
    C = matProp{parts(iElem)}.C;
    rho = matProp{parts(iElem)}.rho;

    % form element matrices
    for is =1:length(sData)
        iData = sData{is};
        
        [B,H]= getBHmatrix(iData.dhdx,iData.h);
        
        % K
        Ke = B'*(C*B) * iData.weight * elemProp.dV + Ke;
        
        % M
        Me = H'*H*rho * iData.weight * elemProp.dV + Me;

    end
    
    % element row and column matrices
    rowID = elemDofs * ones(1,nElemDofs);
    colID = ones(nElemDofs,1) * elemDofs';
    
    % form sparse assembly vectors
    rowV(:,iElem) = rowID(:);
    colV(:,iElem) = colID(:);
    
    KV(:,iElem) = Ke(:);
    MV(:,iElem) = Me(:);

end

% form sparse matrices

Ksp = sparse(rowV,colV,KV);
Msp = sparse(rowV,colV,MV);

end

%-------------------------------------------------------------------------%
% Function to get gradients of the shape fucntions at global coordinate 
% system and shape function matrix
%-------------------------------------------------------------------------%
function [B,H] = getBHmatrix(dhdx,h)

n = 2*length(dhdx);

B = zeros(3,n);
H = zeros(2,n);

for i =1:length(dhdx)
    B(1,2*i-1) = dhdx(i,1);
    B(2,2*i) = dhdx(i,2);
    B(3,2*i-1) = dhdx(i,2);
    B(3,2*i) = dhdx(i,1);
    
    H(1,2*i-1) = h(i);
    H(2,2*i) = h(i);
end

end