%-------------------------------------------------------------------------%
% Background
% Function to add a resonator (type B: herringboned resonator)
% Two coupling nodes, one or two resonators are distributed symmetrically
%|       resonator       |
%|       hinge joint      |
%| left-------------right |
%|       hinge joint      |
%|       resonator       |
% Created by Lei, TU/e, 2017
%-------------------------------------------------------------------------%

function [K,M,rDofs,extendElems,extendDofs,Alpha] = addResonatorB(Ko,Mo,KR,MR,nr,coords,coupNodes,coordsHin)

nNode = length(coords);

% Hinge joint position
coupNodes = coupNodes(1:2);         % left-right

coordsRel = coordsHin(1,:) - coords(coupNodes(1),:);
Rbar = norm(coordsRel);
Alpha = asin(coordsRel(2)/Rbar);    % included angle
t = tan(Alpha);

% resonator DOFs
totDof = length(Ko);                % basic DOF number
rDof = nr*2;
rDofs = totDof + [1:rDof]';         % resonator's DOF

% allocate two symmetric coupling nodes (Y-coord = middleY, X-coord is coupled)
coupDofs = getDofs(coupNodes);

% extend K and M
K = zeros(totDof+rDof);
K(1:totDof,1:totDof) = Ko;

M = zeros(totDof+rDof);
M(1:totDof,1:totDof) = Mo;
Mu = [MR(1) 0; 0 MR(2)];

% update K and M
Keup = zeros(6,6);                    % upper one
Keup(1,:) = [KR(1)/4/t^2 KR(1)/4/t -KR(1)/4/t^2 KR(1)/4/t 0 -KR(1)/2/t];
Keup(2,:) = t*Keup(1,:);
Keup(3,:) = -Keup(1,:);
Keup(4,:) = Keup(2,:);
Keup(5,:) = [0 0 0 0 KR(2) 0];
Keup(6,:) = [-KR(1)/2/t -KR(1)/2 KR(1)/2/t -KR(1)/2 0 KR(1)];
Ke{1} = Keup;

Kelow = zeros(6,6);                   % lower one
t = -t;
Kelow(1,:) = [KR(1)/4/t^2 KR(1)/4/t -KR(1)/4/t^2 KR(1)/4/t 0 -KR(1)/2/t];
Kelow(2,:) = t*Kelow(1,:);
Kelow(3,:) = -Kelow(1,:);
Kelow(4,:) = Kelow(2,:);
Kelow(5,:) = [0 0 0 0 KR(2) 0];
Kelow(6,:) = [-KR(1)/2/t -KR(1)/2 KR(1)/2/t -KR(1)/2 0 KR(1)];
Ke{2} = Kelow;

extendElems = zeros(2*nr,2);         % extra bar elements
extendDofs = [rDofs;coupDofs];

for ir = 1:nr
rf = rDofs(2*ir-1:2*ir);
df =  [coupDofs;rf];
K(df,df) = K(df,df) + Ke{ir};

M(rf,rf) = M(rf,rf) + Mu;


extendElems(2*ir-1:2*ir,:) = [nNode+ir coupNodes(1);
                              nNode+ir coupNodes(2)];
end

