%-------------------------------------------------------------------------%
% Background
% Function to add a resonator (type A: cruciform resonator)
% four coupling nodes, one resonator
%|         top           |
%| left-resonator-right |
%|        bottom         |
% Created by Lei, TU/e, 2017
%-------------------------------------------------------------------------%

function [K,M,rDofs,extendElems,extendDofs] = addResonatorA(Ko,Mo,KR,MR,coords,coupNodes,coordsRn)

totDof = length(Ko);                % basic DOF number
rDofs = [totDof+1; totDof+2];       % resonator's DOFs

% allocate 4 symmetric coupling nodes (plus configuration)
coupDofs = getDofs(coupNodes);

% extend K
K = zeros(totDof+2);
K(1:totDof,1:totDof) = Ko;

% extend M
M = zeros(totDof+2);
M(1:totDof,1:totDof) = Mo;

% form the extra stiffness and mass matrices 
Mu = [MR(1) 0; 0 MR(2)];
extendElems = zeros(length(coupNodes),2);

% update K
for i =1:length(coupNodes)      

    % compute the rotational angle
    coordsCoup = coords(coupNodes(i),:);
    theta = funTheta(coordsCoup,coordsRn);
    c = cos(theta); s = sin(theta);
    
    % bar unit matrices, resonator-coupling node as reference (0 degree)
    RT = [c*c c*s; c*s s*s];  
    if i<=2
    Ku = KR(1) * RT;
    else
       Ku = 0.5*KR(1) * RT; 
    end
    
    KE = [Ku -Ku;-Ku Ku]; 

    extendDofs = [rDofs; coupDofs(2*i-1:2*i)];
    K(extendDofs,extendDofs) = K(extendDofs,extendDofs) + KE;

    % collect the extra bar element
    extendElems(i,:) = [round(totDof/2)+1 coupNodes(i)];
end

% update M
ME = Mu;
extendDofs = [rDofs;coupDofs];
M(rDofs,rDofs) = M(rDofs,rDofs) + ME;

end

function theta = funTheta(coordsCoup,coordsRn)

coordsRel = coordsCoup - coordsRn;       % relative coordinates
R = norm(coordsRel);
t = asin(coordsRel(2) / R);

theta = t*(coordsRel(1)>=0) + (pi-t)*(coordsRel(1)<0);

end