function PlotModesHM(coords,elems,Fai_full,meshbool)
% Function to plot the eigenmodes, i.e. displacement amplitudes
% input:
%           coords      nodal coordinates
%           elems       coords indices per element
%           Fai_full    displacement field, size(totDof,nModes)
%           meshbool    boolean to plot mesh contour on top of displacement
% 
% Created by S.A. Verhoeven, TU/e, 2022
% Modified by Georgia Kuci, 2024

% number of currently open figures
h =  findobj('type','figure');
n = length(h);

for iMode = 1:size(Fai_full,2)
    dispNode = zeros(size(coords,1),iMode);
    for iNode = 1:size(coords,1)
        dispNode(iNode) = sqrt(Fai_full(iNode*2-1,iMode)^2 + Fai_full(iNode*2,iMode)^2 );
    end
    dispNode = dispNode ./ (max(dispNode)) ; % normalize 0-1

    figure(n+iMode);
    hold on
    % plot the mesh, colored with the nodal displacement
    if meshbool
        for iElem =1:length(elems)
             elemNodes = elems(iElem,:);

             Col = dispNode(elemNodes);
             fill(coords(elemNodes,1),coords(elemNodes,2),Col,'edgecolor','none');
%              fill(coords(elemNodes,1),coords(elemNodes,2),Col,'edgecolor','none');

        end
    else
        for iElem =1:length(elems)
             elemNodes = elems(iElem,:);

             Col = dispNode(elemNodes);
             fill(coords(elemNodes,1),coords(elemNodes,2),Col,'edgecolor','k');

        end
    end



%         % Plot arrows (displacement directions) at each node
%     scale_factor = 0.1; % Scale factor to adjust arrow size
%     quiver(coords(:,1), coords(:,2), ...
%            Fai_full(1:2:end,iMode), Fai_full(2:2:end,iMode), ...
%            scale_factor, 'w', 'LineWidth', 1.5, 'MaxHeadSize', 2);
       
    axis equal
    axis tight
    axis off
    colormap(flipud(hot)); % Use the hot colormap, flipped for the colorbar
end

end % function