% Script to plot effective impedance tensor of enriched continuum
% Created by X.Kuci, TU/e, 2024

% load file name
load('HM_HardRubber.mat')

% input
% W: unit cell size, f: frequency range, n: normal unit vector of a
% surface, DirWave: wave propagation direction
W = 20e-3; 
f = 0:5:1500;
n = [cosd(0),sind(0)];
DirWave = [cosd(67.5),sind(67.5)];

% compute
for iw = 1:length(f)
temp= get_Z_tensor_UC(HM_HardRubber,W,f(iw),n,DirWave);
Z2(iw,:) = [temp(1,1),temp(1,2),temp(2,1),temp(2,2)];
end

% plot
figure
labels = {'Z_{11}', 'Z_{12}', 'Z_{21}', 'Z_{22}'};
for i = 1:4
    subplot(2,2,i)
    plot(f,real(Z2(:,i)),'b',f,imag(Z2(:,i)),'r','Linewidth',2)
    xlabel('Frequency [Hz]','FontName','Times New Roman','FontSize',14);
    ylabel([labels{i}, ' [Rayl]'],'FontName','Times New Roman','FontSize',14);
    legend('Real','Imag','Location','best')
    xlim([f(1), f(end)]);
end
