%-------------------------------------------------------------------------%
% Background
% Nondimensionalized parameter study on bandgap structures
% Created by Lei, TU/e, 2017
%-------------------------------------------------------------------------%

clear,clc
MAT_parameter_study = ['Nondimensionalized_bandgap'];

%% NEM type
Nmu=21;
mu_rho = linspace(0.01,0.99,Nmu);        % mass fraction
omegaM_low = ones(1,Nmu)*1;         % lower
omegaM_up = sqrt(1./(1-mu_rho));    % upper
omegaM.low = omegaM_low;
omegaM.up = omegaM_up;

%% NES type
mu_D = linspace(0.01,0.99,Nmu);          % inertia fraction
mu_w = linspace(1,10,Nmu);         % frequency ratio
Mu_w = [2 4 6 10];
Ns = length(Mu_w);
omegaS_low = zeros(Ns,Nmu);

for i=1:Ns
    omegaS_low(i,:) = sqrt((1+Mu_w(i)^2 - sqrt((1+Mu_w(i)^2)^2 - 4*(1-mu_D)*Mu_w(i)^2))/2./(1-mu_D));
end
omegaS_up = ones(1,Nmu)*1;

omegaS.low = omegaS_low;
omegaS.up = omegaS_up;

% 2D plot
Omega_low = zeros(Nmu,Nmu);
for i = 1:Nmu
     Omega_low(i,:) = sqrt((1+mu_w(i)^2 - sqrt((1+mu_w(i)^2)^2 - 4*(1-mu_D)*mu_w(i)^2))/2./(1-mu_D));   
end

%% plot
figure(1)
hold on
Xband = [mu_rho,fliplr(mu_rho)]*100;
Yband = [omegaM_low,fliplr(omegaM_up)];
% fill(Xband,Yband,'r','EdgeColor','none','facealpha',0.4);
% plot(mu_rho*100,omegaM_low,'k-o','linewidth',2,'MarkerEdgeColor','none','MarkerFaceColor','y','MarkerSize',8)
plot(mu_rho,(omegaM_up-omegaM_low)./omegaM_low*100,'k-o','linewidth',2,'MarkerEdgeColor','none','MarkerFaceColor','r','MarkerSize',8)
xlabel('$\mu_\rho$','FontName','Times New Roman','FontWeight','Bold','FontSize',18,'interpreter','latex')
ylabel('BW$_{\rm{norm}}$ [$\%$]','FontName','Times New Roman','FontWeight','Bold','FontSize',18,'interpreter','latex')
set(gca,'FontName','Times New Roman','FontSize',16)
% title('NEM','FontName','Times New Roman','FontWeight','Bold','FontSize',16,'interpreter','latex')
xlim([0 0.9])
ylim([0 250])
grid off
box on

set(gcf,'Units','centimeters','Position',[5 0 15 12])

figure(2)
hold on
Xband = [mu_D,fliplr(mu_D)]*100;
colorB = linspace(0.1,0.9,Ns);
colorB = [0*colorB' colorB' 1-colorB'];

for i=1:Ns
    Yband = [omegaS_low(i,:),fliplr(omegaS_up)];
%     fill(Xband,Yband,colorB(i,:),'EdgeColor','none','facealpha',0.4);
    plot(mu_D,(omegaS_up-omegaS_low(i,:))./omegaS_up*100,'k-o','linewidth',2,'MarkerEdgeColor','none','MarkerFaceColor',colorB(i,:),'MarkerSize',8)
%     text(mu_D(end)*100,omegaS_low(i,end),['\mu_\omega=' num2str(Mu_w(i))],'FontName','Times New Roman','FontSize',14)  
end
% plot(mu_D*100,omegaS_up,'k-o','linewidth',2,'MarkerEdgeColor','none','MarkerFaceColor','y','MarkerSize',7)
xlabel('$\mu_D$','FontName','Times New Roman','FontWeight','Bold','FontSize',18,'interpreter','latex')
ylabel('BW$_{\rm{norm}}$ [$\%$]','FontName','Times New Roman','FontWeight','Bold','FontSize',18,'interpreter','latex')
set(gca,'FontName','Times New Roman','FontSize',16)
% title('NES','FontName','Times New Roman','FontWeight','Bold','FontSize',14,'interpreter','latex')
grid off
xlim([0 12])
xlim([0 1])
box on
lg = legend('$\Omega_{\rm{mat}}=2$','$\Omega_{\rm{mat}}=4$','$\Omega_{\rm{mat}}=6$','$\Omega_{\rm{mat}}=10$');
set(lg,'FontName','Times New Roman','FontWeight','Bold','FontSize',18,'interpreter','latex');

set(gcf,'Units','centimeters','Position',[5 0 15 12])
% 
% subplot(1,3,3)    % NES-bandgap width
% contourf(mu_D*100,mu_w,1-Omega_low,20,'linestyle','none')
% colormap('jet')
% caxis([0 0.3]);
% colorbar off
% set(gca,'FontSize',16,'FontName','Times New Roman')
% xlim([0 100])
% xlabel('\mu_D [%]','FontName','Times New Roman','FontWeight','Bold','FontSize',16)
% ylabel('\mu_\omega','FontName','Times New Roman','FontWeight','Bold','FontSize',16)
% 
% hbar = colorbar;
% set(hbar, 'FontSize', 16);
% set(hbar, 'Position', [0.93 0.107 0.02 0.82]);
% grid off

% set(gcf,'Units','centimeters','Position',[5 0 25 15])
% save(MAT_parameter_study,'mu_rho','omegaM','mu_D','omegaS','Mu_w');
