%-------------------------------------------------------------------------%
% Function to compute dispersion curves and dynamic effective properties
% kome-ga form
% CMmm, DMmm, CMbb, DMbb, rhoMll, Jclm, Hc 
% are to be used 
%-------------------------------------------------------------------------%
function [NormkH, FreqH, DynParas,CS,CS_LC,DS,rhoS,PolarizationIndex] = getDisperHomK(HM,nk,nOmega,nMode,dirWave,W,computeDispersion,k,kx,ky)

%% G-X-M
kmax = pi/W; % 2*pi / (W*sqrt(2)); %pi/W; %2*pi / (W*sqrt(2));
% ky = 1*ones(1,nk);
% kx = linspace(0*kmax,1*kmax,nk);                       % wave number  
% k = sqrt(kx.^2 + ky.^2);
k = linspace(0*kmax, 1*kmax, nk);
NormkH = linspace(0,1,nk); 

%% M-G
% kmax = 2*pi / (W*sqrt(2));
% k = linspace(-1*kmax, 0*kmax, nk);
% NormkH = linspace(-1,0,nk); 


%%
eW = dirWave(1);                                    % in-plane wave direction
eC = 1;                                             % out-of-plane basis
V = W*W;

% constant terms
resOmega = HM.Omega;

[DynParas,CS,CS_LC,DS,rhoS] = getDynParas(resOmega,nOmega,HM.jh,HM.H,dirWave,HM.CMO,HM.CMO_LC,HM.DMO,HM.rhoM);
e_1 = [1;0];
e_2 = [0;1];

% e_theta = [1;1]./sqrt(2); % rotated base for testing symmetry of Z
% e_v = [-1;1]./sqrt(2);

C_t11 = 1/sqrt(e_1'*HM.CS*e_1);
C_t22 = 1/sqrt(e_2'*HM.CS*e_2);

Kk = zeros(2+length(resOmega));
Mk = eye(2+length(resOmega));
Freq = zeros(nMode,nk);
Omega= Freq;

% get relevant component from H
% compute Hw
Hh = zeros(size(HM.jh));
Hh_T = zeros(size(HM.jh));  % k*H^T, H can be asymmetric!!!!!!
for io = 1:length(resOmega)
    Hh(io,1) = dirWave(1) * HM.H{io}(1,1) + dirWave(2) * HM.H{io}(1,2);
    Hh(io,2) = dirWave(1) * HM.H{io}(2,1) + dirWave(2) * HM.H{io}(2,2);
    %----------------------------------------------------------------------%
    Hh_T(io,1) = dirWave(1) * HM.H{io}(1,1) + dirWave(2) * HM.H{io}(2,1);
    Hh_T(io,2) = dirWave(1) * HM.H{io}(1,2) + dirWave(2) * HM.H{io}(2,2);     
end

if computeDispersion
for iK = 1:nk   
    % Constructing and solving equation (3.8) from thesis Ashwin
   
    % fill in the matrix Kk
    Kk(1:2,1:2) = [k(iK)^2*CS];
    
    Kk(3:end,3:end) = diag((2*pi*resOmega).^2);                             % angular frequency
    
    
    % fill in the matrix Mk
    Mk(1:2,1:2) = [rhoS*eye(2)];
    for io =1:length(resOmega)
        Mk(1:2,2+io) = (HM.jh(io,:) - k(iK)*1i*Hh_T(io,:))/V;
        Mk(2+io,1:2) = (HM.jh(io,:) + k(iK)*1i*Hh(io,:));
%           Mk(1:2,2+io) = (HM.jh(io,:))'/V;
%           Mk(2+io,1:2) = (HM.jh(io,:));
    end
    Mk(3:end,3:end) = eye(length(resOmega));
    
    
    % solve the eigenvalue problem
    [V_modes, Omega2] = eigs(Kk,Mk,nMode,'sm')
    size(V_modes);
    disp(V_modes);
    Omega(:,iK) = sort(abs(sqrt(diag(Omega2))));
    Freq(:,iK)  = Omega(:,iK)./2/pi; % to Hz
    
    % show process
    pcenK = (iK-1)/(nk-1)*100;
    
    if rem(pcenK,1) == 0
    pcomp = fix(pcenK);
    fprintf('omega(k) Homogenization-based Dispersion Analysis: %d%% completed \n ',pcomp)
    end
    
end
end
    
    FreqH = Freq;

    % Initialize PolarizationIndex
    PolarizationIndex = zeros(nMode, nk);

    % Calculate polarization index
    for modeIdx = 1:nMode
        for iK = 1:nk
            % Get displacements (u1 for x, u2 for y) from the first two columns
            u1 = V_modes(1, modeIdx);  % Displacement in x direction (1st DOF)
            u2 = V_modes(2, modeIdx);  % Displacement in y direction (2nd DOF)
            
            % Normalize the displacement vector
            norm_u = sqrt(u1^2 + u2^2);%sqrt(abs(u1)^2 + abs(u2)^2);
            if norm_u == 0
                PolarizationIndex(modeIdx, iK) = 0; % Arbitrary value if both displacements are zero
            else
                % Compute the cosine of the angle with respect to the direction vector
                u_normalized = [u1; u2] / norm_u;
                PolarizationCosine = dot(u_normalized, dirWave) / norm(dirWave);
                PolarizationIndex(modeIdx, iK) = PolarizationCosine;
            end
        end
    end

%     % Debugging: Check PolarizationIndex values before normalization
%     disp('Sample PolarizationIndex values before normalization:');
%     disp(PolarizationIndex(1:5, 1:5));
% 
%     % Handle complex PolarizationIndex by using magnitude
%     PolarizationIndex = abs(PolarizationIndex);
% 
%     % Normalize PolarizationIndex
%     minP = min(PolarizationIndex(:));
%     maxP = max(PolarizationIndex(:));
% 
%     % Debugging: Print min and max before normalization
%     fprintf('minP: %f, maxP: %f\n', minP, maxP);
%     
%     % Avoid division by zero
%     if minP == maxP
%         fprintf('Warning: minP and maxP are equal. Adjusting minP to avoid division by zero.\n');
%         minP = minP - 1;
%     end
%     
%     % Normalize values
%     PolarizationIndex = (PolarizationIndex - minP) / (maxP - minP);
%     
%     % Ensure PolarizationIndex values are properly clamped
%     PolarizationIndex = max(0, min(1, PolarizationIndex));
%     
%     % Debugging: Check PolarizationIndex values after normalization
%     disp('Sample PolarizationIndex values after normalization:');
%     disp(PolarizationIndex(1:5, 1:5));
% 
%     % Check for invalid values
%     if any(PolarizationIndex(:) < 0) || any(PolarizationIndex(:) > 1)
%         error('PolarizationIndex values out of range after normalization');
%     end



end
