%-------------------------------------------------------------------------%
% Background
% Plot Modes
% Created by Lei, TU/e, 2017
%-------------------------------------------------------------------------%
function [XR,YR,Ur]=funPlotModes(key_R,Ramp,coordsRn,coordsHin,nr,r,rangeX,rangeY,U,elems,coords,extendElems,config,Size)
MAT_unit_cell_modes =['Unit_cell_modes.mat'];

% preparation
figure
hold on

CR = coordsRn;
tod = 0;
X1 = min(coords(:,1))-rangeX*tod; X2 = max(coords(:,1))+rangeX*tod;
Y1 = min(coords(:,2))-rangeY*tod; Y2 = max(coords(:,2))+rangeY*tod;
theta = [0:0.05:2*pi 0];
nElems = size(elems,1);
S = 0.75;      % amplitude of the displacement vector
%% Can be left out (resonator in case of double negative)
% switch key_R
% 
% % cruciform  resonantor
% case 'A'
% 
% % generate the resonantor shape
% XR = CR(1,1) + r*cos(theta);
% YR = CR(2,1) + r*sin(theta);
% 
% for iMode = 1:6
%     subplot(config(1),config(2),iMode)
%     Umode = real(U{end}(:,iMode));
%     Unorm = sqrt(Umode(1:2:end).^2 + Umode(2:2:end).^2);
%     Uamp = max(Unorm);
%     Unorm = Unorm  /  Uamp;                     % normalization
%     
%     % plot the matrix
%     for iElem =1:nElems
%          elemNode = elems(iElem,:);
% 
%          nodeZone = [elemNode elemNode(1)];
%          fill(coords(nodeZone,1),coords(nodeZone,2),Unorm(nodeZone),'EdgeColor','none');
%          hold on
%     end
%     
%     Ur = Umode(end-1:end)';
%     Ur = Ur/norm(Ur)*Ramp;
%     
%     % plot springs
%     for iE = 1:length(extendElems)
%         coordsE = [coordsRn(1,:)+Ur; coords(extendElems(iE,2),:)];
%         if iE<=2
%         plot(coordsE(:,1),coordsE(:,2),'-o','color',[0.5 0.5 0.5],'linewidth',3,'MarkerEdgeColor','none','MarkerFaceColor','r','MarkerSize',6);
%         else
%         plot(coordsE(:,1),coordsE(:,2),'-o','color',[0.75 0.75 0.75],'linewidth',3,'MarkerEdgeColor','none','MarkerFaceColor','r','MarkerSize',6);    
%         end
%     
%     end
%     
% % plot resonantor
% plot(XR+ Ur(1),YR+ Ur(2),'r-','linewidth',2);  
% fill(XR+ Ur(1),YR+ Ur(2),Unorm(end),'EdgeColor','none');
% 
% % plot mode direction
% Coords = [coords; CR(1,:)];                 % coordinates
% Um = [Umode(1:2:end) Umode(2:2:end)];       % modal displacements
% Um = Um./[Unorm Unorm];
% quiver(Coords(:,1),Coords(:,2),Um(:,1),Um(:,2),S,'k-','linewidth',1);
% 
% hold off
% set(gca,'xtick',[])
% set(gca,'ytick',[])
% 
% axis('tight')
% axis('square')
% set(gca,'FontName','Times New Roman','FontSize',14)
% colorbar off
% colormap('jet')
% title(['Mode' num2str(iMode)],'FontName','Times New Roman','FontWeight','Bold','FontSize',14)
% xlim([X1 X2]);
% ylim([Y1 Y2]);
% end
% 
% % herringboned  resonantor
% case 'B'
% XR(1,:) = CR(1,1) + r*cos(theta);
% XR(2,:) = CR(2,1) + r*cos(theta);
% YR(1,:) = CR(1,2) + r*sin(theta);
% YR(2,:) = CR(2,2) + r*sin(theta);
% 
% for iMode = 1:6
%     subplot(config(1),config(2),iMode)
%     Umode = real(U{end}(:,iMode));
%     Unorm = sqrt(Umode(1:2:end).^2 + Umode(2:2:end).^2);
%     Uamp = max(Unorm);
%     Unorm = Unorm  /  Uamp;                     % normalization
%     
%     % plot the matrix
%     for iElem =1:nElems
%          elemNode = elems(iElem,:);
% 
%          nodeZone = [elemNode elemNode(1)];
%          fill(coords(nodeZone,1),coords(nodeZone,2),Unorm(nodeZone),'EdgeColor','none');
%          hold on
%     end
%     
%     Ur = zeros(nr,2);normUr = zeros(nr,1);
%     for i=1:nr
%     Ur = [Umode(end-(2*i-1):end-(2*i-2))';
%           Ur];
%     normUr = [norm(Ur(i,:));normUr];
%     end
%    
%     Ur = Ur/max(normUr)*Ramp;
%     
%     % plot two springs and four bars
%     for i=1:nr
%     coordsS =  [coordsHin(i,:); coordsRn(i,:)+Ur(i,:)];   
%     plot(coordsS(:,1),coordsS(:,2),'-o','color',[0.5 0.5 0.5],'linewidth',3,'MarkerEdgeColor','none','MarkerFaceColor','r','MarkerSize',6);
%     
%     coordsE = [coords(extendElems(2*i-1,2),:);coordsHin(i,:); coords(extendElems(2*i,2),:)];
%     plot(coordsE(:,1),coordsE(:,2),'-o','color',[0.2 0.2 0.2],'linewidth',3,'MarkerEdgeColor','none','MarkerFaceColor','r','MarkerSize',6);
%     end
%     
% % plot resonantor
% for i=1:nr
% plot(XR(i,:)+ Ur(i,1),YR(i,:)+ Ur(i,2),'r-','linewidth',2);  
% fill(XR(i,:)+ Ur(i,1),YR(i,:)+ Ur(i,2),Unorm(end-(2-i)),'EdgeColor','none');
% end
% 
% % plot mode direction
% Coords = [coords; CR(1:nr,:)];                 % coordinates
% Um = [Umode(1:2:end) Umode(2:2:end)];       % modal displacements
% Um = Um./[Unorm Unorm];
% quiver(Coords(:,1),Coords(:,2),Um(:,1),Um(:,2),S,'k-','linewidth',1);
% 
% hold off
% set(gca,'xtick',[])
% set(gca,'ytick',[])
% axis('tight')
% axis('square')
% set(gca,'FontName','Times New Roman','FontSize',14)
% colorbar off
% colormap('jet')
% title(['Mode' num2str(iMode)],'FontName','Times New Roman','FontWeight','Bold','FontSize',14)
% xlim([X1 X2]);
% ylim([Y1 Y2]);
% end
% 
% % torsion  resonantor
% case 'C'
% 
% % generate the resonantor shape
% XR = CR(1,1) + r*cos(theta);
% YR = CR(2,1) + r*sin(theta);
% 
% for iMode = 1:6
%     subplot(config(1),config(2),iMode)
%     Umode = real(U{end}(1:end-1,iMode));        % remove the roation mode
%     Unorm = sqrt(Umode(1:2:end).^2 + Umode(2:2:end).^2);
%     Uamp = max(Unorm);
%     Unorm = Unorm  /  Uamp;                     % normalization
%     
%     % plot the matrix
%     for iElem =1:nElems
%          elemNode = elems(iElem,:);
% 
%          nodeZone = [elemNode elemNode(1)];
%          fill(coords(nodeZone,1),coords(nodeZone,2),Unorm(nodeZone),'EdgeColor','none');
%          hold on
%     end
% 
%     
% Ur = Umode(end-1:end)';
% Ur = Ur/norm(Ur)*Ramp;
% 
% % plot resonantor
% plot(XR+ Ur(1),YR+ Ur(2),'r-','linewidth',2);  
% fill(XR+ Ur(1),YR+ Ur(2),Unorm(end),'EdgeColor','none');    
% 
% % plot springs
% for iE = 1:length(extendElems)
%     coordsE = [coordsHin(iE,:)+Ur; coords(extendElems(iE,2),:)];
%     plot(coordsE(:,1),coordsE(:,2),'-o','color',[0.5 0.5 0.5],'linewidth',3,'MarkerEdgeColor','none','MarkerFaceColor','r','MarkerSize',6);
%     
% end
%     
% % plot mode direction
% Coords = [coords; CR(1,:)];                 % coordinates
% Um = [Umode(1:2:end) Umode(2:2:end)];       % modal displacements
% Um = Um./[Unorm Unorm];
% quiver(Coords(:,1),Coords(:,2),Um(:,1),Um(:,2),S,'k-','linewidth',1);
% 
% hold off
% set(gca,'xtick',[])
% set(gca,'ytick',[])
% 
% axis('tight')
% axis('square')
% set(gca,'FontName','Times New Roman','FontSize',14)
% colorbar off
% colormap('jet')
% title(['Mode' num2str(iMode)],'FontName','Times New Roman','FontWeight','Bold','FontSize',14)
% xlim([X1 X2]);
% ylim([Y1 Y2]);
% end
% 
% 
% % herringboned  resonantor + line resonantor
% case 'D'
% XR(1,:) = CR(1,1) + r*cos(theta);   % first two: vertical resonantor, third: horizontal resonantor
% XR(2,:) = CR(2,1) + r*cos(theta);
% XR(3,:) = CR(3,1) + r*cos(theta);
% YR(1,:) = CR(1,2) + r*sin(theta);
% YR(2,:) = CR(2,2) + r*sin(theta);
% YR(3,:) = CR(3,2) + r*sin(theta);
% 
% 
% dispRN = cell(1,6);
% for iMode = 1:6
%     subplot(config(1),config(2),iMode)
%     Umode = real(U{end}(:,iMode));
%     Unorm = sqrt(Umode(1:2:end).^2 + Umode(2:2:end).^2);
%     Uamp = max(Unorm);
%     Unorm = Unorm  /  Uamp;                     % normalization
%     
%     % plot the matrix
%     for iElem =1:nElems
%          elemNode = elems(iElem,:);
% 
%          nodeZone = [elemNode elemNode(1)];
%          fill(coords(nodeZone,1),coords(nodeZone,2),Unorm(nodeZone),'EdgeColor','none');
%          hold on
%     end
% hold on
% % plot the internal surface
% intR = coordsRn(3,1) - coords(extendElems(1,2),1);
% intX = coordsRn(3,:);
%  rectangle('Position',[intX(1)-intR,intX(2)-intR,2*intR,2*intR],...
%         'Curvature',[1,1],'facecolor','none','edgecolor','k','linewidth',2);     % huge voids 
% 
%     
%     Ur = zeros(nr,2);normUr = zeros(nr,1);
%     for i=1:nr
%     Ur = [Umode(end-(2*i-1):end-(2*i-2))';
%           Ur];
%     normUr = [norm(Ur(i,:));normUr];
%     end
%    
%     Ur = Ur/max(normUr)*Ramp;
%     
%     % plot two vertical springs and four bars
%     SpringsV = [];
%     Bars =[];
%     for i=1:nr-1
%     coordsS =  [coordsHin(i,:); coordsRn(i,:)+Ur(i,:)];   
%     plot(coordsS(:,1),coordsS(:,2),'-o','color',[0.5 0.5 0.5],'linewidth',3,'MarkerEdgeColor','none','MarkerFaceColor','r','MarkerSize',6);
%     SpringsV = [SpringsV; coordsS];
%     
%     coordsE = [coords(extendElems(2*i-1,2),:);coordsHin(i,:); coords(extendElems(2*i,2),:)];
%     plot(coordsE(:,1),coordsE(:,2),'-o','color',[0.2 0.2 0.2],'linewidth',3,'MarkerEdgeColor','none','MarkerFaceColor','r','MarkerSize',6);
%     Bars = [Bars; coordsE];
%     end
%     
%     % plot two horizontal springs
%     coordsS =  [ coords(extendElems(5,2),:); coordsRn(3,:)+Ur(3,:); coords(extendElems(6,2),:)]; 
%     plot(coordsS(:,1),coordsS(:,2),'-o','color',[0.5 0.5 0.5],'linewidth',3,'MarkerEdgeColor','none','MarkerFaceColor','r','MarkerSize',6);
%     SpringsH = coordsS;
%     
% % plot resonantor
% for i=1:nr
% plot(XR(i,:)+ Ur(i,1),YR(i,:)+ Ur(i,2),'r-','linewidth',2);  
% fill(XR(i,:)+ Ur(i,1),YR(i,:)+ Ur(i,2),Unorm(end-(3-i)),'EdgeColor','none');
% end

% plot mode direction
Coords = [coords; CR(1:nr,:)];                 % coordinates
Um = [Umode(1:2:end) Umode(2:2:end)];       % modal displacements
Um = Um./[Unorm Unorm];
% quiver(Coords(:,1),Coords(:,2),Um(:,1),Um(:,2),S,'k-','linewidth',1);
quiver(Coords(end-nr+1:end,1),Coords(end-nr+1:end,2),Um(end-nr+1:end,1),Um(end-nr+1:end,2),S,'k-','linewidth',1);
coordsRN = Coords(end-nr+1:end,:);
dispRN{iMode} = Um(end-nr+1:end,:);

hold off
set(gca,'xtick',[])
set(gca,'ytick',[])
axis('tight')
axis('square')
set(gca,'FontName','Times New Roman','FontSize',14)
colorbar off
colormap('jet')
title(['Mode' num2str(iMode)],'FontName','Times New Roman','FontWeight','Bold','FontSize',14)
xlim([X1 X2]);
ylim([Y1 Y2]);
end

end
set(gcf,'Units','centimeters','Position',Size)
hbar = colorbar;
set(hbar, 'FontSize', 14);
set(hbar, 'Position', [0.11 0.263 0.01 0.512]);

% save(MAT_unit_cell_modes,'intX','intR','SpringsV','SpringsH','Bars','coordsRN','dispRN');


%% FE model
figure
% plot the matrix
for iElem =1:nElems
    elemNode = elems(iElem,:);

    nodeZone = [elemNode elemNode(1)];
    fill(coords(nodeZone,1),coords(nodeZone,2),[0.3 0.3 0.3],'EdgeColor','k','linewidth',2);
    hold on
end
axis('tight')
axis('equal')

switch key_R
    case 'D'
        
    % plot two vertical springs and four bars
    for i=1:nr-1
    coordsS =  [coordsHin(i,:); coordsRn(i,:)+Ur(i,:)];   
    plot(coordsS(:,1),coordsS(:,2),'-o','color',[0.5 0.5 0.5],'linewidth',3,'MarkerEdgeColor','none','MarkerFaceColor','r','MarkerSize',6);
    
    coordsE = [coords(extendElems(2*i-1,2),:);coordsHin(i,:); coords(extendElems(2*i,2),:)];
    plot(coordsE(:,1),coordsE(:,2),'-o','color',[0.2 0.2 0.2],'linewidth',3,'MarkerEdgeColor','none','MarkerFaceColor','r','MarkerSize',6);
    end
    
    % plot two horizontal springs
    coordsS =  [ coords(extendElems(5,2),:); coordsRn(3,:)+Ur(3,:); coords(extendElems(6,2),:)]; 
    plot(coordsS(:,1),coordsS(:,2),'-o','color',[0.5 0.5 0.5],'linewidth',3,'MarkerEdgeColor','none','MarkerFaceColor','r','MarkerSize',6);
    
    % plot resonantor
    for i=1:nr
    plot(XR(i,:)+ Ur(i,1),YR(i,:)+ Ur(i,2),'k-','linewidth',2); 
    if i ==3
        fill(XR(i,:)+ Ur(i,1),YR(i,:)+ Ur(i,2),'r','EdgeColor','none');
    else
        fill(XR(i,:)+ Ur(i,1),YR(i,:)+ Ur(i,2),'b','EdgeColor','none');
    end
    end
    
end
set(gca,'FontName','Times New Roman','FontSize',14)
hold off
