%-------------------------------------------------------------------------%
% Background
% Function
% Created by Georgia, TU/e, 2024
%-------------------------------------------------------------------------%
function [NormkH, FreqH, DynParas,CS,rhoS] = disperKpOmega(W,DirWave,CMO,rhoM,jh,Omega,Nomega)

% initialize the frequency axis (Hz)
Lomega = 0;
% Uomega =2*max(Omega);
Uomega = Omega(3)*2;
omega = linspace(Lomega,Uomega,Nomega);

% store the dynamic parameters, rho, K
DynParas.omega = omega;
DynParas.rho = zeros(4,length(omega));
DynParas.C = zeros(4,length(omega));


% Compute C_theta and D_theta
Ct = zeros(2,2);

for Nrow =1:4
    
    % determine i
    i = 1*(Nrow == 1 || Nrow ==3) + 2*(Nrow == 2 || Nrow ==4);
    
    % determine j
    j = 2*(Nrow == 2 || Nrow ==3) + 1*(Nrow == 1 || Nrow ==4);
    
    for Ncol = 1:4
        % determine k
        kr = 2*(Ncol == 2 || Ncol == 3) + 1*((Ncol == 1 || Ncol == 4));
        
        % determine l
        l = 1*(Ncol == 1 || Ncol == 3) + 2*(Ncol == 2 || Ncol == 4);
        
        Ct(j,kr) = DirWave(i)*CMO(Nrow,Ncol)* DirWave(l) + Ct(j,kr);
        
    end
end

% static part
rhoS = rhoM;
CS = Ct;

e_1 = [1,0];
e_2 = [0,1];

C_t11 = e_1*CS*e_1';
C_t22 = e_2*CS*e_2';

v_1 = sqrt(1/C_t11)*e_1; %p=1
v_2 = sqrt(1/C_t22)*e_2; %p=2

K_1 = CS*v_1'*(v_1*CS);
K_2 = CS*v_2'*(v_2*CS);

% Loop for each frequency (real real imag imag)
NormkH = zeros(4,length(omega));
FreqH = zeros(4,length(omega));
for i =1:length(omega)
    
    % transfer frequency to angular frequency 
    iOmega = omega(i) * 2*pi;
    DynParas.omega(i) = iOmega;
    rOmega = Omega * 2*pi;          % resonant frequency
    
    % compute the dynamic density
    rhoE = zeros(2,2);                       % deviatoric
    CE = zeros(2,2);
    Mk = zeros(4,4);
    Kk = zeros(4,4);
    for s =1:length(rOmega)  
        
        J = [jh(s,1)*jh(s,1) jh(s,1)*jh(s,2);...
              jh(s,2)*jh(s,1) jh(s,2)*jh(s,2) ]/W/W;
    
          
        rhoE = rhoE + iOmega^2 / (rOmega(s)^2 - iOmega^2)*J;
        CE = CE ;
        
        Mk = Mk + blkdiag(rhoE,rhoE);
        Kk = Kk + [K_1 K_2; K_1 K_2];
    end

    rhoD = rhoS*eye(2)+ rhoE;             % dynamic density
    CD = CS;                  % dynamic stiffness
    
    DynParas.rho(:,i) = [rhoD(1,1);rhoD(2,2);rhoD(1,2);rhoD(2,1)];
    DynParas.C(:,i) = [CD(1,1);CD(2,2);CD(1,2);CD(2,1)];

    % eigenvalue analysis (two components for k)you
%     keyboard
    [~,k2] = eig(rhoD*iOmega^2,CD);
    
[~,eigenvalues] = eig(Mk*omega(i)^2,Kk);
% Extract eigenvalues (k1^2 and k2^2)
k_squared = diag(eigenvalues);
% Take square root to obtain k1 and k2
k_1 = (sqrt(k_squared(1)))
k_2 = (sqrt(k_squared(2)))
k = sqrt(diag(k2))*W/pi
    % real part
    kr = real(sqrt(diag(k2)))*W/pi;
    
%     keyboard
    
    for j=1:2
    NormkH(j,i) = kr(j);
    FreqH(j,i) = omega(i);
    
    if NormkH(j,i)>1 ||  NormkH(j,i)<=0
        FreqH(j,i) = nan;
    end
    end
    
    % imagninary part
    ki = imag(sqrt(diag(k2)))*W/pi;
    
    for j=3:4
    NormkH(j,i) = -ki(j-2);
    FreqH(j,i) = omega(i);
    
    % where does this come from?
    if NormkH(j,i)<-1 ||  NormkH(j,i)>=0
        FreqH(j,i) = nan;
    end
    end
    
end
