function compare_dispersion(kBA,wBA,varargin)
% compare dispersion diagrams in a single plot
% input:    k Bloch analysis
%           w Bloch analysis
%           
%           k Bloch analysis panel
%           w Bloch analysis panel
%           
%           k Bloch analysis COMSOL
%           w Bloch analysis COMSOL
% 
%           k HM (not yet implemented)
%           w HM (not yet implemented)

% Get COMSOL output
curdir = pwd;
cd('../Results/Dispersion/COMSOL_DNS')
Dispersion_plot_COMSOL;
cd(curdir)

if nargin == 4
    kHM  = varargin{1};
    wHM  = varargin{2};
    if max(kHM) > 1
        kHM = kHM ./ max(kHM); % normalize
    end
end

% xlabel('normalized k');
ylabel('Frequency [MHz]');
grid minor

if size(wBA,1)>6
    plot(kBA +1,wBA(1:6,:),'ro','MarkerSize',2)%,'MarkerSize',2)
else
    plot(kBA +1,wBA       ,'ro','MarkerSize',2)%,'MarkerSize',2)
end

if nargin >= 4
    for i = 1:6
        plot(kHM(1,:)+1,wHM(i,:)./1e6,'ko','MarkerSize',2)
    end
end

% Custom legend
h = zeros(2, 1);
h(1) = plot(NaN,NaN,'bo');
% h(2) = plot(NaN,NaN,'ro');
h(2) = plot(NaN,NaN,'ko');
% legend(h, 'COMSOL DNS','BA DNS','HM model','Location','east');
legend(h, 'COMSOL DNS','HM model','Location','east');

end %function