%-------------------------------------------------------------------------%
% Background
% Computational homogenization under the periodic boundary condition
% Created by Lei, TU/e, 2017
%-------------------------------------------------------------------------%

function [HM,jh,NormkH, FreqH] = compHom(W,V,coords,coordsRef,presNodes,Kqs,Mqs,Mff,Mpf,S,Nset,Omega,Fai)

presDof = 2*length(presNodes);
nModes = Nset(1);
nSamples = Nset(2);
Nomega = Nset(3);

% effective tangent and inertial coupling
[CMO,CMO_LC,DMO,presCoords]= getCD(coords,presNodes,coordsRef,Kqs,Mqs);
HM.CMO = CMO/V;
HM.CMO_LC = CMO_LC/V;
HM.DMO = DMO/V;

% effective density
Ip = ones(presDof,1);
rhoM = zeros(2,2);
rhoM(1,1) = Ip(1:2:end)'*Mqs(1:2:end,1:2:end)*Ip(1:2:end);
rhoM(2,2) = Ip(2:2:end)'*Mqs(2:2:end,2:2:end)*Ip(2:2:end);
rhoM(1,2) = Ip(1:2:end)'*Mqs(1:2:end,2:2:end)*Ip(2:2:end);
rhoM(2,1) = Ip(2:2:end)'*Mqs(2:2:end,1:2:end)*Ip(1:2:end);
HM.rhoM = rhoM/V; % (2.49b)

% collect coupling coefficients H and j
HM.H = cell(nModes,1);
jh = zeros(nModes,2);

for iMode = 1:nModes
    
    % current mode
    fai = Fai(:,iMode);
    
    % linear superposition ([uf; up] = [fai,S;0 I]*[eta;up])
    % reduce the coupling system (Kqs*up + Mqs*ap + mc*ddeta = fiextEffp)
    mc = S'*Mff*fai + eye(presDof)*Mpf*fai; % (2.41)
    
    % allocate H component
    h = zeros(2,2);
    for ip = 1:length(presNodes)
        h = h + mc(2*ip-1:2*ip)*presCoords(ip,:); % (2.49c)
        
    end
    HM.H{iMode} = h;%./V
    
    % allocate j component
    jh(iMode,1) = Ip(1:2:end,1)'* mc(1:2:end); % (2.49d)
    jh(iMode,2) = Ip(2:2:end,1)'* mc(2:2:end); % (2.49d)
    
end
HM.jh    = jh;%
HM.Fai   = Fai;
HM.Omega = Omega;

HM.Jd = cell(1,length(Omega));
HM.Hd = cell(1,length(Omega));
for s=1:nModes
    js = jh(s,:);
    HM.Jd{s} = [js(1)*js(1) js(1)*js(2)
             js(2)*js(1) js(2)*js(2) ]./V;
    Hs = HM.H{s};
    HM.Hd{s} = [Hs(1,1)*Hs(1,1) Hs(1,1)*Hs(2,2) Hs(1,1)*Hs(2,1) Hs(1,1)*Hs(1,2)
             Hs(2,2)*Hs(1,1) Hs(2,2)*Hs(2,2) Hs(2,2)*Hs(2,1) Hs(2,2)*Hs(1,2)
             Hs(1,2)*Hs(1,1) Hs(1,2)*Hs(2,2) Hs(1,2)*Hs(2,1) Hs(1,2)*Hs(1,2)
             Hs(2,1)*Hs(1,1) Hs(2,1)*Hs(2,2) Hs(2,1)*Hs(2,1) Hs(2,1)*Hs(1,2)]./V;
         
    HM.mu_j(s) = (HM.Jd{s}(1,1)+HM.Jd{s}(2,2))/HM.rhoM(1,1);
end

% get dispersion curves
% k(w)
% [NormkH, FreqH,HM.DynParas,HM.CS,HM.DS,HM.rhoS] = disperHom(W,DirWave,HM.CMO,HM.DMO,HM.rhoM,HM.H,jh,Omega,Nomega);  

% w(k), made by SV
%  [NormkH, FreqH,HM.DynParas,HM.CS,HM.CS_LC,HM.DS,HM.rhoS] = getDisperHomK(HM,nSamples,Nomega,nModes,DirWave,W,computeDispersion);

end