%% RandomPortSelect
clc
clear
format
format compact
format long g

%% settings

Smax = 14;  %total subjects
Smin = 5;   %exclude subjects from pilot study

Sint = 10;  %Subject of interest

Coll = ["b",  "r",  "g",  "m",  "k"]; %colors line
Cold = ["b.", "r.", "g.", "m.", "k."];%colors dots

% PlotLim = [2500, 350]; %x, y
 PlotLim = [2100, 125]; %x, y

%% Read Data from files
ReadCheck = [1,1];

% Data(Rep, data S)

for S=Smin:Smax 
    clear FileRaw
    FileRaw(:) = fileread('S' + string(S) + '\Arduino.txt');
    
    ReadCheck = 1;
    for i = 5:length(FileRaw) %skip first 2 characters
        if FileRaw(i) == "P" && FileRaw(i-1) == " " && FileRaw(i-2) == "=" && FileRaw(i-3) == "=" %start of data
            Data(ReadCheck, 1, S) = str2num(FileRaw(i+5));
            Data(ReadCheck, 2, S) = str2num(FileRaw(i+14));
            clear A
            for n = 0:10
                if FileRaw(i+19+n) == ":"
                   break; 
                end
                A(n+1) = FileRaw(i+19+n);
            end
            Data(ReadCheck, 3, S) = str2num(A);
            Data(ReadCheck, 4, S) = str2num(FileRaw(i+19+n+3:i+19+n+4));
            
            ReadCheck = ReadCheck + 1;
        end % end data start
    end %character draw
end %end of S
clear A;

%% Manual corrections of Data
% Data(C, [p, rp, t, c], S)
Data( 1,:,5) = [Data( 1,1,5), NaN, 0, Data( 1,4,5)];
Data(20,:,5) = [Data(20,1,5), NaN, 0, Data(20,4,5)];

Data(48,3,7) = Data(48,3,7) - 5000;
for i = 3:50 %Redo of 3
    Data(i,1:3,7) = Data(i+1,1:3,7);
end

Data(15,:,9) = [Data(15,1,9), NaN, 0, Data(15,4,9)];
Data(41,3,9) = Data(41,3,9) - 8000;
Data(32,:,9) = [Data(32,1,9), NaN, 0, Data(32,4,9)]; %Wrong port

for i = 1:50 %Redo of 1
    Data(i,1:3,10) = Data(i+1,1:3,10);
end
Data(41,:,10) = [Data(41,1,10), NaN, 0, Data(41,4,10)]; %Wrong port


Data(4,3,13) = Data(4,3,13) - 7000;

A = Data;
clear Data;
Data = A(1:50,:,:);
clear A;

%% Check port connections
PortCount = zeros(Smax,5);
for s = Smin:Smax
    for i = 1:50
        if ~isnan(Data(i,2,s))
            PortCount(s, Data(i,2,s)) = PortCount(s, Data(i,2,s)) + 1;
            if Data(i,2,s) ~= Data(i,1,s)
                Scope = "Wrong port at subject " + s + " C" + i
            end
        end
    end
end

%% Construct time-line per S
for S=Smin:Smax 
    Data(1,5,S) = Data(1,3,S);
    for i = 2:length(Data(:,1,S))
        Data(i,5,S) = Data(i,3,S) + Data(i-1,5,S);
    end %end of iterations
    for i = 1:length(Data(:,1,S))
        if isnan(Data(i,2,S))
            Data(i,3,S) = NaN;
        end
    end %end of iterations
end %end of S



%% Overlap induvidual performance chronological

figure(1);
sf1 = subplot(1,2,1);
cla(sf1); hold on;
title('Total performance of S' + string(Smin) + ':' + string(Smax));
plot([1,max(Data(end,5,:))/1000],[300, 300], '--k')
plot([1,max(Data(end,5,:))/1000],[240, 240], '--k')
plot([1,max(Data(end,5,:))/1000],[180, 180], '--k')
plot([1,max(Data(end,5,:))/1000],[120, 120], '--k')
plot([1,max(Data(end,5,:))/1000],[ 60,  60], '--k')
plot([ 600, 600],[0,  max(max(Data(:,3,:)))/1000], '--k')
plot([1200 1200],[0,  max(max(Data(:,3,:)))/1000], '--k')
plot([1800 1800],[0,  max(max(Data(:,3,:)))/1000], '--k')
for S=Smin:Smax
    plot(Data(:,5,S)/1000, Data(:,3,S)/1000, 'LineWidth',0.1)
end
xlim([0,PlotLim(1)]); 
ylim([0,PlotLim(2)]);

% Show induvidual performance

S = Sint;

figure(1);
sf2 = subplot(1,2,2);
cla(sf2); hold on;
title('Performance of S' + string(S));
% plot([1,Data(end,end,S)/1000],[180, 180], '--k')
% plot([1,Data(end,end,S)/1000],[120, 120], '--k')
plot([1,Data(end,end,S)/1000],[ 60,  60], '--k')

    plot(Data(:,5,S)/1000, Data(:,3,S)/1000, 'k', 'LineWidth',0.1)
    
% xlim([0,PlotLim(1)]); 
% ylim([0,PlotLim(2)]);

subplot(1,2,1);
for p = 1:5
    plot(Data(:,5,S)/1000, Data(:,3,S)/1000, 'k', 'LineWidth',1.5)
end

%% Overlap induvidual performance port colored

figure(1);
sf1 = subplot(1,2,1);
cla(sf1); hold on;
title('Total performance of S' + string(Smin) + ':' + string(Smax));
plot([1,max(Data(end,5,:))/1000],[300, 300], '--k')
plot([1,max(Data(end,5,:))/1000],[240, 240], '--k')
plot([1,max(Data(end,5,:))/1000],[180, 180], '--k')
plot([1,max(Data(end,5,:))/1000],[120, 120], '--k')
plot([1,max(Data(end,5,:))/1000],[ 60,  60], '--k')
plot([ 600, 600],[0,  max(max(Data(:,3,:)))/1000], '--k')
plot([1200 1200],[0,  max(max(Data(:,3,:)))/1000], '--k')
plot([1800 1800],[0,  max(max(Data(:,3,:)))/1000], '--k')
for S=Smin:Smax 
    for p = 1:5
        A = [0,0];
        for i = 1:length(Data(:,1,S))
            if Data(i,1,S) == p
                if A(1) > 0
                    %plot([A(1), Data(i,5,S)/1000], [A(2), Data(i,3,S)/1000], Coll(n), 'LineWidth',1)
                   % plot([A(1), Data(i,5,S)/1000], [A(2), Data(i,3,S)/1000], 'k', 'LineWidth',0.1)
                end
                plot(Data(i,5,S)/1000, Data(i,3,S)/1000, Cold(p), 'MarkerSize',20)
                A = [Data(i,5,S)/1000, Data(i,3,S)/1000];
            end
        end
    end
end
xlim([0,PlotLim(1)]); 
ylim([0,PlotLim(2)]);

% Show induvidual performance

S = Sint;

figure(1);
sf2 = subplot(1,2,2);
%cla(sf2); 
hold on;
title('Performance of S' + string(S));
% plot([1,Data(end,end,S)/1000],[180, 180], '--k')
% plot([1,Data(end,end,S)/1000],[120, 120], '--k')
plot([1,Data(end,end,S)/1000],[ 60,  60], '--k')

for p = 1:5
    A = [0,0];
    for i = 1:length(Data(:,1,S))
        if Data(i,1,S) == p
            if A(1) > 0
                
                plot([A(1), Data(i,5,S)/1000], [A(2), Data(i,3,S)/1000], Coll(p), 'LineWidth',5)
                %plot([A(1), Data(i,5,S)/1000], [A(2), Data(i,3,S)/1000], 'k', 'LineWidth',0.1)
            end
            plot(Data(i,5,S)/1000, Data(i,3,S)/1000, Cold(p), 'MarkerSize',20)
            A = [Data(i,5,S)/1000, Data(i,3,S)/1000];
        end
    end
end
% xlim([0,PlotLim(1)]); 
% ylim([0,PlotLim(2)]);

subplot(1,2,1);
for p = 1:5
    A = [0,0];
    for i = 1:length(Data(:,1,S))
        if Data(i,1,S) == p
            if A(1) > 0
                plot([A(1), Data(i,5,S)/1000], [A(2), Data(i,3,S)/1000], Coll(p), 'LineWidth',5)
                %plot([A(1), Data(i,5,S)/1000], [A(2), Data(i,3,S)/1000], 'k', 'LineWidth',0.1)
            end
            A = [Data(i,5,S)/1000, Data(i,3,S)/1000];
        end
    end
end

%% Find mean, std, median for each repetition
for r = 1:50
    DataM(r,1)  =   mean(Data(r,3,Smin:Smax),'omitnan');
    DataM(r,2)  =    std(Data(r,3,Smin:Smax),'omitnan');
    DataM(r,3)  = median(Data(r,3,Smin:Smax),'omitnan');
end



%% Show repetition corrected for all participants
figure(1);
clf(1); hold on;
subplot(2,1,2); hold on;
title('Time requirement per repetition of all participants')
ylim([0,60]); xlim([0,51])

%Moving average
dx = 1; clear MA;
for i = dx+1:length(DataM)-dx
    MA(i) = mean(DataM(i-dx:i+dx,3)/1000);
end
plot([dx+1:length(DataM)-dx],MA(dx+1:end),'-r', 'LineWidth',1.5)

boxplot(squeeze(Data(:,3,Smin:Smax)/1000)')
ylim([0,80]); 
xlim([0,51])

A = [];
for s = Smin:Smax
    A = [A; Data(:,3,s)];
end
A = A / 1000;
plot([0.5,50.5],[median(A,'omitnan'),median(A,'omitnan')],'k--')
clear A

subplot(4,1,1); hold on;
boxplot(squeeze(Data(:,3,Smin:Smax)/1000)')
ylim([80,320]); 
xlim([0,51])
title('Time requirement per repetition of all participants')

%% average end-time
clc
Data(end,5,Smin:Smax)/1000/60;
figure(3)
bar(squeeze([Data(end,5,Smin:Smax)/1000/60]))
" "
mean(Data(end,5,Smin:Smax)/1000)/60 %minutes
std(Data(end,5,Smin:Smax)/1000)/60 %minutes
median(Data(end,5,Smin:Smax)/1000)/60 %minutes
    

%% Show performance per Port
figure(2); clf;
for p = 1:5
    subplot(2,3,p)
    hold on;
    title('Performance of S' + string(Smin) + ':' + string(Smax) + ' for port ' + string(p))
%     plot([1,max(Data(end,5,:))/1000],[300, 300], '--k')
%     plot([1,max(Data(end,5,:))/1000],[240, 240], '--k')
%     plot([1,max(Data(end,5,:))/1000],[180, 180], '--k')
%     plot([1,max(Data(end,5,:))/1000],[120, 120], '--k')
%     plot([1,max(Data(end,5,:))/1000],[ 60,  60], '--k')
%     plot([ 600, 600],[0,  max(max(Data(:,3,:)))/1000], '--k')
%     plot([1200 1200],[0,  max(max(Data(:,3,:)))/1000], '--k')
%     plot([1800 1800],[0,  max(max(Data(:,3,:)))/1000], '--k')
    for S=Smin:Smax
        A = [0,0];
        for i = 1:length(Data(:,1,S))
            if Data(i,1,S) == p
                if A(1) > 0
                    %plot([A(1), Data(i,5,S)/1000], [A(2), Data(i,3,S)/1000], Coll(n), 'LineWidth',1)
                    plot([A(1), Data(i,5,S)/1000], [A(2), Data(i,3,S)/1000], 'k', 'LineWidth',0.1)
                end
                plot(Data(i,5,S)/1000, Data(i,3,S)/1000, Cold(p), 'MarkerSize',10)
                A = [Data(i,5,S)/1000, Data(i,3,S)/1000];
            end
        end
    end
    xlim([0,PlotLim(1)]); 
    ylim([0,PlotLim(2)]);
%     if p == 3
%      ylim([0,350])
%     end
end



%% Show performance per Port (repetition corrected)
DataP  = zeros(10,14,5);
% DataP(Rep, S, P)

figure(3); clf;
for p = 1:5
    subplot(2,3,p)
    hold on;
    title('Performance of S' + string(Smin) + ':' + string(Smax) + ' for port ' + string(p) + ' (repetition corrected)')
%     plot([1,10],[300, 300], '--k')
%     plot([1,10],[240, 240], '--k')
%     plot([1,10],[180, 180], '--k')
%     plot([1,10],[120, 120], '--k')
%     plot([1,10],[ 60,  60], '--k')
    %     plot([ 600, 600],[0,  max(max(Data(:,3,:)))/1000], '--k')
    %     plot([1200 1200],[0,  max(max(Data(:,3,:)))/1000], '--k')
    %     plot([1800 1800],[0,  max(max(Data(:,3,:)))/1000], '--k')
    for S=Smin:Smax
        Rep = 0;
        for i = 1:length(Data(:,1,S))
            if Data(i,2,S) == p
                Rep = Rep + 1;
                DataP(Rep, S, p) = Data(i,3,S)/1000;
                
                %plot([1:11], DataP(:,S ,p), Coll(p), 'LineWidth',1)
                %plot(DataP(:,S ,p), '-k', 'LineWidth',0.1)
                plot(DataP(:,S ,p), Cold(p), 'MarkerSize',20)
            end
        end
        for Rep = 1:10 %check for empty spaces
            if DataP(Rep, S, p) == 0
                DataP(Rep, S, p) = NaN;
            end
        end
    end
    
    %     xlim([0,PlotLim(1)]);
%     ylim([0,PlotLim(2)]);
end

%% Find mean, std, median for each repetition
% DataP(Rep, S, P)
for p = 1:5
    for r =  1:10
        DataPM(r,1,p)  =   mean(DataP(r,Smin:Smax,p),'omitnan');
        DataPM(r,2,p)  =    std(DataP(r,Smin:Smax,p),'omitnan');
        DataPM(r,3,p)  = median(DataP(r,Smin:Smax,p),'omitnan');
    end
end

figure(3)
for p = 1:5
    subplot(2,3,p)
    plot(DataPM(:,3,p),'k--')
end

clear DataPMm
for p = 1:5
    A = [];
    for r = 7:10
        A = [A, DataP(r,Smin:Smax,p)];
    end
    DataPMm(p,1) =   mean(A,'omitnan');
    DataPMm(p,2) =    std(A,'omitnan');
    DataPMm(p,3) = median(A,'omitnan');
    subplot(2,3,p)
    hold on
    plot([7,10],[DataPMm(p,3),DataPMm(p,3)],'r--')
end
DataPMm
clear A


%% Make boxplot
figure(3); 
%clf(3)
for p = 1:5
    subplot(2,3,p)
    hold on;
    title('Boxplot for port ' + string(p) )% + ' (repetition corrected)')
    ylabel('Time [sec]'); xlabel('Repetition [#]'); 
    boxplot((DataP(:,Smin:Smax,p))')
    %xlim([0,10])
 ylim([0,PlotLim(2)])
 if p == 3
     ylim([0,350])
     plot([0,1],[PlotLim(2), PlotLim(2)], '--k')
 end
 
end

% matlab's default outliers range from >= +-1.5 IQR
% https://nl.mathworks.com/matlabcentral/answers/434943-knowing-defult-box-plot-outliers-percentiles

%% make boxplot of all port's medians

figure(3)
subplot(2,3,6)
hold on
title('Overlap of all port''s medians')
ylabel('Time [s]'); xlabel('Repetition [#]');

boxplot(squeeze(DataPM(:,3,:))')

% for p = 1:5
%     for r = 1:10
%         plot([r-0.1,r+0.1],[DataPM(r,3,p),DataPM(r,3,p)],'m-')
%     end
% end

ylim([0,50])

%for r = 1:50
%     plot([r-0.3,r+0.3],[DataM(r,3)/1000,DataM(r,3)/1000],'r', 'LineWidth',2)
% end

%% Find median of repetition 7:10
clc
%DataP(Rep, S, p)
for p = 1:5
    A = DataP(7:10,Smin,p);
    for s  = Smin+1:Smax
        A = [A; DataP(7:10,s,p)];
    end
    DataPm(p) = median(A,'omitnan');
end
DataPm'
%clear A

%% Find average
% DataP(Rep, S, P)
clc
for p = 1:5
    for n = 1:10
        DataPm(n,1,p) = mean(DataP(n,Smin:Smax,p),'omitnan');
        DataPm(n,2,p) = std(DataP(n,Smin:Smax,p),'omitnan');
    end
    subplot(2,3,p)
    plot(DataPm(:,1,p), '--k')
    xlabel('Repetitions')
    ylabel('Time [s]')
    
    subplot(2,3,6); hold on;
    xlabel('Repetitions')
    ylabel('Time [s]')
    title("Overlap of all average lines")
    plot(DataPm(:,1,p), '--k')
    axis([0.5 10.5 0 50])
    xticks([1:10])
   
     'Port ' + string(p) + ' final average is ' + mean(DataPm(7:10,1,p)) + ' seconds (' + std(DataPm(7:10,1,p)) + ')'
     'Port ' + string(p) + ' final median is ' + median(DataPm(7:10,1,p)) + ' seconds (' + std(DataPm(7:10,1,p)) + ')'
end
        
clear Qth IQR



















