
clc
clear
format
format compact
format long g

Sum = zeros(2,2);

%% Open file

S = 14;     %Total subjects
Smin = 5;   %Include staring 5, exlcuding pilot subjects
R = 7;      %7 repetitions
Rinc = 6;   %Include starting this repetition for final markers

File = xlsread("Task_1_Data.xlsx");
Data = [File(2:8   , 2:end);
        File(10:end, 2:end)];
    
for i = Smin:S
    DataQ(:,i) = Data(:,((i-1)*2)+1); %DataQ(r,s) Instructions
    DataT(:,i) = Data(:,((i-1)*2)+2); %DataT(r,s) Time
end


%% Plot raw data
figure(1)
clf; 

subplot(2,1,1); hold on;
title('Dis-assembly time and instructions')
for r = 1:R
    ErPos = zeros(1,6);
    yyaxis left
    ylabel('Time [sec]')
    axis([0.5 7.5 0 200])
    for s = Smin:S
        plot(r, DataT(r,s),'.', 'MarkerSize',20);
    end
    for s = Smin:S
        yyaxis right
        ylabel('Sum of Instructions [#]')
        axis([0.5 7.5 0 7])
        if sum(DataQ(r,s)) > 0
            ErPos(DataQ(r,s)) = ErPos(DataQ(r,s)) + 1;
            errorbar(r+ErPos(DataQ(r,s))*0.1,0,sum(DataQ(r,s)), '.')
        end
    end
end

subplot(2,1,2); hold on;
title('Re-assembly time and instructions')
for r = R+1:R*2
    ErPos = zeros(1,6);
    yyaxis left
    ylabel('Time [sec]')
    axis([0.5 7.5 0 500])
    for s = Smin:S
        plot(r-R, DataT(r,s),'.', 'MarkerSize',20);
    end
    for s = Smin:S
        yyaxis right
        ylabel('Sum of Instructions [#]')
        axis([0.5 7.5 0 7])
        if sum(DataQ(r,s)) > 0
            ErPos(DataQ(r,s)) = ErPos(DataQ(r,s)) + 1;
            errorbar(r-R+ErPos(DataQ(r,s))*0.1,0, sum(DataQ(r,s)), '.')
            if s == 7 %Idnetified outlier in different color
                errorbar(r-R+ErPos(DataQ(r,s))*0.1,0, sum(DataQ(r,s)), '.', 'Color', 'cyan')
            end
        end
    end
end
xlabel('Repetitions')

%% Check the outlier
clc
TotQ = 0;
TotQ7 = 0;
for s = Smin:S
    for r = 8:14
        TotQ = TotQ + DataQ(r,s);
        if s == 7
            TotQ7 = TotQ7 + DataQ(r,s);
        end
    end
end

[TotQ7, TotQ]
TotQ7 / TotQ * 100 + "%"

clear TotQ TotQ7
%% Build a Boxplot

figure(2)
clf;
subplot(2,1,1); hold on;
    title('Dis-assembly time')
    boxplot(DataT(1:R,Smin:S)')
    %plot(DataTm(1:R,1), '--k')
    %plot(0) %Change graph color
    axis([0.5 7.5 0 180])
    ylabel('Time [sec]')
    %add instructions
    for r = 1:R
        ErPos = zeros(1,6);
        yyaxis left
        for s = Smin:S
            yyaxis right
            ylabel('Sum of Instructions [#]')
            axis([0.5 7.5 0 7])
            if sum(DataQ(r,s)) > 0
                ErPos(DataQ(r,s)) = ErPos(DataQ(r,s)) + 1;
                errorbar(r+ErPos(DataQ(r,s))*0.1,0,sum(DataQ(r,s)), '.', 'Linewidth', 1.5)
                if s == 7 %Idnetified outlier in different color
                    errorbar(r+ErPos(DataQ(r,s))*0.1,0, sum(DataQ(r,s)), '.', 'Color', [0.8 0.0 1], 'Linewidth', 1.5)
                end
            end
        end
    end


subplot(2,1,2); hold on;
    title('Re-assembly time')
    boxplot(DataT(R+1:R*2,Smin:S)')
    %plot(DataTm(R+1:R*2,1), '--k')
    %plot(0) %Change graph color
    axis([0.5 7.5 0 500])
    ylabel('Time [sec]')
    xlabel('Repetitions')
%Add instructions
for r = R+1:R*2
    ErPos = zeros(1,6);
    yyaxis left
    for s = Smin:S
        yyaxis right
        ylabel('Sum of Instructions [#]')
        axis([0.5 7.5 0 7])
        if sum(DataQ(r,s)) > 0
            ErPos(DataQ(r,s)) = ErPos(DataQ(r,s)) + 1;
            errorbar(r-R+ErPos(DataQ(r,s))*0.1,0, sum(DataQ(r,s)), '.', 'Linewidth', 1.5)
            if s == 7 %Idnetified outlier in different color
                errorbar(r-R+ErPos(DataQ(r,s))*0.1,0, sum(DataQ(r,s)), '.', 'Color', [0.8 0.0 1], 'Linewidth', 1.5)
            end
        end
    end
end



%%  Create mean, std and median of all last repetitions 
clear DataSelect
DataSelect=[];
for r = Rinc:7
    DataSelect = [DataSelect, DataT(r,Smin:S)];
end
DataTm(1,1) =   mean(DataSelect);
DataTm(1,2) =    std(DataSelect);
DataTm(1,3) = median(DataSelect);

clear DataSelect
DataSelect=[];
for r = Rinc+7:R*2
    DataSelect = [DataSelect, DataT(r,Smin:S)];
end
DataTm(2,1) =   mean(DataSelect);
DataTm(2,2) =    std(DataSelect);
DataTm(2,3) = median(DataSelect);

clc
DataTm

%% find records
clc
Scope = "Minimum time record for dis-assembly is " + min(min(DataT(1:7, Smin:S))) + " seconds"
Scope = "Maximum time record for dis-assembly is " + max(max(DataT(1:7, Smin:S))) + " seconds"
Scope = "Minimum time record for re-assembly is " + min(min(DataT(8:14, Smin:S))) + " seconds"
Scope = "Maximum time record for re-assembly is " + max(max(DataT(8:14, Smin:S))) + " seconds"


%% Compare time r=Rinc:7 to r = 1 per subject
clc
figure(4)
clf; hold on;
subplot(2,1,1);  hold on;
title('Relative improvement'); xlabel('Participant'); ylabel('%')
for s = Smin:S
    SImp(1,s) = DataT(1,s) / median(DataT(Rinc:R,s));
    bar(s-Smin, SImp(1,s)*100)
end
plot([-0.5:S-Smin+0.5],ones(1,11)*mean(SImp(1,Smin:S)*100),'m--')
Scope = "Average relative improvement of "+ Rinc +":7 compared to 1 is " + mean(SImp(1,Smin:S)*100) + "%"

subplot(2,1,2);  hold on;
xlabel('Participant'); ylabel('%')
for s = Smin:S
    SImp(2,s) = DataT(8,s) /  median(DataT(R+Rinc:2*R,s));
    bar(s-Smin, SImp(2,s)*100)
end
plot([-0.5:S-Smin+0.5],ones(1,11)*mean(SImp(2,Smin:S)*100),'m--')
Scope = "Average relative improvement of "+ Rinc +":7 compared to 1 is " + mean(SImp(2,Smin:S)*100) + "%"



