***Impact Aware Manipulation (I.AM.) archive***

Authors: J. van Voorst, M.L.S. Lubbers, M.J. Jongeneel, A. Saccon
Dynamics & Control Group, Faculty of Mechanical Engineering, Eindhoven University of Technology

Corresponding author: M.J. Jongeneel 
Contact Information: m.j.jongeneel@tue.nl


Eindhoven University of Technology - Faculty of Mechanical Engineering
P.O. Box 513 5600 MB Eindhoven The Netherlands

***General Introduction***

This archive contains recordings of experiments that are executed under the scenario of TOSS. In these recordings, a UR10 robot is used to release a plastic plate on which different weights are attached. The purpose of these experiments is to learn the release dynamics of the suction cup that is holding and releasing the plastic plate. This modeling framework is used within the H2020 I.AM. project (www.i-am-project.eu) to predict the end pose of a certain box on a conveyor belt, after it is tossed. This archive is being made public in order for other researchers to use this data in their own work.

All the recordings in the archive were performed at the Innovation Lab of Vanderlande, located within the TU/e campus, in November 2021.
This archive is published accompanying the deliverable ``I.AM. - D1.1 - Publication of I.AM. dataset - v1.0``, see www.i-am-project.eu for more info.
This research project has received funding from the European Union’s Horizon 2020 research and innovation program under grant agreement No. 871899.

***Test equipment***

The experiments involve releasing the plastic plate with different weights from a UR10 robot onto a Vanderlande conveyor. Data was logged using an OptiTrack motion capture system, an Intel Realsense D415 reference camera, and sensors from the UR10 robot, including a SCHMALZ VS VP8 SA M8-4 Vacuum sensor. Further details of the equipment are provided as metadata in each recording subfolder of the archive. 

***Description of the data in this archive***

This archive contains a total of 110 subfolders, each corresponding to a specific recording. Each folder follows the naming convention ``Rec_<timestamp>``, where the timestamp corresponds to the start time of the recording, expressed according to ISO 8601. The contents of these subfolders all have the same structure, which is described in the file called "recording_format".