close all, clear all

X = logspace(-1,1,201);

% function 1 of g(X)
for k = 1:length(X)
    
    Xint = X(k);
    
    funA1 = @(k,Xint) (airy(1,(k.*exp(-i.*pi./3))).*exp(-k.^3*Xint))./(airy(k.*exp(-i.*pi./3)));
    funB1 = @(k,Xint) (airy(1,(k.*exp(i.*pi./3))).*exp(-k.^3*Xint))./(airy(k.*exp(i.*pi./3)));
    
    qA1 = integral(@(k)funA1(k,Xint),Inf,0,'AbsTol',1e-12,'RelTol',1e-9);
    qB1 = integral(@(k)funB1(k,Xint),0,Inf,'AbsTol',1e-12,'RelTol',1e-9);
    
    gXA1 = (-3*exp(-i*pi/3))/(2*pi*i) .* qA1;
    gXB1 = (-3*exp(i*pi/3))/(2*pi*i) .* qB1;
    
    gX1(k) = gXA1 + gXB1;
    
    GX(k) = (0.546.*(X(k).^(1/2.420) + 1.058).^(2.420/6))./(X(k).^(1/2));
    
    ratio(k) = gX1(k)./GX(k);
end

A12 = gX1(1)./(X(1)).^(-1/2);
g12 = A12 .* X.^(-1/2);

A13 = gX1(end)./(X(end)).^(-1/3);
g13 = A13 .* X.^(-1/3);

beta = -gradient(log(gX1),log(X));
gradbeta = gradient(beta,log(X));

beta_G = -gradient(log(GX),log(X));

Xmax =  X(find(gradbeta == min(gradbeta)));

% function 2 of g(X) to calculate Nux
b = 1e-1;
Gz = 1;
x = logspace(-7,-1,61);

for l = 1:length(x)
    
    xint = x(l)./Gz .* (1+4.*b)./(b.^3);
    
    funA2 = @(k,Xint) (airy(1,(k.*exp(-i.*pi./3))).*exp(-k.^3*xint))./(airy(k.*exp(-i.*pi./3)));
    funB2 = @(k,Xint) (airy(1,(k.*exp(i.*pi./3))).*exp(-k.^3*xint))./(airy(k.*exp(i.*pi./3)));
    
    qA2 = integral(@(k)funA2(k,xint),0,Inf,'AbsTol',1e-12,'RelTol',1e-9);
    qB2 = integral(@(k)funB2(k,xint),0,Inf,'AbsTol',1e-12,'RelTol',1e-9);
    
    gXA2 = (3*exp(-5*i*pi/6))/(2*pi) .* qA2;
    gXB2 = (3*exp(5*i*pi/6))/(2*pi) .* qB2;
    
    gX2(l) = gXA2 + gXB2;
    
    Nux(l) = 2./b.*gX2(l);
    
    Nu13(l) = 2/(9^(1/3) * gamma(4/3)) .* x(l).^(-1/3);
    Nu12(l) = 1/sqrt(pi) .* x(l).^(-1/2);
       
end

kk = 0;

% kk = kk+1;
% figure(kk)
% hold on
% plot(X,gX1,'-r');
% set(gca,'XScale','log','YScale','log');
% hold off

kk = kk+1;
figure(kk)
hold on
plot(X,g12,'--','Color',[0.92157,0.25098,0.23137]);
plot(X,g13,'--','Color',[0.15294,0.26275,0.53725]);
plot(X,gX1,'k');
set(gca,'XScale','log','YScale','log');
ylim([.005 100]);
set(gcf,'Color','w');
box on
xlabel('$X$','Interpreter','LaTex');
ylabel('$g(X)$','Interpreter','LaTex');
text(2,1,'$g(X)$');
text(.0003,2,'$X^{-1/3}$','Color',[0.15294,0.26275,0.53725]);
text(20,.02,'$X^{-1/2}$','Color',[0.92157,0.25098,0.23137]);
hold off
matlab2tikz('integral_gX_fig1.tikz', 'height', '\figureheight', 'width', '\figurewidth');

% kk = kk+1;
% figure(kk)
% hold on
% plot(X,ratio,'-k');
% set(gca,'XScale','log','YScale','linear');
% hold off

kk = kk+1;
figure(kk)
hold on
plot(X,beta,'Color',[0.15294,0.26275,0.53725])
%plot(X,ones(length(X)).*-5/12);
set(gca,'XScale','log','YScale','linear');
ylim([1/3 .5]);
set(gca,'YTick',[1/3 9/24 5/12 11/24 1/2],'YTickLabel',{'$1/3$','','$5/12$','','$1/2$'});
xlabel('$X$','Interpreter','LaTex');
ylabel('$\beta$','Interpreter','LaTex');
set(gcf,'Color','w');
box on
hold off
matlab2tikz('integral_gX_fig2.tikz', 'height', '\figureheight', 'width', '\figurewidth');

kk = kk+1;
figure(kk)
hold on
plot(X,beta,'Color',[0.15294,0.26275,0.53725])
plot(X,beta_G,'Color',[0.92157,0.25098,0.23137])
set(gca,'XScale','log','YScale','linear');
ylim([1/3 .5]);
set(gca,'YTick',[1/3 9/24 5/12 11/24 1/2],'YTickLabel',{'$1/3$','','$5/12$','','$1/2$'});
xlabel('$X$','Interpreter','LaTex');
ylabel('$\beta$','Interpreter','LaTex');
set(gcf,'Color','w');
box on
legend('\beta','\beta_G');
legend('boxoff');
hold off

% kk = kk+1;
% figure(kk)
% hold on
% plot(X,gradbeta,'k')
% set(gca,'XScale','log','YScale','linear');
% hold off

kk = kk+1;
figure(kk)
hold on
plot(x,Nu13,'--','Color',[0.92157,0.25098,0.23137]);
plot(logspace(-2,0,2),[3.66 3.66],'--','Color',[0.92157,0.25098,0.23137]);
plot(x,Nu12,'--','Color',[0.15294,0.26275,0.53725]);
plot(logspace(-2,0,2),[5.78 5.78],'--','Color',[0.15294,0.26275,0.53725]);
plot(x,Nux,'k');
set(gca,'XScale','log','YScale','log');
ylim([2 2000]);
xlim([1e-7 1]);
set(gcf,'Color','w');
box on
xlabel('$x/Gz$','Interpreter','LaTex');
ylabel('$Nu_x$','Interpreter','LaTex');
hold off