function  [Nux_inf,Nux,Nux_av,fit_alpha,fit_beta,fit_delta,x,beta_local,beta_anal,lambdaT,lambdaNu] = bGRAETZ
%
% Calculate for various b the Nusselt no. Nux_inf and the coefficient of
% the curve in the thermally developing regime

clear all, close all

b_max = 10000;
% b_in = linspace(0,1,101);
% b = [(0.99999.*b_in.^8 + 0.00001.*b_in.^2).*b_max];    % Mesh refinement near b* = 0
% b = logspace(-5,2,36);                                   % Grid space 
 b = [1e-6 logspace(-3,0,7) b_max];                              % Grid space for figure 4

% nomenclature GREATZPDE: [Nux_inf,Nux,Nux_av,fit_alpha,fit_beta,x] = GREATZPDE(b,fig_on)
nb = length(b);
domb = 1:nb;
for i = domb
    close all
    [Nux_inf(i),Nux(i,:),Nux_av(i,:),fit_alpha(i),fit_beta(i),fit_delta(i),x(i,:),beta_local(i,:),x_anal(i,:),beta_anal(i,:),lambdaT(i,:),lambdaNu(i),xGz12(i),xGz13(i)] = GRAETZpde(b(i),0);
end

% Calculation of alpha (inf.) for b* < 10^-5 and for b* > 5*10^1
fit_alphasmall = mean(fit_alpha(find(b<=1e-5)));
fit_alphalarge = mean(fit_alpha(find(b>=1e2)));

% Calculation of beta (b*=1) by using y-intercept
beta0_sel = fit_beta(find((b>=1e-7) & (b<=1e-5) & (b ~= 0)));
b_sel = b(find((b>=1e-7) & (b<=1e-5) & (b ~= 0)));
beta0_linefit = polyfit(b_sel,beta0_sel,1);
fit_beta0 = beta0_linefit(2);
fit_A = beta0_linefit(1);
beta0_line = fit_A .* b_sel + fit_beta0;

% Computing dbeta*/db and dNux_inf/db to determine maximum rate of change
gradbeta = gradient(-fit_beta,b);
gradalpha = gradient(fit_alpha,b);
gradNux_inf = gradient(Nux_inf,b);

% force variables to be visible in workspace
assignin('base','b',b);
assignin('base','Nux_inf',Nux_inf);
assignin('base','Nux',Nux);
assignin('base','Nux_av',Nux_av);
assignin('base','fit_alpha',fit_alpha);
assignin('base','fit_beta',fit_beta);
assignin('base','x',x);
assignin('base','beta0_sel',beta0_sel);
assignin('base','b_sel',b_sel);
assignin('base','beta0_linefit',beta0_linefit);
assignin('base','fit_beta0',fit_beta0);
assignin('base','fit_A',fit_A);
assignin('base','beta0_line',beta0_line);
assignin('base','gradbeta',gradbeta);
assignin('base','gradalpha',gradalpha);
assignin('base','gradNux_inf',gradNux_inf);
assignin('base','beta_local',beta_local);
assignin('base','lambdaT',lambdaT);
assignin('base','lambdaNu',lambdaNu);

%% Set filename properties

figurefile = ['bGRAETZ' '\' 'bGRAETZ_fig'];
nn = 0;

%% Figure 1
% Plot of Nux_inf versus b*
nn = nn + 1;
figure(nn)
plot(b(domb),Nux_inf(domb),'-ok');
set(gcf,'Color','w');
box on
xlabel('$\tilde{b}$ [-]','Interpreter','LaTex');
ylabel('$\textrm{Nu}_{\infty}$','Interpreter','LaTex');
legend('$\textrm{Nu}_{\infty}$');
legend('Location','SouthEast');
legend('boxoff');
xlim([1e-7 b_max]);
set(gca,'XScale','log','YScale','linear');

tikzfile = [figurefile num2str(nn) '.tikz'];
matlab2tikz(tikzfile, 'height', '\figureheight', 'width', '\figurewidth');
figfile = [figurefile num2str(nn) '.fig'];
saveas(gcf, figfile, 'fig');

% saveas(gcf, 'bGREATZ_fig1.fig', 'fig');
% %print(gcf,'-dpdf','-r300','bGREATZ_fig1');
% matlab2tikz('bGREATZ_fig1.tikz', 'height', '\figureheight', 'width', '\figurewidth','parseStrings',false);

%% Figure 2
% Plot of beta versus b*
nn = nn + 1;
figure(nn)
plot(b(domb),-fit_beta(domb),'-ok');
set(gcf,'Color','w');
box on
xlabel('$\tilde{b}$ [-]','Interpreter','LaTex');
ylabel('$\beta_f$ [-]','Interpreter','LaTex');
legend('$\beta_f$ where $\textrm{Nu}_x \propto (\tilde{x}/\textrm{Gz})^{-\beta}$');
legend('Location','SouthEast');
legend('boxoff');
xlim([1e-7 b_max]);
set(gca,'XScale','log','YScale','linear');

tikzfile = [figurefile num2str(nn) '.tikz'];
matlab2tikz(tikzfile, 'height', '\figureheight', 'width', '\figurewidth');
figfile = [figurefile num2str(nn) '.fig'];
saveas(gcf, figfile, 'fig');

% saveas(gcf, 'bGREATZ_fig2.fig', 'fig');
% %print(gcf,'-dpdf','-r300','bGREATZ_fig2');
% matlab2tikz('bGREATZ_fig2.tikz', 'height', '\figureheight', 'width', '\figurewidth','parseStrings',false);

%% Figure 3
% Combined plot of Nux_inf and beta versus b*
%\definecolor{mycolor2}{rgb}{0.92157,0.25098,0.23137}%
%\definecolor{mycolor6}{rgb}{0.15294,0.26275,0.53725}%
nn = nn + 1;
figure(nn)
hold on
[hax,hline1,hline2] = plotyy(b(domb),(-fit_beta(domb)-1/3)./(1/2-1/3),b(domb),(Nux_inf(domb)-3.66)./(5.78-3.66));
set(hline1,'LineStyle','-','Marker','o','Color',[0.92157,0.25098,0.23137]);
set(hline2,'LineStyle','-','Marker','s','Color',[0.15294,0.26275,0.53725]);
set(hax(1),'XScale','log','ycolor','k','YTick',[0 .25 .5 .75 1],'YTickLabel',{'$1/3$','','$5/12$','','$1/2$'});
set(hax(2),'XScale','log','ycolor','k','YTick',[0 .25 .5 .75 1],'YTickLabel',{'$3.66$','','$4.72$','','$5.78$'});
xlim(hax(1),[1e-5 100]);
xlim(hax(2),[1e-5 100]);
ylim(hax(1),[-0.025 1.025]);
ylim(hax(2),[-0.025 1.025]);
set(gcf,'Color','w');
box on
xlabel('$\tilde{b}$','Interpreter','LaTex');
ylabel(hax(1),'$\beta_f$','Interpreter','LaTex');
ylabel(hax(2),'$\textrm{Nu}_{\infty}$','Interpreter','LaTex');
legend('$\beta_f$','$\textrm{Nu}_{\infty}$');
legend('Location','NorthWest');
legend('boxoff');
% legend(hline1,'$ \beta $','boxoff');
% legend(hline1,'Location','NorthWest');
% legend(hline2,'$\textrm{Nu}_{x} (\infty) $','Location','SouthEast','Box','off','Color', 'none');
% legend([hline1 hline2],'$ \beta $','$\textrm{Nu}_{x} (\infty) $');
% legend(hline1,'Location','NorthWest');
% legend(hline2,'Location','NorthWest');
hold off

tikzfile = [figurefile num2str(nn) '.tikz'];
matlab2tikz(tikzfile, 'height', '\figureheight', 'width', '\figurewidth');
figfile = [figurefile num2str(nn) '.fig'];
saveas(gcf, figfile, 'fig');

% %% Figure 3 - ALTERNATIVE FORM
% % Combined plot of Nux_inf and beta versus b*
% nn = nn + 1;
% figure(nn)
% hold on
% plot(b(domb),(Nux_inf(domb)-3.657)./(5.783-3.657),'-ok');
% plot(b(domb),(-fit_beta(domb)-1/3)./(1/2-1/3),'-sr');
% ylim([0 1]);
% xlim([1e-7 b_max]);
% set(gcf,'Color','w');
% box on
% xlabel('$b^*$ [-]','Interpreter','LaTex');
% ylabel('$\frac{\textrm{Nu}_{x} (\infty) - 3.657}{5.783 - 3.657}$ [-] and $\frac{\beta - 1/3}{1/2 - 1/3}$ [-]','Interpreter','LaTex');
% legend('$\textrm{Nu}_{x} (\infty) $ (normalised)','$ \beta $ (normalised)');
% legend('Location','NorthWest');
% legend('boxoff');
% set(gca,'XScale','log','YScale','linear');
% xlim([1e-7 b_max]);
% ylim([-0.025 1.025]);
% hold off
% 
% tikzfile = [figurefile num2str(nn) '.tikz'];
% matlab2tikz(tikzfile, 'height', '\figureheight', 'width', '\figurewidth');
% figfile = [figurefile num2str(nn) '.fig'];
% saveas(gcf, figfile, 'fig');
% 
% % saveas(gcf, 'bGREATZ_fig3.fig', 'fig');
% % %print(gcf,'-dpdf','-r300','bGREATZ_fig3');
% % matlab2tikz('bGREATZ_fig3.tikz', 'height', '\figureheight', 'width', '\figurewidth','parseStrings',false);

%% Figure 4
% Plot of Nux for various b*
% ONLY ENABLED WHEN nb <= 28
if nb <= 20
    % calculate lines for indicating slopes
    x_slope = logspace(-6,-4,21);
    B_slope13 = 19/((1e-4)^(-1/3));
    Nu_x_slope13 =  B_slope13 .* x_slope.^(-1/3);
    B_slope12 = 70/((1e-4)^(-1/2));
    Nu_x_slope12 =  B_slope12 .* x_slope.^(-1/2);
    
    %map=cbrewer('div','RdYlBu',nb);
    %map=cbrewer('seq','YlGnBu',nb);
    map=cbrewer('seq','OrRdBlGr',nb);
    figure(50)
    xlabel('$\tilde{x}/\textrm{Gz}$','Interpreter','Latex');
    ylabel('$\textrm{Nu}_x$','Interpreter','Latex');
    box on
    set(gcf,'Color','w');
    xlim([1e-7 1]);
    ylim([2 2000]);
    hold on;
  
    for k=1:nb
        h(k)=plot(x(k,:),Nux(k,:),'color',map(k,:));
    end
    
    % annotation of the graph > vertical
%     text(2e-7,125,'$\tilde{b} =$','color',[0.5 0.5 0.5]);
%     plot([4e-7,x(1,15)],[Nux(1,15),Nux(1,15)],'-','color',[0.5 0.5 0.5]);
%     text(2e-7,Nux(1,15),'$0$','color',[0.5 0.5 0.5]);
%     plot([14e-7,x(2,19)],[Nux(2,19),Nux(2,19)],'-','color',[0.5 0.5 0.5]);
%     text(2e-7,Nux(2,19),'$10^{-3}$','color',[0.5 0.5 0.5]);
%     plot([14e-7,x(4,25)],[Nux(4,25),Nux(4,25)],'-','color',[0.5 0.5 0.5]);
%     text(2e-7,Nux(4,25),'$10^{-2}$','color',[0.5 0.5 0.5]);
%     text(2e-3,70,'$\tilde{b} =$','color',[0.5 0.5 0.5]);
%     plot([x(6,36),1.8e-3],[Nux(6,36),Nux(6,36)],'-','color',[0.5 0.5 0.5]);
%     text(2e-3,Nux(6,36),'$10^{-1}$','color',[0.5 0.5 0.5]);
%     plot([x(8,36),1.8e-3],[Nux(8,36),Nux(8,36)],'-','color',[0.5 0.5 0.5]);
%     text(2e-3,Nux(8,36),'$10^{0}$','color',[0.5 0.5 0.5]);
%     plot([x(9,34),1.8e-3],[Nux(9,34),Nux(9,34)],'-','color',[0.5 0.5 0.5]);
%     text(2e-3,Nux(9,34),'$\infty$','color',[0.5 0.5 0.5]);

    % annotation of the graph > horizontal
    % ONLY TRUE IF b = [1e-10 logspace(-3,0,7) b_max];
    text(3.1623e-7,3.66,'\footnotesize{$\tilde{b} =$}','color',[0.5 0.5 0.5],'HorizontalAlignment','center','VerticalAlignment','bottom');
    plot([x(1,12),x(1,12)],[5.5,Nux(1,12)],'-','color',[0.75 0.75 0.75],'LineWidth',0.25);
    text(x(1,12),3.66,'\footnotesize{$0$}','color',[0.5 0.5 0.5],'HorizontalAlignment','center','VerticalAlignment','bottom');
    plot([x(2,19),x(2,19)],[5.5,Nux(2,19)],'-','color',[0.75 0.75 0.75],'LineWidth',0.25);
    text(x(2,19),3.66,'\footnotesize{$10^{-3}$}','color',[0.5 0.5 0.5],'HorizontalAlignment','center','VerticalAlignment','bottom');
    plot([x(4,26),x(4,26)],[5.5,Nux(4,26)],'-','color',[0.75 0.75 0.75],'LineWidth',0.25);
    text(x(4,26),3.66,'\footnotesize{$10^{-2}$}','color',[0.5 0.5 0.5],'HorizontalAlignment','center','VerticalAlignment','bottom');
    plot([x(6,33),x(6,33)],[5.5,Nux(6,33)],'-','color',[0.75 0.75 0.75],'LineWidth',0.25);
    text(x(6,33),3.66,'\footnotesize{$10^{-1}$}','color',[0.5 0.5 0.5],'HorizontalAlignment','center','VerticalAlignment','bottom');
    plot([x(8,40),x(8,40)],[5.5,Nux(8,40)],'-','color',[0.75 0.75 0.75],'LineWidth',0.25);
    text(x(8,40),3.66,'\footnotesize{$10^{0}$}','color',[0.5 0.5 0.5],'HorizontalAlignment','center','VerticalAlignment','bottom');
    plot([x(9,47),x(9,47)],[5.5,Nux(9,47)],'-','color',[0.75 0.75 0.75],'LineWidth',0.25);
    text(x(9,47),3.66,'\footnotesize{$\infty$}','color',[0.5 0.5 0.5],'HorizontalAlignment','center','VerticalAlignment','bottom');
   
    plot(x_slope,Nu_x_slope13,'-k');
    plot(x_slope,Nu_x_slope12,'-k');
    text(1e-5,300,'$\beta_f = \frac{1}{2}$');
    text(1e-5,30,'$\beta_f = \frac{1}{3}$','HorizontalAlignment','right');
        
    % legend1 = legend([h(1),h(nb)],{['$b^* =',num2str(min(b)),'$'],['$b^* =',num2str(max(b)),'$']});
    % legend('boxoff');
    text(1.4,3.66,'$3.66$');
    text(1.4,5.78,'$5.78$');
    set(gca,'XScale','log','YScale','log');
    hold off
    tikzfile = [figurefile num2str(50) '.tikz'];
    matlab2tikz(tikzfile, 'height', '\figureheight', 'width', '\figurewidth');
    figfile = [figurefile num2str(50) '.fig'];
    saveas(gcf, figfile, 'fig');
    
    % figure
    figure(60)
    xlabel('$\tilde{x}/\textrm{Gz}$','Interpreter','Latex');
    ylabel('$\lambda_{T}$ \& $\delta_{\nu}$','Interpreter','Latex');
    box on
    set(gcf,'Color','w');
    hold on;
    for k=1:nb
        h(k)=plot(x(k,:),lambdaT(k,:),'color',map(k,:));
        g(k)=plot(x(k,:),ones(1,length(x(k,:))).*lambdaNu(k),'color',map(k,:),'LineStyle','--');
    end
    set(gca,'XScale','linear','YScale','linear','XLim',[1e-8,0.02],'YLim',[0,1]);
    legend1 = legend([h(1),h(nb)],{['$b^* =',num2str(min(b)),'$'],['$b^* =',num2str(max(b)),'$']});
    legend('boxoff');
    hold off
    cleanfigure;
    tikzfile = [figurefile num2str(60) '.tikz'];
    matlab2tikz(tikzfile, 'height', '\figureheight', 'width', '\figurewidth');
    figfile = [figurefile num2str(60) '.fig'];
    saveas(gcf, figfile, 'fig');
    
%     figure(70)
%     xlabel('$x^*/\textrm{Gz}$ [-]','Interpreter','Latex');
%     ylabel('$\lambda_{T^*}$ [-]','Interpreter','Latex');
%     box on
%     set(gcf,'Color','w');
%     hold on;
%     for k=1:nb
%         h(k)=plot(x(k,:),ones(1,length(x(k,:))).*lambdaNu(k),'color',map(k,:),'LineStyle','--');
%     end
%     set(gca,'XScale','linear','YScale','linear','XLim',[1e-8,0.1],'YLim',[0,1]);
%     legend1 = legend([h(1),h(nb)],{['$b^* =',num2str(min(b)),'$'],['$b^* =',num2str(max(b)),'$']});
%     legend('boxoff');
%     hold off
%     tikzfile = [figurefile num2str(70) '.tikz'];
%     matlab2tikz(tikzfile, 'height', '\figureheight', 'width', '\figurewidth');
%     figfile = [figurefile num2str(70) '.fig'];
%     saveas(gcf, figfile, 'fig');
    
    figure(80)
    xlabel('$\tilde{x}/\textrm{Gz}$','Interpreter','Latex');
    ylabel('$\beta_l$','Interpreter','Latex');
    box on
    set(gcf,'Color','w');
    hold on;
    for k=1:nb
        h(k)=plot(x(k,2:end),beta_local(k,:),'color',map(k,:));
    end
    set(gca,'XScale','log','YScale','linear');
    legend1 = legend([h(1),h(nb)],{['$b^* =',num2str(min(b)),'$'],['$b^* =',num2str(max(b)),'$']});
    legend('boxoff');
    hold off
    tikzfile = [figurefile num2str(80) '.tikz'];
    matlab2tikz(tikzfile, 'height', '\figureheight', 'width', '\figurewidth');
    figfile = [figurefile num2str(80) '.fig'];
    saveas(gcf, figfile, 'fig');
    
    figure(90)
    xlabel('$\tilde{x}/\textrm{Gz}$','Interpreter','Latex');
    ylabel('$\beta_l$','Interpreter','Latex');
    box on
    set(gcf,'Color','w');
    hold on;
    for k=1:nb
        h(k)=plot(x(k,2:end),beta_local(k,:),'color',map(k,:));
        g(k)=plot(x_anal(k,:),beta_anal(k,:),'color',map(k,:),'line','--');
    end
    set(gca,'XScale','log','YScale','linear');
    
    % annotation of the graph
    % ONLY TRUE IF b = [1e-10 logspace(-3,0,7) b_max];
    text(3.1623e-7,0.26,'\footnotesize{$\tilde{b} =$}','color',[0.5 0.5 0.5],'HorizontalAlignment','center','VerticalAlignment','bottom');
    plot([x(1,12),x(1,12)],[0.3,beta_local(1,11)],'-','color',[0.75 0.75 0.75],'LineWidth',0.25);
    text(x(1,12),0.26,'\footnotesize{$0$}','color',[0.5 0.5 0.5],'HorizontalAlignment','center','VerticalAlignment','bottom');
    plot([x(2,19),x(2,19)],[0.3,beta_local(2,18)],'-','color',[0.75 0.75 0.75],'LineWidth',0.25);
    text(x(2,19),0.26,'\footnotesize{$10^{-3}$}','color',[0.5 0.5 0.5],'HorizontalAlignment','center','VerticalAlignment','bottom');
    plot([x(4,26),x(4,26)],[0.3,beta_local(4,25)],'-','color',[0.75 0.75 0.75],'LineWidth',0.25);
    text(x(4,26),0.26,'\footnotesize{$10^{-2}$}','color',[0.5 0.5 0.5],'HorizontalAlignment','center','VerticalAlignment','bottom');
    plot([x(6,33),x(6,33)],[0.3,beta_local(6,32)],'-','color',[0.75 0.75 0.75],'LineWidth',0.25);
    text(x(6,33),0.26,'\footnotesize{$10^{-1}$}','color',[0.5 0.5 0.5],'HorizontalAlignment','center','VerticalAlignment','bottom');
    plot([x(8,40),x(8,40)],[0.3,beta_local(8,39)],'-','color',[0.75 0.75 0.75],'LineWidth',0.25);
    text(x(8,40),0.26,'\footnotesize{$10^{0}$}','color',[0.5 0.5 0.5],'HorizontalAlignment','center','VerticalAlignment','bottom');
    plot([x(9,47),x(9,47)],[0.3,beta_local(9,46)],'-','color',[0.75 0.75 0.75],'LineWidth',0.25);
    text(x(9,47),0.26,'\footnotesize{$\infty$}','color',[0.5 0.5 0.5],'HorizontalAlignment','center','VerticalAlignment','bottom');
    
    legend1 = legend([h(6),g(6)],...
        {'$\beta_l$ numerical','$\beta_l$ analytical'},...
        'Location','SouthWest');
%     legend1 = legend([h(1),g(1),h(nb),g(nb)],...
%         {['$\tilde{b} =',num2str(min(b)),'$ (num.)'],['\tilde{b} =',num2str(min(b)),'$ (anal.)'],...
%         ['$\tilde{b} =',num2str(max(b)),'$ (num.)'],['$\tilde{b} =',num2str(max(b)),'$ (anal.)']},...
%         'Location','SouthWest');
    legend('boxoff');
    xlim([1e-7 1]);
    ylim([-0.05 0.55]);
    set(gca,'YTick',[0:0.1:0.5])
    hold off
    tikzfile = [figurefile num2str(90) '.tikz'];
    matlab2tikz(tikzfile, 'height', '\figureheight', 'width', '\figurewidth');
    figfile = [figurefile num2str(90) '.fig'];
    saveas(gcf, figfile, 'fig');
    print(gcf,'-dpdf','-r300',figfile);
else
end

%% Figure 5
% Plot of alpha versus b*
% figure(13)
% [haxes,hline1,hline2] = plotyy(b(domb),fit_alpha(domb),b(domb),10.^(fit_alpha(domb)));
% set(hline1,'LineStyle','-','Color','k','Marker','o','MarkerEdgeColor','k');
% set(hline2,'LineStyle','-','Color','r','Marker','s','MarkerEdgeColor','r');
% axes(haxes(1));
% ylabel('\alpha [-]')
% axes(haxes(2));
% ylabel('10^{\alpha} [-]')
% set(gcf,'Color','w');
% box on
% xlabel('$b^*$ [-]','Interpreter','LaTex');
% legend('$\alpha$ where $ \log{Nu_x} = \alpha - \beta \log{(x^*/Gz)}$ [-]','$10^{\alpha}$');
% legend('Location','SouthEast');
% legend('boxoff');
% set(gca,'XScale','log','YScale','linear');

nn = nn + 1;
figure(nn)
plot(b(domb),10.^(fit_alpha(domb)),'-ok');
%plot(b(domb),fit_alpha(domb),'-ok');
set(gcf,'Color','w');
box on
xlabel('$\tilde{b}$ [-]','Interpreter','LaTex');
ylabel('$A = 10^{\alpha}$ [-]','Interpreter','LaTex');
legend('$A = 10^{\alpha}$ where $ \textrm{Nu}_x = A (\tilde{b}/\textrm{Gz})^{-\beta}$');
legend('Location','NorthWest');
legend('boxoff');
%ylim([0.25 1.25]);
ylim([0.25 1.25]);
xlim([1e-7 b_max]);
set(gca,'YTick',0.25:0.25:1.25);
set(gca,'XScale','log','YScale','linear');
text(1e-6,0.8,['$\alpha = ',num2str(fit_alphasmall),'$']);
text(1e-6,0.875,['$A = ',num2str(10^fit_alphasmall),'$']);
text(1e0,0.65,['$\alpha = ',num2str(fit_alphalarge),'$']);
text(1e0,0.725,['$A = ',num2str(10^fit_alphalarge),'$']);

tikzfile = [figurefile num2str(nn) '.tikz'];
matlab2tikz(tikzfile, 'height', '\figureheight', 'width', '\figurewidth');
figfile = [figurefile num2str(nn) '.fig'];
saveas(gcf, figfile, 'fig');

% saveas(gcf, 'bGREATZ_fig5.fig', 'fig');
% %print(gcf,'-dpdf','-r300','bGREATZ_fig5');
% matlab2tikz('bGREATZ_fig5.tikz', 'height', '\figureheight', 'width', '\figurewidth','parseStrings',false);

%% Figure 6
% Plot of grad Nux_inf versus b*
nn = nn + 1;
figure(nn)
plot(b(domb),gradNux_inf(domb),'-ok');
set(gcf,'Color','w');
box on
xlabel('$\tilde{b}$','Interpreter','LaTex');
ylabel('$\frac{\partial \textrm{Nu}_{\infty}}{\partial b^*} $','Interpreter','LaTex');
legend('$\frac{\partial \textrm{Nu}_{\infty}}{\partial b^*} $');
legend('Location','NorthEast');
legend('boxoff');
xlim([1e-7 b_max]);
set(gca,'XScale','log','YScale','linear');

tikzfile = [figurefile num2str(nn) '.tikz'];
matlab2tikz(tikzfile, 'height', '\figureheight', 'width', '\figurewidth');
figfile = [figurefile num2str(nn) '.fig'];
saveas(gcf, figfile, 'fig');

% saveas(gcf, 'bGREATZ_fig6.fig', 'fig');
% %print(gcf,'-dpdf','-r300','bGREATZ_fig6');
% matlab2tikz('bGREATZ_fig6.tikz', 'height', '\figureheight', 'width', '\figurewidth','parseStrings',false);

%% Figure 7
% Plot of grad beta versus b*
nn = nn + 1;
figure(nn)
plot(b(domb),gradbeta(domb),'-ok');
set(gcf,'Color','w');
box on
xlabel('$\tilde{b}$','Interpreter','LaTex');
ylabel('$-\frac{\partial \beta}{\partial \tilde{b}} $','Interpreter','LaTex');
legend('$-\frac{\partial \beta}{\partial \tilde{b}} $');
legend('Location','NorthEast');
legend('boxoff');
xlim([1e-7 b_max]);
set(gca,'XScale','log','YScale','linear');

tikzfile = [figurefile num2str(nn) '.tikz'];
matlab2tikz(tikzfile, 'height', '\figureheight', 'width', '\figurewidth');
figfile = [figurefile num2str(nn) '.fig'];
saveas(gcf, figfile, 'fig');

% saveas(gcf, 'bGREATZ_fig7.fig', 'fig');
% %print(gcf,'-dpdf','-r300','bGREATZ_fig7');
% matlab2tikz('bGREATZ_fig7.tikz', 'height', '\figureheight', 'width', '\figurewidth','parseStrings',false);

%% Figure 8
% Plot of grad beta versus b*
nn = nn + 1;
figure(nn)
plot(b(domb),gradalpha(domb),'-ok');
set(gcf,'Color','w');
box on
xlabel('$\tilde{b}$','Interpreter','LaTex');
ylabel('$\frac{\partial \alpha}{\partial \tilde{b}} $','Interpreter','LaTex');
legend('$\frac{\partial \alpha}{\partial \tilde{b}} $');
legend('Location','NorthWest');
legend('boxoff');
xlim([1e-7 b_max]);
set(gca,'XScale','log','YScale','linear');

tikzfile = [figurefile num2str(nn) '.tikz'];
matlab2tikz(tikzfile, 'height', '\figureheight', 'width', '\figurewidth');
figfile = [figurefile num2str(nn) '.fig'];
saveas(gcf, figfile, 'fig');

% saveas(gcf, 'bGREATZ_fig8.fig', 'fig');
% %print(gcf,'-dpdf','-r300','bGREATZ_fig8');
% matlab2tikz('bGREATZ_fig8.tikz', 'height', '\figureheight', 'width', '\figurewidth','parseStrings',false);

%% Figure 9
% Beta by calculating y-intercept
nn = nn + 1;
figure(nn)
format shortg
hold on
box on
set(gcf,'Color','w');
plot(b_sel,-beta0_sel-0.3377,'-ok');
plot(b_sel,-beta0_line-0.3377,':+r');
hold off
xlabel('$\tilde{b}$','Interpreter','LaTex');
ylabel('$-\beta - 0.3377 $','Interpreter','LaTex');
legend('$-\beta - 0.3377 $');
legend('boxoff');
xlim([0 10e-7]);
text(1e-7,0.337722-0.3377,['$\beta_0 - 0.3377 = ',num2str(-fit_beta0-0.3377),'$']);
text(1e-7,0.337720-0.3377,['$-\frac{\partial \beta}{\partial \tilde{b}} = ',num2str(-fit_A),'$']);
format short

tikzfile = [figurefile num2str(nn) '.tikz'];
matlab2tikz(tikzfile, 'height', '\figureheight', 'width', '\figurewidth');
figfile = [figurefile num2str(nn) '.fig'];
saveas(gcf, figfile, 'fig');

% saveas(gcf, 'bGREATZ_fig9.fig', 'fig');
% %print(gcf,'-dpdf','-r300','bGREATZ_fig8');
% matlab2tikz('bGREATZ_fig9.tikz', 'height', '\figureheight', 'width', '\figurewidth','parseStrings',false);

%% More figures

% Calculation of velocity and derivatives of velocity at the wall r* = 1
% for explaning the transition point of Nu_x (infty)
u_s = 4.*b ./ (1 + 4.*b); % at r* = 1
u_s_scaled = 4.*b ./ (1 + 4.*b) .* (max(Nux_inf)-min(Nux_inf)) + min(Nux_inf); % at r* = 1

du_sdb = 4 ./ (1 + 4.*b).^2;
du_sdb_scaled = max(gradNux_inf) ./ (1 + 4.*b).^2;

dudr = -4 ./ (1 + 4.*b); % at r* = 1
dudr_scaled = -4 ./ (1 + 4.*b) ./ -4 .* (max(Nux_inf)-min(Nux_inf)) + min(Nux_inf); %(min(Nux_inf)-max(Nux_inf)) + max(Nux_inf); % at r* = 1

morefig = 'on';
if morefig == 'on'
    
    nn = 20;
    nn = nn + 1;
    
    figure(nn)
    hold on
    [hax2,hline1,hline2] = plotyy(b,(Nux_inf-3.66)./(5.78-3.66),b,u_s);
    %[hax2,hline1,hline2] = plotyy(b,(Nux_inf-3.66)./(5.78-3.66),b,dudr);
    set(hline1,'LineStyle','-','Marker','s','Color',[0.15294,0.26275,0.53725]);
    set(hline2,'LineStyle','-','Color',[0.92157,0.25098,0.23137]);
    set(hax2(1),'XScale','log','ycolor','k','YTick',[0 .25 .5 .75 1],'YTickLabel',{'$3.66$','','$4.72$','','$5.78$'});
    set(hax2(2),'XScale','log','ycolor','k','YTick',[0 .25 .5 .75 1],'YTickLabel',{'$0$','','$0.5$','','$1$'});
    %set(hax2(2),'XScale','log','ycolor','k','YTick',[-4 -3 -2 -1 0],'YTickLabel',{'$-4$','','$-2$','','$0$'});
    xlim(hax2(1),[b(1) b(end)]);
    xlim(hax2(2),[b(1) b(end)]);
    ylim(hax2(1),[-0.025 1.025]);
    ylim(hax2(2),[-0.025 1.025]);
    %ylim(hax2(2),[-4.1 0.1]);
    set(gcf,'Color','w');
    box on
    xlabel('$\tilde{b}$','Interpreter','LaTex');
    ylabel(hax2(1),'$\textrm{Nu}_{\infty}$','Interpreter','LaTex');
    ylabel(hax2(2),'$\tilde{u}_s$','Interpreter','LaTex');
    %ylabel(hax2(2),'$\left. \frac{\partial \tilde{u}}{\partial \tilde{r}} \right|_{\tilde{r}=1}$','Interpreter','LaTex');
    legend('$\textrm{Nu}_{\infty}$','$\tilde{u}_s$');
    %legend('$\textrm{Nu}_x^{\infty}$','$\left. \frac{\partial \tilde{u}}{\partial \tilde{r}} \right|_{\tilde{r}=1}$');
    legend('Location','NorthWest');
    legend('boxoff');
    hold off
    
%     hold on
%     plot(b(domb),Nux_inf(domb),'-ok');
%     plot(b(domb),u_scaled(domb),'-r');
%     plot(b(domb),dudr_scaled(domb),'--b');
%     set(gcf,'Color','w');
%     box on
%     xlabel('$b^*$ [-]','Interpreter','LaTex');
%     ylabel('$\textrm{Nu}_{x} (\infty)$ [-]','Interpreter','LaTex');
%     legend('$\textrm{Nu}_{x} (\infty)$','$u_x$','$u_x$ (scaled)');
%     legend('Location','SouthWest');
%     legend('boxoff');
%     xlim([min(b) max(b)]);
%     set(gca,'XScale','log','YScale','linear');
%     hold off
    
    tikzfile = [figurefile num2str(nn) '.tikz'];
    matlab2tikz(tikzfile, 'height', '\figureheight', 'width', '\figurewidth');
    figfile = [figurefile num2str(nn) '.fig'];
    saveas(gcf, figfile, 'fig');
    
    nn = nn + 1;
    figure(nn)
    
    hold on
    plot(b(domb),gradNux_inf(domb),'-ok');
    plot(b(domb),du_sdb(domb),'--r');
    plot(b(domb),du_sdb_scaled(domb),'-r');
    plot(b(domb),-dudr(domb),'--b');
    plot(b(domb),-dudr_scaled(domb),'-b');
    set(gcf,'Color','w');
    box on
    xlabel('$\tilde{b}$','Interpreter','LaTex');
    ylabel('$\frac{\partial \textrm{Nu}_{\infty}}{\partial \tilde{b}} $','Interpreter','LaTex');
    legend('$\frac{\partial \textrm{Nu}_{\infty}}{\partial \tilde{b}} $','$ \frac{\partial u_{x}}{\partial \tilde{b}}$','$ \frac{\partial u_{x}}{\partial \tilde{b}}$ (scaled)',...
        '$\left| \frac{\partial u_{x}}{\partial \tilde{r}} \right|$','$\left| \frac{\partial u_{x}}{\partial \tilde{r}} \right|$ (scaled)');
    legend('Location','SouthWest');
    legend('boxoff');
    xlim([1e-7 b_max]);
    set(gca,'XScale','log','YScale','linear');
    hold off
    
    tikzfile = [figurefile num2str(nn) '.tikz'];
    matlab2tikz(tikzfile, 'height', '\figureheight', 'width', '\figurewidth');
    figfile = [figurefile num2str(nn) '.fig'];
    saveas(gcf, figfile, 'fig');
    
    nn = nn + 1;
    figure(nn)
    hold on
    plot(b(domb),-fit_beta(domb),'-ok');
    plot(b(domb),-fit_delta(domb),'-+r');
    set(gcf,'Color','w');
    box on
    xlabel('$\tilde{b}$','Interpreter','LaTex');
    ylabel('$\beta_f$ and $\delta$','Interpreter','LaTex');
    legend('$\beta_f$','$\delta$, $\left. \frac{\partial \Theta}{\partial \tilde{r}} \right|_{\tilde{r} = 1} \propto \left( \frac{\tilde{x}}{\textrm{Gz}} \right)^{-\delta}$');
    legend('Location','SouthEast');
    legend('boxoff');
    xlim([1e-7 b_max]);
    set(gca,'XScale','log','YScale','linear');
    
    tikzfile = [figurefile num2str(nn) '.tikz'];
    matlab2tikz(tikzfile, 'height', '\figureheight', 'width', '\figurewidth');
    figfile = [figurefile num2str(nn) '.fig'];
    saveas(gcf, figfile, 'fig');
    hold off
    
    nn = nn + 1;
    %\definecolor{mycolor2}{rgb}{0.92157,0.25098,0.23137}%
    %\definecolor{mycolor6}{rgb}{0.15294,0.26275,0.53725}%
    figure(nn)
    hold on
    plot(xGz12,b,'-s','Color',[0.15294,0.26275,0.53725]);
    plot(xGz13,b,'-o','Color',[0.92157,0.25098,0.23137]);
    set(gcf,'Color','w');
    box on
    ylabel('$\tilde{b}$','Interpreter','LaTex');
    xlabel('$\tilde{x}/\textrm{Gz}$','Interpreter','LaTex');
    legend('$(\tilde{x}/\textrm{Gz})_{\frac{1}{2}}$','$(\tilde{x}/\textrm{Gz})_{\frac{1}{3}}$');
    legend('Location','NorthWest');
    legend('boxoff');
    ylim([b(1) b(end)]);
    xlim([1e-7 1e-3])
    set(gca,'XScale','log','YScale','log');
    text(1e-4,2e-3,'$\beta_l \rightarrow \frac{1}{3}$','HorizontalAlignment','center');
    text(3e-5,6e-2,'$\frac{1}{3} < \beta_l < \frac{1}{2}$','HorizontalAlignment','center');
    text(1e-5,1e0,'$\beta_l \rightarrow \frac{1}{2}$','HorizontalAlignment','center');
    
    tikzfile = [figurefile num2str(nn) '.tikz'];
    matlab2tikz(tikzfile, 'height', '\figureheight', 'width', '\figurewidth');
    figfile = [figurefile num2str(nn) '.fig'];
    saveas(gcf, figfile, 'fig');
    hold off
else
end
