***Data for Interdependence and Trust Analysis (ITA): a Framework for Human-Machine Team Design***

Authors: C. Centeio Jorge, C. M. Jonker, M. L. Tielman
Interactive Intelligence group, Intelligent Systems Department, EEMCS Faculty, Delft University of Technology

Corresponding Author: C. Centeio Jorge

Contact Information: 

C<dot>Jorge<at>tudelft<dot>nl

Van Mourik Broekmanweg 6
2628 XE Delft
The Netherlands

***General Introduction***
This data was collected during the evaluation of the Interdependence and Trust Analysis (ITA) table. It corresponds to the transcripts and thematic analysis of a focus group. We have submitted a paper which presents the results and full methodology, but it is not published yet.

***Data collection***
The data was collected in an online session through MS Teams, which lasted one hour and a half. The session included five participants and the main author as a moderator. Participants started by being presented to the main concept of interdependence and the different interdependence configurations in a human-agent team. After this, we presented the ITA table pre-filled with a cooking example. Finally, participants were given the use case, about a search and rescue scenario for firefighters, and twenty minutes to complete a new ITA table together, regarding the presented use case. They were asked to think out loud. After this, the participants were asked four different questions.

***Data analysis***
The transcripts were anonymised after the session and were divided into five parts, each originating a different coding scheme through a thematic analysis.
We divided the transcripts collected during the activity, and then for each question, Q1-Q4.
The first author (CCJ) and a double-coder went through the transcripts and wrote down some labels that came to mind related to comments or questions that may affect the usability of the table. Both coders met to discuss the labels and reach an agreement on the coding scheme. After agreeing on the coding scheme, both coders coded the utterances separately.
Both coders met one final time to agree on the coding. During this meeting, some codes were merged.

***Description of the data in this data set***
* “Final Coding scheme” sheet: the coding scheme which resulted from the data analysis. It contains the following columns:
    - ID: unique identifier given to the label/code.
    - Theme: some labels/codes may have an overarching theme. If they do, it is presented in this column.
    - name: name of the code/label.
    - description: description of the code/label.
* “Transcripts” sheet includes the transcripts that were used for the thematic analysis. They only include the relevant utterances. It contains the following columns:
    - ID: unique identifier given to the utterance.
    - Phase: which of the five phases included the utterance.
    - Quote: the transcript of the utterance.
    - Columns Label 1,2 and 3: the labels/codes given to the respective utterance.
* “Code match” sheet: It includes the final discussion of codes between the coders. It includes the following columns:
    - Utterance: the ID of the utterance corresponding to “Trancripts” sheet.
    - Coder1: Code/label given by coder 1 (CCJ).
    - Coder2: Code/label given by the double-coder.
    - Result in case of disagreement: what was decided to have as code/label for that utterance, when Coder1 and Coder2 are not the same.