function derr = errorLift(d1cSensors,staf)
if length(unique(d1cSensors)) ~= length(d1cSensors)
    derr = 1e6;
    return;
end
d1cSensors = sort(d1cSensors);

d2polars = staf.d2polars(:,[1:3,5]);

d1prob = staf.d1prob;

[~,iLEairfoil] = min(staf.d2geom(:,1));
d1cCp = [1 - staf.d2geom(1:iLEairfoil,1);1 + staf.d2geom(iLEairfoil+1:end,1)];

d2cpSensors = interp1(d1cCp,staf.d2cp(2:end,2:end)',d1cSensors');
d2cpInterp = interp1(d1cSensors',d2cpSensors,d1cCp,'linear','extrap');

d2polarsDer = polarsFromCp(staf.d2geom,d2cpInterp,staf.d2cp(2:end,1));

d1Eweighed = sum(abs(d2polarsDer(:,2:end) - d2polars(:,2:end)).*d1prob,1);

derr = d1Eweighed(1);
end