
# Perceived Risk and Trust Data in a Merging and Hard Braking Scenario

## Description
This dataset accompanies the paper "Modelling Perceived Risk and Trust in Driving Automation: Reactions to Merging and Braking Vehicles". It includes subjective ratings of perceived risk and trust from human drivers. These ratings were collected during a simulator experiment that involved reactions to merging and hard-braking vehicles.

## File Structure
- An Excel sheet containing subjective ratings and processed kinetic data intended for regression analysis.
- MAT files that hold the kinetic data collected during the simulator experiment.

## Data Format
It is recommended to open the `.mat` files using MATLAB.

### Variables in MAT Files in folder `Kinetic Data`
- `x_s`, `x_n`: Longitudinal positions of the subject and neighboring vehicles, respectively (in meters).
- `y_s`, `y_n`: Lateral positions of the subject and neighboring vehicles, respectively (in meters).
- `vx_s`, `vx_n`: Longitudinal velocities of the subject and neighboring vehicles, respectively (in m/s).
- `vy_s`, `vy_n`: Lateral velocities of the subject and neighboring vehicles, respectively (in m/s).
- `ax_s`, `ax_n`: Longitudinal accelerations of the subject and neighboring vehicles, respectively (in m/s^2).
- `ay_s`, `ay_n`: Lateral accelerations of the subject and neighboring vehicles, respectively (in m/s^2).
- `DriverBrake`: Driver's braking pedal position, represented as a value between 0 and 1 (where 0 means no braking and 1 indicates full braking).
- `PR_continuous`: Continuous subjective ratings of perceived risk, collected via a pressure button.
- `PR_discrete`: An 18x4 matrix. The first column represents the initial merging gap, the second column indicates braking intensity, the third column marks the index at which the minimum gap occurs during the event, and the fourth column contains the perceived risk ratings.

### Variables in Excel Sheet `SubjectiveRatings.xlsx`
- `REP`: Repetition number, with 1 indicating the first exposure and 2 indicating the second.
- `PR`: Perceived risk ratings.
- `TRU`: Trust ratings.
- `IMG`: Initial merging gap (in meters).
- `BI`: Braking intensity (in m/s^2).
- `min_gap`: The minimum gap to the leading vehicle during the event (in meters).
- `min_speed`: The minimum speed of the subject vehicle during the event (in m/s).
- `min_TTC`: The minimum time to collision with the leading vehicle during the event (in seconds).
- `min_THW`: The minimum time headway during the event (in seconds).
- `max_brake`: The maximum brake applied by the human driver during the event (ranging from 0 to 1).
- `AGE`: Age of the participant (in years).
- `GEN`: Gender of the participants, where 1 is male and 2 is female.
- `AE`: Automation experience. 0 means no driving automation experience. 1 indicates experience with adaptive cruise control, 2 indicates experience with a lane-centering system, and 3 indicates experience with both.

## Licenses or Restrictions
Intended for academic use.

## Contact Information
For any questions, please contact Xiaolin He at x.he-2@tudelft.nl.
