% script to load h5 statistics data and make some basic plots

% load algae statistical kinematics distributions

loadname = 'AlgaeStatisticalKinematics.h5';

% colormaps
cmap_wyrk = h5read(loadname,['/cmaps/cmap_wyrk']);
cmap_bwr  = h5read(loadname,['/cmaps/cmap_bwr']);

% interactions - near
if 1
    % X - all contact
    X_jpdf_ALL_X2d  = h5read(loadname,['/interact_near/X_jpdf_all/X2d']);
    X_jpdf_ALL_Z    = h5read(loadname,['/interact_near/X_jpdf_all/Z']);
    X_jpdf_ALL_P    = h5read(loadname,['/interact_near/X_jpdf_all/P']);
        figure
        imagesc(X_jpdf_ALL_X2d,X_jpdf_ALL_Z,X_jpdf_ALL_P)
        colormap(cmap_wyrk)
        set(gca,'YDir','normal')
        set(gca,'TickLabelInterpreter','latex','FontSize',16,'LineWidth',2)
        xlabel('$x^{\star}_{2D}$','Interpreter','latex')
        ylabel('$z^{\star}$','Interpreter','latex')
end
if 1
    % X - noncontact
    X_jpdf_NC_X2d  = h5read(loadname,['/interact_near/X_jpdf_noncontact/X2d']);
    X_jpdf_NC_Z    = h5read(loadname,['/interact_near/X_jpdf_noncontact/Z']);
    X_jpdf_NC_P    = h5read(loadname,['/interact_near/X_jpdf_noncontact/P']);
        figure
        imagesc(X_jpdf_NC_X2d,X_jpdf_NC_Z,X_jpdf_NC_P)
        colormap(cmap_wyrk)
        set(gca,'YDir','normal')
        set(gca,'TickLabelInterpreter','latex','FontSize',16,'LineWidth',2)
        xlabel('$x^{\star}_{2D}$','Interpreter','latex')
        ylabel('$z^{\star}$','Interpreter','latex')
end
if 1
    % X - contact
    X_jpdf_C_X2d  = h5read(loadname,['/interact_near/X_jpdf_contact/X2d']);
    X_jpdf_C_Z    = h5read(loadname,['/interact_near/X_jpdf_contact/Z']);
    X_jpdf_C_P    = h5read(loadname,['/interact_near/X_jpdf_contact/P']);
        figure
        imagesc(X_jpdf_C_X2d,X_jpdf_C_Z,X_jpdf_C_P)
        colormap(cmap_wyrk)
        set(gca,'YDir','normal')
        set(gca,'TickLabelInterpreter','latex','FontSize',16,'LineWidth',2)
        xlabel('$x^{\star}_{2D}$','Interpreter','latex')
        ylabel('$z^{\star}$','Interpreter','latex')
end
   
if 1
    % udot thetadot jpdf
    thetadot_udot_jpdf_ALL_tdot    = h5read(loadname,['/interact_near/jpdf_thetadot_udot/tdot']);
    thetadot_udot_jpdf_ALL_udot    = h5read(loadname,['/interact_near/jpdf_thetadot_udot/udot']);
    thetadot_udot_jpdf_ALL_P       = h5read(loadname,['/interact_near/jpdf_thetadot_udot/P']);
        figure
        imagesc(thetadot_udot_jpdf_ALL_tdot,thetadot_udot_jpdf_ALL_udot,thetadot_udot_jpdf_ALL_P)
        colormap(cmap_wyrk)
        set(gca,'YDir','normal')
        set(gca,'TickLabelInterpreter','latex','FontSize',16,'LineWidth',2)
        xlabel('$\dot{\theta}^{\star}$','Interpreter','latex')
        ylabel('$\dot{u}^{\star}$','Interpreter','latex')
end
    
if 1
    
    % theta_out vs theta_in - noncontact
    theta_jpdf_NC_thetain   = h5read(loadname,['/interact_near/jpdf_theta_inout_noncontact/thetain']);
    theta_jpdf_NC_thetaout  = h5read(loadname,['/interact_near/jpdf_theta_inout_noncontact/thetaout']);
    theta_jpdf_NC_P         = h5read(loadname,['/interact_near/jpdf_theta_inout_noncontact/P']);
        figure
        imagesc(theta_jpdf_NC_thetain,theta_jpdf_NC_thetaout,theta_jpdf_NC_P)
        colormap(cmap_wyrk)
        set(gca,'YDir','normal')
        set(gca,'TickLabelInterpreter','latex','FontSize',16,'LineWidth',2)
        xlabel('$\theta_{in}$','Interpreter','latex')
        ylabel('$\theta_{out}$','Interpreter','latex')

end

if 1
    % theta_out vs theta_in - contact
    theta_jpdf_C_thetain   = h5read(loadname,['/interact_near/jpdf_theta_inout_contact/thetain']);
    theta_jpdf_C_thetaout  = h5read(loadname,['/interact_near/jpdf_theta_inout_contact/thetaout']);
    theta_jpdf_C_P         = h5read(loadname,['/interact_near/jpdf_theta_inout_contact/P']);
        figure
        imagesc(theta_jpdf_C_thetain,theta_jpdf_C_thetaout,theta_jpdf_C_P)
        colormap(cmap_wyrk)
        set(gca,'YDir','normal')
        set(gca,'TickLabelInterpreter','latex','FontSize',16,'LineWidth',2)
        xlabel('$\theta_{in}$','Interpreter','latex')
        ylabel('$\theta_{out}$','Interpreter','latex')
end

if 1
    % conditional rotational kinematics
    Omega_t_cdf_bins   = h5read(loadname,['/diffusive_swimming/Omega_t/bins']);
    Omega_t_cdf_P      = h5read(loadname,['/diffusive_swimming/Omega_t/P']);
    Omega_b_cdf_bins   = h5read(loadname,['/diffusive_swimming/Omega_b/bins']);
    Omega_b_cdf_P      = h5read(loadname,['/diffusive_swimming/Omega_b/P']);
        figure
        imagesc(Omega_t_cdf_bins,Omega_t_cdf_bins,Omega_t_cdf_P')
        colormap(cmap_wyrk)
        set(gca,'YDir','normal')
        set(gca,'TickLabelInterpreter','latex','FontSize',16,'LineWidth',2)
        xlabel('$\Omega_t\left( t \right)$','Interpreter','latex')
        ylabel('$\Omega_t\left( t + \Delta t\right)$','Interpreter','latex')
        figure
        imagesc(Omega_b_cdf_bins,Omega_b_cdf_bins,Omega_b_cdf_P')
        colormap(cmap_wyrk)
        set(gca,'YDir','normal')
        set(gca,'TickLabelInterpreter','latex','FontSize',16,'LineWidth',2)
        xlabel('$\Omega_b\left( t \right)$','Interpreter','latex')
        ylabel('$\Omega_b\left( t + \Delta t\right)$','Interpreter','latex')
        
end

if 1    
    % interactions - far
    thetadot_cdf_theta      = h5read(loadname,['/interact_far/thetadot/Thetabins_coarse']);
    thetadot_cdf_z          = h5read(loadname,['/interact_far/thetadot/Hbins_coarse']);
    thetadot_cdf_thetadot   = h5read(loadname,['/interact_far/thetadot/thetadot_mean']);
        figure
        imagesc(thetadot_cdf_theta,thetadot_cdf_z,thetadot_cdf_thetadot)
        colormap(cmap_bwr)
        set(gca,'YDir','normal')
        set(gca,'TickLabelInterpreter','latex','FontSize',16,'LineWidth',2)
        xlabel('$\theta$','Interpreter','latex')
        ylabel('$z^{\star}$','Interpreter','latex')
        pbaspect([1 2 1])
        caxis([-0.09 0.09])
    % Note: full conditional distributions of thetadot are also available in the /interact_far/thetadot/ group
end

if 1
    % density profiles
    rho_z      = h5read(loadname,['/density/exp/z']);
    rho_exp      = h5read(loadname,['/density/exp/rho']);
    rho_scattermeas_tdotoff      = h5read(loadname,['/density/scattermeas_tdotoff/rho']);
    rho_scattermeas_tdoton      = h5read(loadname,['/density/scattermeas_tdoton/rho']);
    rho_scatterrand_tdotoff      = h5read(loadname,['/density/scatterrand_tdotoff/rho']);
    rho_scatterrand_tdoton      = h5read(loadname,['/density/scatterrand_tdoton/rho']);
        figure
        plot(rho_z,rho_exp,'ob')
        hold on
        plot(rho_z,rho_scattermeas_tdotoff,'g+')
        plot(rho_z,rho_scattermeas_tdoton,'gs')
        plot(rho_z,rho_scatterrand_tdotoff,'r+')
        plot(rho_z,rho_scatterrand_tdoton,'rs')        
        set(gca,'TickLabelInterpreter','latex','FontSize',16,'LineWidth',2)
        xlabel('$z^{\star}$','Interpreter','latex')
        ylabel('$\rho / \rho_{bulk} - 1$','Interpreter','latex')
        pbaspect([1 1 1])
        set(gca,'XScale','log')
        set(gca,'YScale','log')
        axis([1 100 0.01 10])
end






