import numpy as np
import statsmodels.api as sm


def hsig(values):
    """
    return mean of top 30% values for wave height (significant wave height
    :param values: 1D array of wave heights
    :return: scalar value for significant wave height
    """

    if values.size == 0:
        return np.nan

    minlim = np.percentile(values, 70)
    sig_values = values[values >= minlim]

    # return mean if there are too few values
    if sig_values.size == 0:
        return np.mean(values)

    return np.mean(sig_values)


def weighted_linear_regression(x, y, z):
    x = sm.add_constant(x)
    wls_model = sm.WLS(y, x, weights=z)
    results = wls_model.fit()
    return results.params


def slope(x, y, weights=None):
    if weights is None:
        weights = np.ones(x.shape)
    c, slope = weighted_linear_regression(x, y, weights)
    return slope

