from matplotlib.backends import qt4_compat
from PyQt4 import QtGui, QtCore
from matplotlib.backends.backend_qt4agg import FigureCanvasQTAgg as FigureCanvas
from matplotlib.figure import Figure


class CustomCanvas(FigureCanvas):
    """Ultimately, this is a QWidget (as well as a FigureCanvasAgg, etc.)."""
    def __init__(self, fig, parent=None):
        super(CustomCanvas, self).__init__(fig)
        self.setParent(parent)

        self.setSizePolicy(QtGui.QSizePolicy.Minimum,
                           QtGui.QSizePolicy.Minimum)
        self.updateGeometry()

    def resizeEvent(self, event=None):
        self.updateGeometry()
        self.draw()


if __name__ == '__main__':
    import numpy as np
    from matplotlib import pyplot as plt

    import sys
    from PyQt4 import QtGui

    app = QtGui.QApplication(sys.argv)

    x = np.arange(100)
    y = np.random.rand(100)

    fig = plt.figure()
    ax = fig.gca()
    ax.plot([1, 2, 3], [2, 4, 8])
    canvas = CustomCanvas(fig)
    canvas.show()

    sys.exit(app.exec_())


