import logging



def setup(modules='sandwaves', handler=None, level='INFO', fmt="%(levelname)s :: %(name)s :: %(message)s"):
    if handler is None:
        class Handler(logging.Handler):

            def emit(self, record):
                try:
                    msg = self.format(record)
                    print(msg)
                except (KeyboardInterrupt, SystemExit):
                    raise
                except:
                    self.handleError(record)

        handler = Handler()

    if not isinstance(modules, (list, tuple)):
        modules = [modules]

    if not isinstance(fmt, logging.Formatter):
        fmt = logging.Formatter(fmt)

    handler.setLevel(logging.DEBUG)
    handler.setFormatter(fmt)

    for i, m in enumerate(modules):
        if not isinstance(m, str):
            try:
                m = m.__module__ + m.__name__
            except AttributeError:
                m = m.__name__

        l = logging.getLogger(m)
        l.setLevel(level)
        l.addHandler(handler)
        l.info('logger {!r} created at level {}'.format(m, level[i]))
